/*
 * Decompiled with CFR 0.152.
 */
package com.mr208.treechoppin.common.handler;

import com.mr208.treechoppin.common.tree.Tree;
import com.mr208.treechoppin.core.TreeChoppin;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.tags.ItemTags;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;

public class TreeHandler {
    private static Map<UUID, Tree> m_Trees = new HashMap<UUID, Tree>();
    private Tree tree;

    private static <T> T getLastElement(Iterable<T> elements) {
        Iterator<T> itr = elements.iterator();
        T lastElement = itr.next();
        while (itr.hasNext()) {
            lastElement = itr.next();
        }
        return lastElement;
    }

    public int AnalyzeTree(World world, BlockPos blockPos, PlayerEntity entityPlayer) {
        LinkedList<Object> queuedBlocks = new LinkedList<Object>();
        HashSet<BlockPos> tmpBlocks = new HashSet<BlockPos>();
        HashSet<BlockPos> checkedBlocks = new HashSet<BlockPos>();
        Block logBlock = world.func_180495_p(blockPos).func_177230_c();
        this.tree = new Tree();
        queuedBlocks.add(blockPos);
        this.tree.InsertWood(blockPos);
        while (!queuedBlocks.isEmpty()) {
            BlockPos currentPos = (BlockPos)queuedBlocks.remove();
            checkedBlocks.add(currentPos);
            tmpBlocks.addAll(this.LookAroundBlock(logBlock, currentPos, world, checkedBlocks));
            queuedBlocks.addAll(tmpBlocks);
            checkedBlocks.addAll(tmpBlocks);
            tmpBlocks.clear();
        }
        HashSet<BlockPos> tmpLeaves = new HashSet<BlockPos>();
        tmpLeaves.addAll(this.tree.GetM_Leaves());
        for (BlockPos blockPos1 : tmpLeaves) {
            checkedBlocks.add(blockPos1);
            this.LookAroundBlock(null, blockPos1, world, checkedBlocks);
        }
        this.tree.setM_Position(blockPos);
        m_Trees.put(entityPlayer.func_110124_au(), this.tree);
        return this.tree.GetLogCount();
    }

    private Queue<BlockPos> LookAroundBlock(Block logBlock, BlockPos currentPos, World world, Set<BlockPos> checkedBlocks) {
        LinkedList<BlockPos> queuedBlocks = new LinkedList<BlockPos>();
        for (int i = -1; i <= 1; ++i) {
            BlockPos tmpPos = new BlockPos(currentPos.func_177958_n() + 1, currentPos.func_177956_o() + i, currentPos.func_177952_p());
            if (this.CheckBlock(world, tmpPos, checkedBlocks, logBlock)) {
                queuedBlocks.add(tmpPos);
            }
            if (this.CheckBlock(world, tmpPos = new BlockPos(currentPos.func_177958_n(), currentPos.func_177956_o() + i, currentPos.func_177952_p() + 1), checkedBlocks, logBlock)) {
                queuedBlocks.add(tmpPos);
            }
            if (this.CheckBlock(world, tmpPos = new BlockPos(currentPos.func_177958_n() - 1, currentPos.func_177956_o() + i, currentPos.func_177952_p()), checkedBlocks, logBlock)) {
                queuedBlocks.add(tmpPos);
            }
            if (this.CheckBlock(world, tmpPos = new BlockPos(currentPos.func_177958_n(), currentPos.func_177956_o() + i, currentPos.func_177952_p() - 1), checkedBlocks, logBlock)) {
                queuedBlocks.add(tmpPos);
            }
            if (this.CheckBlock(world, tmpPos = new BlockPos(currentPos.func_177958_n() + 1, currentPos.func_177956_o() + i, currentPos.func_177952_p() + 1), checkedBlocks, logBlock)) {
                queuedBlocks.add(tmpPos);
            }
            if (this.CheckBlock(world, tmpPos = new BlockPos(currentPos.func_177958_n() - 1, currentPos.func_177956_o() + i, currentPos.func_177952_p() - 1), checkedBlocks, logBlock)) {
                queuedBlocks.add(tmpPos);
            }
            if (this.CheckBlock(world, tmpPos = new BlockPos(currentPos.func_177958_n() - 1, currentPos.func_177956_o() + i, currentPos.func_177952_p() + 1), checkedBlocks, logBlock)) {
                queuedBlocks.add(tmpPos);
            }
            if (this.CheckBlock(world, tmpPos = new BlockPos(currentPos.func_177958_n() + 1, currentPos.func_177956_o() + i, currentPos.func_177952_p() - 1), checkedBlocks, logBlock)) {
                queuedBlocks.add(tmpPos);
            }
            if (!this.CheckBlock(world, tmpPos = new BlockPos(currentPos.func_177958_n(), currentPos.func_177956_o() + i, currentPos.func_177952_p()), checkedBlocks, logBlock)) continue;
            queuedBlocks.add(tmpPos);
        }
        return queuedBlocks;
    }

    private boolean CheckBlock(World world, BlockPos blockPos, Set<BlockPos> checkedBlocks, Block originBlock) {
        if (checkedBlocks.contains(blockPos)) {
            return false;
        }
        if (world.func_180495_p(blockPos).func_177230_c() != originBlock) {
            if (TreeChoppin.plantSapling && world.func_180495_p(blockPos).func_185904_a() == Material.field_151584_j && this.tree.GetM_Leaves().isEmpty()) {
                this.tree.InsertLeaf(blockPos);
            }
            if (TreeChoppin.decayLeaves && TreeChoppin.registeredLeaves.contains(world.func_180495_p(blockPos).func_177230_c())) {
                this.tree.InsertLeaf(blockPos);
                return false;
            }
            if (TreeChoppin.decayLeaves && world.func_180495_p(blockPos).func_185904_a() == Material.field_151584_j) {
                this.tree.InsertLeaf(blockPos);
                return false;
            }
            return false;
        }
        this.tree.InsertWood(blockPos);
        return true;
    }

    public void DestroyTree(IWorld world, PlayerEntity entityPlayer) {
        int soundReduced = 0;
        if (m_Trees.containsKey(entityPlayer.func_110124_au())) {
            Tree tmpTree = m_Trees.get(entityPlayer.func_110124_au());
            for (BlockPos blockPos : tmpTree.GetM_Wood()) {
                if (soundReduced <= 1) {
                    world.func_175655_b(blockPos, true);
                } else {
                    Block.func_220054_a((BlockState)world.func_180495_p(blockPos), (World)world.func_201672_e(), (BlockPos)blockPos, (TileEntity)world.func_175625_s(blockPos), (Entity)entityPlayer, (ItemStack)entityPlayer.func_184614_ca());
                }
                world.func_217377_a(blockPos, true);
                ++soundReduced;
            }
            if (TreeChoppin.plantSapling && !tmpTree.GetM_Leaves().isEmpty()) {
                BlockPos tmpPosition = TreeHandler.getLastElement(tmpTree.GetM_Leaves());
                this.PlantSapling(world.func_201672_e(), tmpPosition, tmpTree.getM_Position());
            }
            soundReduced = 0;
            if (TreeChoppin.decayLeaves) {
                for (BlockPos blockPos : tmpTree.GetM_Leaves()) {
                    if (soundReduced <= 1) {
                        world.func_175655_b(blockPos, true);
                    } else {
                        Block.func_220054_a((BlockState)world.func_180495_p(blockPos), (World)world.func_201672_e(), (BlockPos)blockPos, (TileEntity)world.func_175625_s(blockPos), (Entity)entityPlayer, (ItemStack)entityPlayer.func_184614_ca());
                    }
                    world.func_217377_a(blockPos, true);
                    ++soundReduced;
                }
            }
        }
    }

    private void PlantSapling(World world, BlockPos blockPos, BlockPos originPos) {
        HashSet leafDrop = new HashSet();
        BlockPos plantPos1 = new BlockPos(originPos.func_177958_n() - 1, originPos.func_177956_o(), originPos.func_177952_p() - 1);
        for (int counter = 0; leafDrop.isEmpty() && counter <= 100; ++counter) {
            NonNullList tmpList = NonNullList.func_191196_a();
            tmpList.addAll((Collection)Block.func_220070_a((BlockState)world.func_180495_p(blockPos), (ServerWorld)((ServerWorld)world.func_201672_e()), (BlockPos)blockPos, null));
            leafDrop.addAll(tmpList);
        }
        if (leafDrop.isEmpty()) {
            return;
        }
        FakePlayer fakePlayer = FakePlayerFactory.getMinecraft((ServerWorld)((ServerWorld)world));
        fakePlayer.func_184611_a(Hand.MAIN_HAND, (ItemStack)leafDrop.iterator().next());
        for (ItemStack itemStack : leafDrop) {
            if (!ItemTags.field_206963_E.func_199685_a_((Object)itemStack.func_77973_b())) continue;
            itemStack.func_196084_a(new ItemUseContext((PlayerEntity)fakePlayer, Hand.MAIN_HAND, new BlockRayTraceResult(new Vec3d(0.0, 0.0, 0.0), Direction.NORTH, plantPos1, false)));
        }
    }
}

