/*
 * Decompiled with CFR 0.152.
 */
package com.mr208.treechoppin.core;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import com.mr208.treechoppin.common.network.ClientSettingsMessage;
import com.mr208.treechoppin.common.network.ServerSettingsMessage;
import com.mr208.treechoppin.core.TCConfig;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.minecraftforge.registries.ForgeRegistries;

@Mod(value="treechoppin")
public class TreeChoppin {
    public static final String MOD_ID = "treechoppin";
    private static final String PROTOCOL_VERSION = Integer.toString(1);
    public static SimpleChannel channel = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("treechoppin", "main_channel")).clientAcceptedVersions(PROTOCOL_VERSION::equals).serverAcceptedVersions(PROTOCOL_VERSION::equals).networkProtocolVersion(() -> PROTOCOL_VERSION).simpleChannel();
    public static Set<Item> blacklistAxes = new HashSet<Item>();
    public static Set<Block> registeredLogs = new HashSet<Block>();
    public static Set<Block> registeredLeaves = new HashSet<Block>();
    public static boolean plantSapling;
    public static boolean decayLeaves;
    public static boolean disableShift;
    public static boolean reverseShift;
    public static boolean useTagLog;
    public static boolean useTagLeaves;

    public TreeChoppin() {
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)FMLPaths.CONFIGDIR.get().resolve("treechoppin.toml")).sync().autosave().writingMode(WritingMode.REPLACE).build();
        configData.load();
        TCConfig.SPEC.setConfig((CommentedConfig)configData);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::loadComplete);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
    }

    public void setup(FMLCommonSetupEvent event) {
        int pktID = 0;
        channel.registerMessage(pktID++, ServerSettingsMessage.class, ServerSettingsMessage::encode, ServerSettingsMessage::decode, ServerSettingsMessage.Handler::handle);
        channel.registerMessage(pktID++, ClientSettingsMessage.class, ClientSettingsMessage::encode, ClientSettingsMessage::decode, ClientSettingsMessage.Handler::handle);
    }

    public void loadComplete(FMLLoadCompleteEvent event) {
        Item temp;
        reverseShift = (Boolean)TCConfig.options.reverseShift.get();
        disableShift = (Boolean)TCConfig.options.disableShift.get();
        plantSapling = (Boolean)TCConfig.options.plantSapling.get();
        decayLeaves = (Boolean)TCConfig.options.decayLeaves.get();
        useTagLeaves = (Boolean)TCConfig.logs.logTag.get();
        useTagLeaves = (Boolean)TCConfig.leaves.leavesTag.get();
        for (String axe : (List)TCConfig.axes.blacklistAxe.get()) {
            temp = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(axe));
            if (temp == Items.field_190931_a) continue;
            blacklistAxes.add(temp);
        }
        if (useTagLog) {
            registeredLogs.addAll(BlockTags.field_200031_h.func_199885_a());
        }
        for (String log : (List)TCConfig.logs.logBlocks.get()) {
            temp = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(log));
            if (temp == Blocks.field_150350_a || registeredLogs.contains(temp)) continue;
            registeredLogs.add((Block)temp);
        }
        if (useTagLeaves) {
            registeredLeaves.addAll(BlockTags.field_206952_E.func_199885_a());
        }
        for (String log : (List)TCConfig.leaves.leaves.get()) {
            temp = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(log));
            if (temp == Blocks.field_150350_a || registeredLeaves.contains(temp)) continue;
            registeredLeaves.add((Block)temp);
        }
    }
}

