/*
 * Decompiled with CFR 0.152.
 */
package com.mr208.treechoppin.proxy;

import com.mr208.treechoppin.common.handler.TreeHandler;
import com.mr208.treechoppin.core.TCConfig;
import com.mr208.treechoppin.core.TreeChoppin;
import com.mr208.treechoppin.proxy.PlayerInteract;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class CommonProxy {
    public static Map<UUID, Boolean> m_PlayerPrintNames = new HashMap<UUID, Boolean>();
    protected static Map<UUID, PlayerInteract> m_PlayerData = new HashMap<UUID, PlayerInteract>();
    protected static TreeHandler treeHandler;

    @SubscribeEvent
    public static void InteractWithTree(PlayerInteractEvent interactEvent) {
        boolean shifting = true;
        if (!((Boolean)TCConfig.options.disableShift.get()).booleanValue()) {
            if (interactEvent.getEntityPlayer().func_70093_af() && !TreeChoppin.reverseShift) {
                shifting = false;
            }
            if (!interactEvent.getEntityPlayer().func_70093_af() && TreeChoppin.reverseShift) {
                shifting = false;
            }
        }
        if (CommonProxy.CheckWoodenBlock(interactEvent.getWorld(), interactEvent.getPos()) && CommonProxy.CheckItemInHand(interactEvent.getEntityPlayer()) && shifting) {
            int axeDurability = interactEvent.getEntityPlayer().func_184614_ca().func_77958_k() - interactEvent.getEntityPlayer().func_184614_ca().func_77952_i();
            if (m_PlayerData.containsKey(interactEvent.getEntityPlayer().func_110124_au()) && CommonProxy.m_PlayerData.get((Object)interactEvent.getEntityPlayer().func_110124_au()).m_BlockPos.equals((Object)interactEvent.getPos()) && CommonProxy.m_PlayerData.get((Object)interactEvent.getEntityPlayer().func_110124_au()).m_AxeDurability == axeDurability) {
                return;
            }
            treeHandler = new TreeHandler();
            int logCount = treeHandler.AnalyzeTree(interactEvent.getWorld(), interactEvent.getPos(), interactEvent.getEntityPlayer());
            if (interactEvent.getEntityPlayer().func_184614_ca().func_77984_f() && axeDurability < logCount) {
                m_PlayerData.remove(interactEvent.getEntityPlayer().func_110124_au());
                return;
            }
            if (logCount > 1) {
                m_PlayerData.put(interactEvent.getEntityPlayer().func_110124_au(), new PlayerInteract(interactEvent.getPos(), logCount, axeDurability));
            }
        } else {
            m_PlayerData.remove(interactEvent.getEntityPlayer().func_110124_au());
        }
    }

    @SubscribeEvent
    public static void BreakingBlock(PlayerEvent.BreakSpeed breakSpeed) {
        if (m_PlayerData.containsKey(breakSpeed.getEntityPlayer().func_110124_au())) {
            BlockPos blockPos = CommonProxy.m_PlayerData.get((Object)breakSpeed.getEntityPlayer().func_110124_au()).m_BlockPos;
            if (blockPos.equals((Object)breakSpeed.getPos())) {
                breakSpeed.setNewSpeed(breakSpeed.getOriginalSpeed() / (CommonProxy.m_PlayerData.get((Object)breakSpeed.getEntityPlayer().func_110124_au()).m_LogCount / 2.0f));
            } else {
                breakSpeed.setNewSpeed(breakSpeed.getOriginalSpeed());
            }
        }
    }

    @SubscribeEvent
    public static void DestroyWoodBlock(BlockEvent.BreakEvent breakEvent) {
        BlockPos blockPos;
        if (m_PlayerData.containsKey(breakEvent.getPlayer().func_110124_au()) && (blockPos = CommonProxy.m_PlayerData.get((Object)breakEvent.getPlayer().func_110124_au()).m_BlockPos).equals((Object)breakEvent.getPos())) {
            treeHandler.DestroyTree(breakEvent.getWorld(), breakEvent.getPlayer());
            if (!breakEvent.getPlayer().func_184812_l_()) {
                int extraDamage = (int)CommonProxy.m_PlayerData.get((Object)breakEvent.getPlayer().func_110124_au()).m_LogCount;
                breakEvent.getPlayer().func_184614_ca().func_96631_a(extraDamage, breakEvent.getWorld().func_201674_k(), (ServerPlayerEntity)breakEvent.getPlayer());
            }
        }
    }

    protected static boolean CheckWoodenBlock(World world, BlockPos blockPos) {
        if (TreeChoppin.registeredLogs.contains(world.func_180495_p(blockPos).func_177230_c())) {
            return true;
        }
        return world.func_180495_p(blockPos).func_185904_a() == Material.field_151575_d;
    }

    protected static boolean CheckItemInHand(PlayerEntity entityPlayer) {
        if (entityPlayer.func_184614_ca().func_190926_b()) {
            return false;
        }
        if (TreeChoppin.blacklistAxes.contains(entityPlayer.func_184614_ca().func_77973_b())) {
            return false;
        }
        return entityPlayer.func_184614_ca().getToolTypes().contains(ToolType.AXE);
    }
}

