/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.cosmeticbeds.client;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.LayeredColorMaskTexture;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.item.DyeColor;
import net.minecraft.tileentity.BannerPattern;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;

public class BedTextures {
    public static final Cache BED_DESIGNS = new Cache("cosmetic_bed_", new ResourceLocation("cosmeticbeds", "textures/entity/bed_base.png"), new ResourceLocation("cosmeticbeds", "textures/entity/").toString());
    public static final ResourceLocation BED_BASE_TEXTURE = new ResourceLocation("textures/entity/base.png");

    static class CacheEntry {
        public long lastUseMillis;
        public ResourceLocation textureLocation;

        private CacheEntry() {
        }
    }

    public static class Cache {
        private final Map<String, CacheEntry> cacheMap = Maps.newLinkedHashMap();
        private final ResourceLocation cacheResourceLocation;
        private final String cacheResourceBase;
        private final String cacheId;

        public Cache(String id, ResourceLocation baseResource, String resourcePath) {
            this.cacheId = id;
            this.cacheResourceLocation = baseResource;
            this.cacheResourceBase = resourcePath;
        }

        @Nullable
        public ResourceLocation getResourceLocation(String id, List<BannerPattern> patternList, List<DyeColor> colorList) {
            if (id.isEmpty()) {
                return null;
            }
            if (!patternList.isEmpty() && !colorList.isEmpty()) {
                id = this.cacheId + id;
                CacheEntry bedtextures$cacheentry = this.cacheMap.get(id);
                if (bedtextures$cacheentry == null) {
                    if (this.cacheMap.size() >= 256 && !this.freeCacheSlot()) {
                        return BED_BASE_TEXTURE;
                    }
                    ArrayList list = Lists.newArrayList();
                    for (BannerPattern bannerpattern : patternList) {
                        list.add(this.cacheResourceBase + bannerpattern.func_190997_a() + ".png");
                    }
                    bedtextures$cacheentry = new CacheEntry();
                    bedtextures$cacheentry.textureLocation = new ResourceLocation(id);
                    Minecraft.func_71410_x().func_110434_K().func_110579_a(bedtextures$cacheentry.textureLocation, (ITextureObject)new LayeredColorMaskTexture(this.cacheResourceLocation, (List)list, colorList));
                    this.cacheMap.put(id, bedtextures$cacheentry);
                }
                bedtextures$cacheentry.lastUseMillis = System.currentTimeMillis();
                return bedtextures$cacheentry.textureLocation;
            }
            return MissingTextureSprite.func_195675_b();
        }

        private boolean freeCacheSlot() {
            long i = Util.func_211177_b();
            Iterator<String> iterator = this.cacheMap.keySet().iterator();
            while (iterator.hasNext()) {
                String s = iterator.next();
                CacheEntry bedtextures$cacheentry = this.cacheMap.get(s);
                if (i - bedtextures$cacheentry.lastUseMillis <= 5000L) continue;
                Minecraft.func_71410_x().func_110434_K().func_147645_c(bedtextures$cacheentry.textureLocation);
                iterator.remove();
                return true;
            }
            return this.cacheMap.size() < 256;
        }
    }
}

