/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.cosmeticbeds.client.renderer;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.Arrays;
import java.util.Comparator;
import javax.annotation.Nullable;
import net.minecraft.block.BedBlock;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.model.BedModel;
import net.minecraft.item.DyeColor;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BedPart;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import top.theillusivec4.cosmeticbeds.client.BedTextures;
import top.theillusivec4.cosmeticbeds.common.CosmeticBedTileEntity;

public class CosmeticBedTileEntityRenderer
extends TileEntityRenderer<CosmeticBedTileEntity> {
    private static final ResourceLocation[] TEXTURES = (ResourceLocation[])Arrays.stream(DyeColor.values()).sorted(Comparator.comparingInt(DyeColor::func_196059_a)).map(dyecolor -> new ResourceLocation("textures/entity/bed/" + dyecolor.func_176762_d() + ".png")).toArray(ResourceLocation[]::new);
    private final BedModel model = new BedModel();

    public void render(CosmeticBedTileEntity tileEntityIn, double x, double y, double z, float partialTicks, int destroyStage) {
        if (destroyStage >= 0) {
            this.func_147499_a(field_178460_a[destroyStage]);
            GlStateManager.matrixMode((int)5890);
            GlStateManager.pushMatrix();
            GlStateManager.scalef((float)4.0f, (float)4.0f, (float)1.0f);
            GlStateManager.translatef((float)0.0625f, (float)0.0625f, (float)0.0625f);
            GlStateManager.matrixMode((int)5888);
        } else {
            ResourceLocation resourcelocation = this.getPatternResourceLocation(tileEntityIn);
            if (resourcelocation != null) {
                this.func_147499_a(resourcelocation);
            } else {
                resourcelocation = TEXTURES[tileEntityIn.getBedColor().func_196059_a()];
                if (resourcelocation != null) {
                    this.func_147499_a(resourcelocation);
                }
            }
        }
        if (tileEntityIn.func_145830_o()) {
            BlockState iblockstate = tileEntityIn.func_195044_w();
            this.renderPiece(iblockstate.func_177229_b((IProperty)BedBlock.field_176472_a) == BedPart.HEAD, x, y, z, (Direction)iblockstate.func_177229_b((IProperty)BedBlock.field_185512_D));
        } else {
            this.renderPiece(true, x, y, z, Direction.SOUTH);
            this.renderPiece(false, x, y, z - 1.0, Direction.SOUTH);
        }
        if (destroyStage >= 0) {
            GlStateManager.matrixMode((int)5890);
            GlStateManager.popMatrix();
            GlStateManager.matrixMode((int)5888);
        }
    }

    private void renderPiece(boolean isHead, double x, double y, double z, Direction direction) {
        this.model.func_193769_a(isHead);
        GlStateManager.pushMatrix();
        GlStateManager.translatef((float)((float)x), (float)((float)y + 0.5625f), (float)((float)z));
        GlStateManager.rotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.translatef((float)0.5f, (float)0.5f, (float)0.5f);
        GlStateManager.rotatef((float)(180.0f + direction.func_185119_l()), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.translatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        GlStateManager.enableRescaleNormal();
        this.model.func_193771_b();
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.popMatrix();
    }

    @Nullable
    private ResourceLocation getPatternResourceLocation(CosmeticBedTileEntity bed) {
        return BedTextures.BED_DESIGNS.getResourceLocation(bed.getPatternResourceLocation(), bed.getPatternList(), bed.getColorList());
    }
}

