/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.cosmeticbeds.common;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBannerBlock;
import net.minecraft.block.BedBlock;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.BannerItem;
import net.minecraft.item.BedItem;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import top.theillusivec4.cosmeticbeds.client.renderer.BedPatternItemStackRenderer;
import top.theillusivec4.cosmeticbeds.common.CosmeticBedsRegistry;

public class CosmeticBedItem
extends BedItem {
    public CosmeticBedItem() {
        super(CosmeticBedsRegistry.COSMETIC_BED_BLOCK, new Item.Properties().func_200917_a(1).setTEISR(() -> BedPatternItemStackRenderer::new));
        this.setRegistryName(CosmeticBedsRegistry.COSMETIC_BED_BLOCK.getRegistryName());
    }

    public static ItemStack getBedStack(ItemStack stack) {
        CompoundNBT compound;
        if (stack.func_77973_b() instanceof CosmeticBedItem && (compound = stack.func_179543_a("BlockEntityTag")) != null) {
            return ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l("BedStack"));
        }
        return ItemStack.field_190927_a;
    }

    public static DyeColor getBedColor(ItemStack stack) {
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof BedItem) {
            return (DyeColor)ObfuscationReflectionHelper.getPrivateValue(BedBlock.class, (Object)((BedBlock)((BedItem)stack.func_77973_b()).func_179223_d()), (String)"field_196352_y");
        }
        return DyeColor.WHITE;
    }

    public static ItemStack getBannerStack(ItemStack stack) {
        CompoundNBT compound;
        if (stack.func_77973_b() instanceof CosmeticBedItem && (compound = stack.func_179543_a("BlockEntityTag")) != null) {
            return ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l("BannerStack"));
        }
        return ItemStack.field_190927_a;
    }

    public static DyeColor getBannerColor(ItemStack stack) {
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof BannerItem) {
            return ((AbstractBannerBlock)((BannerItem)stack.func_77973_b()).func_179223_d()).func_196285_M_();
        }
        return DyeColor.WHITE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World worldIn, @Nonnull List<ITextComponent> tooltip, @Nonnull ITooltipFlag flagIn) {
        ItemStack bed = CosmeticBedItem.getBedStack(stack);
        ItemStack banner = CosmeticBedItem.getBannerStack(stack);
        if (!bed.func_190926_b()) {
            tooltip.add(new TranslationTextComponent(bed.func_77977_a(), new Object[0]).func_211708_a(TextFormatting.GRAY));
        }
        if (!banner.func_190926_b()) {
            tooltip.add(new TranslationTextComponent(banner.func_77977_a(), new Object[0]).func_211708_a(TextFormatting.GRAY));
            BannerItem.func_185054_a((ItemStack)banner, tooltip);
        }
    }
}

