/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.cosmeticbeds.common;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.BannerPattern;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import top.theillusivec4.cosmeticbeds.common.CosmeticBedItem;
import top.theillusivec4.cosmeticbeds.common.CosmeticBedsRegistry;

public class CosmeticBedTileEntity
extends TileEntity {
    private ItemStack bed = ItemStack.field_190927_a;
    private ItemStack banner = ItemStack.field_190927_a;
    private DyeColor bedColor = DyeColor.WHITE;
    private DyeColor bannerColor = DyeColor.WHITE;
    private ListNBT patterns;
    private boolean patternDataSet;
    private List<BannerPattern> patternList;
    private List<DyeColor> colorList;
    private String patternResourceLocation;

    public CosmeticBedTileEntity() {
        super(CosmeticBedsRegistry.COSMETIC_BED_TE);
    }

    public void loadFromItemStack(ItemStack stack) {
        CompoundNBT bannernbt;
        this.patterns = null;
        CompoundNBT nbttagcompound = stack.func_179543_a("BlockEntityTag");
        if (nbttagcompound != null) {
            this.bed = ItemStack.func_199557_a((CompoundNBT)nbttagcompound.func_74775_l("BedStack"));
            this.banner = ItemStack.func_199557_a((CompoundNBT)nbttagcompound.func_74775_l("BannerStack"));
            if (!this.bed.func_190926_b()) {
                this.bedColor = CosmeticBedItem.getBedColor(this.bed);
            }
            if (!this.banner.func_190926_b()) {
                this.bannerColor = CosmeticBedItem.getBannerColor(this.banner);
            }
        }
        if ((bannernbt = this.banner.func_179543_a("BlockEntityTag")) != null && bannernbt.func_150297_b("Patterns", 9)) {
            this.patterns = bannernbt.func_150295_c("Patterns", 10).func_74737_b();
        }
        this.patternList = null;
        this.colorList = null;
        this.patternResourceLocation = "";
        this.patternDataSet = true;
    }

    @Nonnull
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        if (!this.bed.func_190926_b()) {
            compound.func_218657_a("BedStack", (INBT)this.bed.func_77955_b(new CompoundNBT()));
        }
        if (!this.banner.func_190926_b()) {
            compound.func_218657_a("BannerStack", (INBT)this.banner.func_77955_b(new CompoundNBT()));
        }
        return compound;
    }

    public void func_145839_a(CompoundNBT compound) {
        CompoundNBT bannernbt;
        super.func_145839_a(compound);
        ItemStack itemStack = this.bed = compound.func_74764_b("BedStack") ? ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l("BedStack")) : ItemStack.field_190927_a;
        if (!this.bed.func_190926_b()) {
            this.bedColor = CosmeticBedItem.getBedColor(this.bed);
        }
        ItemStack itemStack2 = this.banner = compound.func_74764_b("BannerStack") ? ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l("BannerStack")) : ItemStack.field_190927_a;
        if (!this.banner.func_190926_b()) {
            this.bannerColor = CosmeticBedItem.getBannerColor(this.banner);
        }
        this.patterns = (bannernbt = this.banner.func_179543_a("BlockEntityTag")) != null ? bannernbt.func_150295_c("Patterns", 10).func_74737_b() : null;
        this.patternList = null;
        this.colorList = null;
        this.patternResourceLocation = null;
        this.patternDataSet = true;
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 11, this.func_189517_E_());
    }

    @Nonnull
    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public List<BannerPattern> getPatternList() {
        this.initializeBannerData();
        return this.patternList;
    }

    public List<DyeColor> getColorList() {
        this.initializeBannerData();
        return this.colorList;
    }

    public String getPatternResourceLocation() {
        this.initializeBannerData();
        return this.patternResourceLocation;
    }

    private void initializeBannerData() {
        if (this.patternList == null || this.colorList == null || this.patternResourceLocation == null) {
            if (!this.patternDataSet) {
                this.patternResourceLocation = "";
            } else {
                this.patternList = Lists.newArrayList();
                this.colorList = Lists.newArrayList();
                DyeColor enumdyecolor = this.getBannerColor();
                if (enumdyecolor == null) {
                    this.patternResourceLocation = "banner_missing";
                } else {
                    this.patternList.add(BannerPattern.BASE);
                    this.colorList.add(enumdyecolor);
                    this.patternResourceLocation = "b" + enumdyecolor.func_196059_a();
                    if (this.patterns != null) {
                        for (int i = 0; i < this.patterns.size(); ++i) {
                            CompoundNBT nbttagcompound = this.patterns.func_150305_b(i);
                            BannerPattern bannerpattern = BannerPattern.func_190994_a((String)nbttagcompound.func_74779_i("Pattern"));
                            if (bannerpattern == null) continue;
                            this.patternList.add(bannerpattern);
                            int j = nbttagcompound.func_74762_e("Color");
                            this.colorList.add(DyeColor.func_196056_a((int)j));
                            this.patternResourceLocation = this.patternResourceLocation + bannerpattern.func_190993_b() + j;
                        }
                    }
                }
            }
        }
    }

    public ItemStack getItem(BlockState state) {
        ItemStack itemstack = new ItemStack((IItemProvider)CosmeticBedsRegistry.COSMETIC_BED_ITEM);
        CompoundNBT compound = itemstack.func_190925_c("BlockEntityTag");
        if (!this.bed.func_190926_b()) {
            compound.func_218657_a("BedStack", (INBT)this.bed.func_77955_b(new CompoundNBT()));
        }
        if (!this.banner.func_190926_b()) {
            compound.func_218657_a("BannerStack", (INBT)this.banner.func_77955_b(new CompoundNBT()));
        }
        return itemstack;
    }

    public DyeColor getBedColor() {
        return this.bedColor;
    }

    public DyeColor getBannerColor() {
        return this.bannerColor;
    }
}

