/*
 * Decompiled with CFR 0.152.
 */
package its_meow.quickhomes;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;

@Mod(value="quickhomes")
@Mod.EventBusSubscriber(modid="quickhomes")
public class QuickHomesMod {
    public static final String MOD_ID = "quickhomes";

    @SubscribeEvent
    public static void onServerStarting(FMLServerStartingEvent event) {
        CommandDispatcher d = event.getCommandDispatcher();
        d.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"home").requires(source -> {
            try {
                return source.func_197035_h() != null;
            }
            catch (CommandSyntaxException e) {
                return false;
            }
        })).executes(command -> {
            ServerPlayerEntity player = ((CommandSource)command.getSource()).func_197035_h();
            CompoundNBT playerD = player.getPersistentData();
            if (playerD.func_150297_b(MOD_ID, 10)) {
                CompoundNBT data = playerD.func_74775_l(MOD_ID);
                double posX = data.func_74769_h("x");
                double posY = data.func_74769_h("y");
                double posZ = data.func_74769_h("z");
                int dim = data.func_74762_e("dim");
                if (dim != player.func_71121_q().func_201675_m().func_186058_p().func_186068_a()) {
                    player.func_212321_a(DimensionType.func_186069_a((int)dim));
                }
                player.func_70634_a(posX, posY, posZ);
                return 1;
            }
            player.func_145747_a((ITextComponent)new StringTextComponent("No home set."));
            return 0;
        }));
        d.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"sethome").requires(source -> {
            try {
                return source.func_197035_h() != null;
            }
            catch (CommandSyntaxException e) {
                return false;
            }
        })).executes(command -> {
            ServerPlayerEntity player = ((CommandSource)command.getSource()).func_197035_h();
            CompoundNBT playerD = player.getPersistentData();
            CompoundNBT data = new CompoundNBT();
            data.func_74780_a("x", player.field_70165_t);
            data.func_74780_a("y", player.field_70163_u);
            data.func_74780_a("z", player.field_70161_v);
            data.func_74768_a("dim", player.func_71121_q().func_201675_m().func_186058_p().func_186068_a());
            playerD.func_218657_a(MOD_ID, (INBT)data);
            player.func_145747_a((ITextComponent)new StringTextComponent("Home set."));
            return 1;
        }));
    }

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        PlayerEntity player = event.getPlayer();
        if (!player.field_70170_p.field_72995_K) {
            player.func_145747_a((ITextComponent)new StringTextComponent("This server is running QuickHomes " + ((ModContainer)ModList.get().getModContainerById(MOD_ID).get()).getModInfo().getVersion() + " by its_meow!"));
            player.func_145747_a((ITextComponent)new StringTextComponent("You can use /sethome and /home with this mod installed."));
        }
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        CompoundNBT oldData = event.getOriginal().getPersistentData();
        if (oldData.func_150297_b(MOD_ID, 10)) {
            event.getPlayer().getPersistentData().func_218657_a(MOD_ID, (INBT)oldData.func_74775_l(MOD_ID));
        }
    }
}

