/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.forgemod;

import com.mamiyaotaru.voxelmap.VoxelMap;
import com.mamiyaotaru.voxelmap.forgemod.IProxy;
import com.mamiyaotaru.voxelmap.forgemod.TickHandler;
import com.mamiyaotaru.voxelmap.persistent.ThreadManager;
import com.mamiyaotaru.voxelmap.util.BiomeRepository;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

public class ClientProxy
implements IProxy {
    VoxelMap voxelMap;

    @Override
    public void postInit(FMLClientSetupEvent event) {
        this.voxelMap = new VoxelMap();
        this.voxelMap.lateInit(false, false);
        MinecraftForge.EVENT_BUS.register((Object)new TickHandler(this.voxelMap));
    }

    @Override
    public void newWorldName(String worldName) {
        this.voxelMap.newSubWorldName(worldName, true);
    }

    @Override
    public void onShutDown() {
        System.out.print("Saving all world maps");
        this.voxelMap.getPersistentMap().saveCachedRegions();
        this.voxelMap.getMapOptions().saveAll();
        BiomeRepository.saveBiomeColors();
        long shutdownTime = System.currentTimeMillis();
        while (ThreadManager.executorService.getQueue().size() + ThreadManager.executorService.getActiveCount() > 0 && System.currentTimeMillis() - shutdownTime < 10000L) {
            System.out.print(".");
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {}
        }
        System.out.println();
    }
}

