/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.util;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.renderer.model.BakedQuad;

public class BlockModel {
    ArrayList<BlockFace> faces = new ArrayList();
    BlockVertex[] longestSide;
    float failedToLoadX;
    float failedToLoadY;

    public BlockModel(List<BakedQuad> quads) {
        BlockFace face2;
        BakedQuad quad2 = null;
        for (BakedQuad quad2 : quads) {
            face2 = new BlockFace(quad2.func_178209_a());
            if (!face2.isClockwise || face2.isVertical) continue;
            this.faces.add(face2);
        }
        Collections.sort(this.faces);
        this.longestSide = new BlockVertex[2];
        float greatestLength = 0.0f;
        face2 = null;
        for (BlockFace face2 : this.faces) {
            float uDiff = face2.longestSide[0].u - face2.longestSide[1].u;
            float vDiff = face2.longestSide[0].v - face2.longestSide[1].v;
            float segmentLength = (float)Math.sqrt(uDiff * uDiff + vDiff * vDiff);
            if (!(segmentLength > greatestLength)) continue;
            greatestLength = segmentLength;
            this.longestSide = face2.longestSide;
        }
    }

    public void setFailedToLoadCoords(float failedToLoadX, float failedToLoadY) {
        this.failedToLoadX = failedToLoadX;
        this.failedToLoadY = failedToLoadY;
    }

    public int numberOfFaces() {
        return this.faces.size();
    }

    public ArrayList<BlockFace> getFaces() {
        return this.faces;
    }

    public BufferedImage getImage(BufferedImage terrainImage) {
        float terrainImageAspectRatio = terrainImage.getWidth() / terrainImage.getHeight();
        float longestSideUV = Math.max(Math.abs(this.longestSide[0].u - this.longestSide[1].u), Math.abs(this.longestSide[0].v - this.longestSide[1].v) / terrainImageAspectRatio);
        float modelImageWidthUV = longestSideUV / Math.max(Math.abs(this.longestSide[0].x - this.longestSide[1].x), Math.abs(this.longestSide[0].z - this.longestSide[1].z));
        int modelImageWidth = Math.round(modelImageWidthUV * (float)terrainImage.getWidth());
        BufferedImage modelImage = new BufferedImage(modelImageWidth, modelImageWidth, 6);
        Graphics2D g2 = modelImage.createGraphics();
        g2.setColor(new Color(0, 0, 0, 0));
        g2.fillRect(0, 0, modelImage.getWidth(), modelImage.getHeight());
        g2.dispose();
        BlockFace face2 = null;
        for (BlockFace face2 : this.faces) {
            float minU = face2.getMinU();
            float maxU = face2.getMaxU();
            float minV = face2.getMinV();
            float maxV = face2.getMaxV();
            float minX = face2.getMinX();
            float maxX = face2.getMaxX();
            float minZ = face2.getMinZ();
            float maxZ = face2.getMaxZ();
            if (this.similarEnough(minU, minV, this.failedToLoadX, this.failedToLoadY)) {
                return null;
            }
            int faceImageX = Math.round(minX * (float)modelImage.getWidth());
            int faceImageY = Math.round(minZ * (float)modelImage.getHeight());
            int faceImageWidth = Math.round(maxX * (float)modelImage.getWidth()) - faceImageX;
            int faceImageHeight = Math.round(maxZ * (float)modelImage.getHeight()) - faceImageY;
            if (faceImageWidth == 0) {
                if (faceImageX > modelImageWidth - 1) {
                    faceImageX = modelImageWidth - 1;
                }
                faceImageWidth = 1;
            }
            if (faceImageHeight == 0) {
                if (faceImageY > modelImageWidth - 1) {
                    faceImageY = modelImageWidth - 1;
                }
                faceImageHeight = 1;
            }
            int faceImageU = Math.round(minU * (float)terrainImage.getWidth());
            int faceImageV = Math.round(minV * (float)terrainImage.getHeight());
            int faceImageUVWidth = Math.round(maxU * (float)terrainImage.getWidth()) - faceImageU;
            int faceImageUVHeight = Math.round(maxV * (float)terrainImage.getHeight()) - faceImageV;
            if (faceImageUVWidth == 0) {
                faceImageUVWidth = 1;
            }
            if (faceImageUVHeight == 0) {
                faceImageUVHeight = 1;
            }
            BufferedImage faceImage = terrainImage.getSubimage(faceImageU, faceImageV, faceImageUVWidth, faceImageUVHeight);
            if (faceImageWidth != faceImageUVWidth || faceImageHeight != faceImageUVHeight) {
                BufferedImage tmp;
                if (faceImageWidth == faceImageUVHeight && faceImageHeight == faceImageUVWidth) {
                    tmp = new BufferedImage(faceImageWidth, faceImageHeight, 6);
                    AffineTransform transform = new AffineTransform();
                    transform.translate(faceImage.getHeight() / 2, faceImage.getWidth() / 2);
                    transform.rotate(1.5707963267948966);
                    transform.translate(-faceImage.getWidth() / 2, -faceImage.getHeight() / 2);
                    AffineTransformOp op = new AffineTransformOp(transform, 1);
                    faceImage = op.filter(faceImage, tmp);
                } else {
                    tmp = new BufferedImage(faceImageWidth, faceImageHeight, 6);
                    g2 = tmp.createGraphics();
                    g2.drawImage(faceImage, 0, 0, faceImageWidth, faceImageHeight, null);
                    g2.dispose();
                    faceImage = tmp;
                }
            }
            g2 = modelImage.createGraphics();
            g2.drawImage((Image)faceImage, faceImageX, faceImageY, null);
            g2.dispose();
        }
        return modelImage;
    }

    private boolean similarEnough(float a, float b, float one, float two) {
        boolean similar = (double)Math.abs(a - one) < 1.0E-4;
        similar = similar && (double)Math.abs(b - two) < 1.0E-4;
        return similar;
    }

    private class BlockVertex {
        float x;
        float y;
        float z;
        float u;
        float v;

        BlockVertex(float x, float y, float z, float u, float v) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.u = u;
            this.v = v;
        }
    }

    public class BlockFace
    implements Comparable<BlockFace> {
        BlockVertex[] vertices;
        boolean isHorizontal;
        boolean isVertical;
        boolean isClockwise;
        float yLevel;
        BlockVertex[] longestSide;

        BlockFace(int[] values) {
            int arraySize = values.length;
            int intsPerVertex = arraySize / 4;
            this.vertices = new BlockVertex[4];
            for (int t = 0; t < 4; ++t) {
                float x = Float.intBitsToFloat(values[t * intsPerVertex + 0]);
                float y = Float.intBitsToFloat(values[t * intsPerVertex + 1]);
                float z = Float.intBitsToFloat(values[t * intsPerVertex + 2]);
                float u = Float.intBitsToFloat(values[t * intsPerVertex + 4]);
                float v = Float.intBitsToFloat(values[t * intsPerVertex + 5]);
                this.vertices[t] = new BlockVertex(x, y, z, u, v);
            }
            this.isHorizontal = this.checkIfHorizontal();
            this.isVertical = this.checkIfVertical();
            this.isClockwise = this.checkIfClockwise();
            this.yLevel = this.calculateY();
            this.longestSide = this.getLongestSide();
        }

        private boolean checkIfHorizontal() {
            boolean isHorizontal = true;
            float initialY = this.vertices[0].y;
            for (int t = 1; t < this.vertices.length; ++t) {
                if (this.vertices[t].y == initialY) continue;
                isHorizontal = false;
            }
            return isHorizontal;
        }

        private boolean checkIfVertical() {
            boolean allSameX = true;
            boolean allSameZ = true;
            float initialX = this.vertices[0].x;
            float initialZ = this.vertices[0].z;
            for (int t = 1; t < this.vertices.length; ++t) {
                if (this.vertices[t].x != initialX) {
                    allSameX = false;
                }
                if (this.vertices[t].z == initialZ) continue;
                allSameZ = false;
            }
            return allSameX || allSameZ;
        }

        private boolean checkIfClockwise() {
            float sum = 0.0f;
            for (int t = 0; t < this.vertices.length; ++t) {
                sum += (this.vertices[t == this.vertices.length - 1 ? 0 : t + 1].x - this.vertices[t].x) * (this.vertices[t == this.vertices.length - 1 ? 0 : t + 1].z + this.vertices[t].z);
            }
            return sum > 0.0f;
        }

        private float calculateY() {
            float sum = 0.0f;
            for (int t = 0; t < this.vertices.length; ++t) {
                sum += this.vertices[t].y;
            }
            return sum /= (float)this.vertices.length;
        }

        private BlockVertex[] getLongestSide() {
            float greatestLength = -1.0f;
            BlockVertex[] longestSide = new BlockVertex[]{};
            for (int t = 0; t < this.vertices.length; ++t) {
                float uDiff = this.vertices[t].u - this.vertices[t == this.vertices.length - 1 ? 0 : t + 1].u;
                float vDiff = this.vertices[t].v - this.vertices[t == this.vertices.length - 1 ? 0 : t + 1].v;
                float segmentLength = (float)Math.sqrt(uDiff * uDiff + vDiff * vDiff);
                if (!(segmentLength > greatestLength)) continue;
                greatestLength = segmentLength;
                longestSide = new BlockVertex[]{this.vertices[t], this.vertices[t == this.vertices.length - 1 ? 0 : t + 1]};
            }
            return longestSide;
        }

        public float getMinX() {
            float minX = 1.0f;
            for (int t = 0; t < this.vertices.length; ++t) {
                if (!(this.vertices[t].x < minX)) continue;
                minX = this.vertices[t].x;
            }
            return minX;
        }

        public float getMaxX() {
            float maxX = 0.0f;
            for (int t = 0; t < this.vertices.length; ++t) {
                if (!(this.vertices[t].x > maxX)) continue;
                maxX = this.vertices[t].x;
            }
            return maxX;
        }

        public float getMinZ() {
            float minZ = 1.0f;
            for (int t = 0; t < this.vertices.length; ++t) {
                if (!(this.vertices[t].z < minZ)) continue;
                minZ = this.vertices[t].z;
            }
            return minZ;
        }

        public float getMaxZ() {
            float maxZ = 0.0f;
            for (int t = 0; t < this.vertices.length; ++t) {
                if (!(this.vertices[t].z > maxZ)) continue;
                maxZ = this.vertices[t].z;
            }
            return maxZ;
        }

        public float getMinU() {
            float minU = 1.0f;
            for (int t = 0; t < this.vertices.length; ++t) {
                if (!(this.vertices[t].u < minU)) continue;
                minU = this.vertices[t].u;
            }
            return minU;
        }

        public float getMaxU() {
            float maxU = 0.0f;
            for (int t = 0; t < this.vertices.length; ++t) {
                if (!(this.vertices[t].u > maxU)) continue;
                maxU = this.vertices[t].u;
            }
            return maxU;
        }

        public float getMinV() {
            float minV = 1.0f;
            for (int t = 0; t < this.vertices.length; ++t) {
                if (!(this.vertices[t].v < minV)) continue;
                minV = this.vertices[t].v;
            }
            return minV;
        }

        public float getMaxV() {
            float maxV = 0.0f;
            for (int t = 0; t < this.vertices.length; ++t) {
                if (!(this.vertices[t].v > maxV)) continue;
                maxV = this.vertices[t].v;
            }
            return maxV;
        }

        @Override
        public int compareTo(BlockFace compareTo) {
            if (this.yLevel > compareTo.yLevel) {
                return 1;
            }
            if (this.yLevel < compareTo.yLevel) {
                return -1;
            }
            return 0;
        }
    }
}

