/*
 * Decompiled with CFR 0.152.
 */
package com.markus1002.extraboats.entity.item.boat;

import com.markus1002.extraboats.compatibility.BiomesOPlenty;
import com.markus1002.extraboats.entity.item.boat.ModBoatEntity;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameterSets;
import net.minecraft.world.storage.loot.LootParameters;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public abstract class ContainerBoatEntity
extends ModBoatEntity
implements IInventory,
INamedContainerProvider {
    private NonNullList<ItemStack> boatContainerItems = NonNullList.func_191197_a((int)36, (Object)ItemStack.field_190927_a);
    private boolean dropContentsWhenDead = true;
    @Nullable
    private ResourceLocation lootTable;
    private long lootTableSeed;
    private LazyOptional<?> itemHandler = LazyOptional.of(() -> new InvWrapper((IInventory)this));

    public ContainerBoatEntity(EntityType<? extends BoatEntity> entityType, World worldIn) {
        super(entityType, worldIn);
    }

    @Override
    protected void dropBreakItems() {
        super.dropBreakItems();
        if (!this.field_70170_p.field_72995_K && this.dropContentsWhenDead && this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
            InventoryHelper.func_180176_a((World)this.field_70170_p, (Entity)this, (IInventory)this);
        }
    }

    @Override
    public void killBoat() {
        super.killBoat();
        if (!this.field_70170_p.field_72995_K && this.dropContentsWhenDead && this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
            InventoryHelper.func_180176_a((World)this.field_70170_p, (Entity)this, (IInventory)this);
        }
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.boatContainerItems) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        this.addLoot(null);
        return (ItemStack)this.boatContainerItems.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        this.addLoot(null);
        return ItemStackHelper.func_188382_a(this.boatContainerItems, (int)index, (int)count);
    }

    public ItemStack func_70304_b(int index) {
        this.addLoot(null);
        ItemStack itemstack = (ItemStack)this.boatContainerItems.get(index);
        if (itemstack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        this.boatContainerItems.set(index, (Object)ItemStack.field_190927_a);
        return itemstack;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.addLoot(null);
        this.boatContainerItems.set(index, (Object)stack);
        if (!stack.func_190926_b() && stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
    }

    public boolean func_174820_d(int inventorySlot, ItemStack itemStackIn) {
        if (inventorySlot >= 0 && inventorySlot < this.func_70302_i_()) {
            this.func_70299_a(inventorySlot, itemStackIn);
            return true;
        }
        return false;
    }

    public void func_70296_d() {
    }

    public boolean func_70300_a(PlayerEntity player) {
        if (this.field_70128_L) {
            return false;
        }
        return !(player.func_70068_e((Entity)this) > 64.0);
    }

    @Nullable
    public Entity func_212321_a(DimensionType destination) {
        this.dropContentsWhenDead = false;
        return super.func_212321_a(destination);
    }

    public void remove(boolean keepData) {
        super.remove(keepData);
        if (!keepData) {
            this.itemHandler.invalidate();
        }
    }

    @Override
    protected void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        if (this.lootTable != null) {
            compound.func_74778_a("LootTable", this.lootTable.toString());
            if (this.lootTableSeed != 0L) {
                compound.func_74772_a("LootTableSeed", this.lootTableSeed);
            }
        } else {
            ItemStackHelper.func_191282_a((CompoundNBT)compound, this.boatContainerItems);
        }
    }

    @Override
    protected void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.boatContainerItems = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        if (compound.func_150297_b("LootTable", 8)) {
            this.lootTable = new ResourceLocation(compound.func_74779_i("LootTable"));
            this.lootTableSeed = compound.func_74763_f("LootTableSeed");
        } else {
            ItemStackHelper.func_191283_b((CompoundNBT)compound, this.boatContainerItems);
        }
    }

    public boolean func_184230_a(PlayerEntity player, Hand hand) {
        if (player.func_70093_af()) {
            player.func_213829_a((INamedContainerProvider)this);
            return true;
        }
        return super.func_184230_a(player, hand);
    }

    public void addLoot(@Nullable PlayerEntity player) {
        if (this.lootTable != null && this.field_70170_p.func_73046_m() != null) {
            LootTable loottable = this.field_70170_p.func_73046_m().func_200249_aQ().func_186521_a(this.lootTable);
            this.lootTable = null;
            LootContext.Builder lootcontext$builder = new LootContext.Builder((ServerWorld)this.field_70170_p).func_216015_a(LootParameters.field_216286_f, (Object)new BlockPos((Entity)this)).func_216016_a(this.lootTableSeed);
            lootcontext$builder.func_216015_a(LootParameters.field_216284_d, (Object)this);
            if (player != null) {
                lootcontext$builder.func_186469_a(player.func_184817_da()).func_216015_a(LootParameters.field_216281_a, (Object)player);
            }
            loottable.func_216118_a((IInventory)this, lootcontext$builder.func_216022_a(LootParameterSets.field_216261_b));
        }
    }

    public void func_174888_l() {
        this.addLoot(null);
        this.boatContainerItems.clear();
    }

    public void setLootTable(ResourceLocation lootTableIn, long lootTableSeedIn) {
        this.lootTable = lootTableIn;
        this.lootTableSeed = lootTableSeedIn;
    }

    @Nullable
    public Container createMenu(int p_createMenu_1_, PlayerInventory p_createMenu_2_, PlayerEntity p_createMenu_3_) {
        if (this.lootTable != null && p_createMenu_3_.func_175149_v()) {
            return null;
        }
        this.addLoot(p_createMenu_2_.field_70458_d);
        return this.func_213968_a(p_createMenu_1_, p_createMenu_2_);
    }

    protected abstract Container func_213968_a(int var1, PlayerInventory var2);

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (this.func_70089_S() && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemHandler.cast();
        }
        return super.getCapability(capability, facing);
    }

    public void dropContentsWhenDead(boolean value) {
        this.dropContentsWhenDead = value;
    }

    @Override
    public Item getItemDropBoat() {
        switch (this.getModBoatType()) {
            default: {
                return Items.field_151124_az;
            }
            case SPRUCE: {
                return Items.field_185150_aH;
            }
            case BIRCH: {
                return Items.field_185151_aI;
            }
            case JUNGLE: {
                return Items.field_185152_aJ;
            }
            case ACACIA: {
                return Items.field_185153_aK;
            }
            case DARK_OAK: {
                return Items.field_185154_aL;
            }
            case CHERRY: {
                return BiomesOPlenty.CHERRY_BOAT;
            }
            case DEAD: {
                return BiomesOPlenty.DEAD_BOAT;
            }
            case ETHEREAL: {
                return BiomesOPlenty.ETHEREAL_BOAT;
            }
            case FIR: {
                return BiomesOPlenty.FIR_BOAT;
            }
            case HELLBARK: {
                return BiomesOPlenty.HELLBARK_BOAT;
            }
            case JACARANDA: {
                return BiomesOPlenty.JACARANDA_BOAT;
            }
            case MAGIC: {
                return BiomesOPlenty.MAGIC_BOAT;
            }
            case MAHOGANY: {
                return BiomesOPlenty.MAHOGANY_BOAT;
            }
            case PALM: {
                return BiomesOPlenty.PALM_BOAT;
            }
            case REDWOOD: {
                return BiomesOPlenty.REDWOOD_BOAT;
            }
            case UMBRAN: {
                return BiomesOPlenty.UMBRAN_BOAT;
            }
            case WILLOW: 
        }
        return BiomesOPlenty.WILLOW_BOAT;
    }

    public void func_184232_k(Entity passenger) {
        if (this.func_184196_w(passenger)) {
            float f1 = (float)((this.field_70128_L ? (double)0.01f : this.func_70042_X()) + passenger.func_70033_W());
            Vec3d vec3d = new Vec3d((double)0.2f, 0.0, 0.0).func_178785_b(-this.field_70177_z * ((float)Math.PI / 180) - 1.5707964f);
            passenger.func_70107_b(this.field_70165_t + vec3d.field_72450_a, this.field_70163_u + (double)f1, this.field_70161_v + vec3d.field_72449_c);
            passenger.field_70177_z += this.field_184475_as;
            passenger.func_70034_d(passenger.func_70079_am() + this.field_184475_as);
            this.func_184454_a(passenger);
            if (passenger instanceof AnimalEntity) {
                int j = passenger.func_145782_y() % 2 == 0 ? 90 : 270;
                passenger.func_181013_g(((AnimalEntity)passenger).field_70761_aq + (float)j);
                passenger.func_70034_d(passenger.func_70079_am() + (float)j);
            }
        }
    }

    protected boolean func_184219_q(Entity passenger) {
        return !this.func_184207_aI() && !this.func_208600_a(FluidTags.field_206959_a);
    }
}

