/*
 * Decompiled with CFR 0.152.
 */
package com.markus1002.extraboats.entity.item.boat;

import com.markus1002.extraboats.compatibility.BiomesOPlenty;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public abstract class ModBoatEntity
extends BoatEntity {
    private static final DataParameter<Integer> BOAT_TYPE = EntityDataManager.func_187226_a(ModBoatEntity.class, (IDataSerializer)DataSerializers.field_187192_b);

    public ModBoatEntity(EntityType<? extends BoatEntity> entityType, World worldIn) {
        super(entityType, worldIn);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(BOAT_TYPE, (Object)BoatType.OAK.ordinal());
    }

    public void setModBoatType(BoatType boatType) {
        this.field_70180_af.func_187227_b(BOAT_TYPE, (Object)boatType.ordinal());
    }

    public BoatType getModBoatType() {
        return BoatType.byId((Integer)this.field_70180_af.func_187225_a(BOAT_TYPE));
    }

    protected void func_213281_b(CompoundNBT compound) {
        compound.func_74778_a("Type", this.getModBoatType().getName());
    }

    protected void func_70037_a(CompoundNBT compound) {
        if (compound.func_150297_b("Type", 8)) {
            this.setModBoatType(BoatType.getTypeFromString(compound.func_74779_i("Type")));
        }
    }

    protected void func_184231_a(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
        this.field_184473_aH = this.func_213322_ci().field_72448_b;
        if (!this.func_184218_aH()) {
            if (onGroundIn) {
                if (this.field_70143_R > 3.0f) {
                    if (this.field_184469_aF != BoatEntity.Status.ON_LAND) {
                        this.field_70143_R = 0.0f;
                        return;
                    }
                    this.func_180430_e(this.field_70143_R, 1.0f);
                    if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
                        this.func_70106_y();
                        if (this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
                            this.dropBreakItems();
                        }
                    }
                }
                this.field_70143_R = 0.0f;
            } else if (!this.field_70170_p.func_204610_c(new BlockPos((Entity)this).func_177977_b()).func_206884_a(FluidTags.field_206959_a) && y < 0.0) {
                this.field_70143_R = (float)((double)this.field_70143_R - y);
            }
        }
    }

    protected void dropBreakItems() {
        for (int i = 0; i < 3; ++i) {
            this.func_199703_a((IItemProvider)this.getPlanks());
        }
        for (int j = 0; j < 2; ++j) {
            this.func_199703_a((IItemProvider)Items.field_151055_y);
        }
        this.func_199703_a((IItemProvider)this.getDisplayTile().func_177230_c());
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            boolean flag;
            if (source instanceof IndirectEntityDamageSource && source.func_76346_g() != null && this.func_184196_w(source.func_76346_g())) {
                return false;
            }
            this.func_70269_c(-this.func_70267_i());
            this.func_70265_b(10);
            this.func_70266_a(this.func_70271_g() + amount * 10.0f);
            this.func_70018_K();
            boolean bl = flag = source.func_76346_g() instanceof PlayerEntity && ((PlayerEntity)source.func_76346_g()).field_71075_bZ.field_75098_d;
            if (flag || this.func_70271_g() > 40.0f) {
                if (!flag && this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
                    this.killBoat();
                }
                this.func_70106_y();
            }
            return true;
        }
        return true;
    }

    public void killBoat() {
        this.func_199703_a((IItemProvider)this.getItemDropBoat());
    }

    public BlockState getDisplayTile() {
        return Blocks.field_150350_a.func_176223_P();
    }

    public Item getItemDropBoat() {
        return this.func_184455_j();
    }

    public Item func_184455_j() {
        switch (this.getModBoatType()) {
            default: {
                return Items.field_151124_az;
            }
            case SPRUCE: {
                return Items.field_185150_aH;
            }
            case BIRCH: {
                return Items.field_185151_aI;
            }
            case JUNGLE: {
                return Items.field_185152_aJ;
            }
            case ACACIA: {
                return Items.field_185153_aK;
            }
            case DARK_OAK: {
                return Items.field_185154_aL;
            }
            case CHERRY: {
                return BiomesOPlenty.CHERRY_BOAT;
            }
            case DEAD: {
                return BiomesOPlenty.DEAD_BOAT;
            }
            case ETHEREAL: {
                return BiomesOPlenty.ETHEREAL_BOAT;
            }
            case FIR: {
                return BiomesOPlenty.FIR_BOAT;
            }
            case HELLBARK: {
                return BiomesOPlenty.HELLBARK_BOAT;
            }
            case JACARANDA: {
                return BiomesOPlenty.JACARANDA_BOAT;
            }
            case MAGIC: {
                return BiomesOPlenty.MAGIC_BOAT;
            }
            case MAHOGANY: {
                return BiomesOPlenty.MAHOGANY_BOAT;
            }
            case PALM: {
                return BiomesOPlenty.PALM_BOAT;
            }
            case REDWOOD: {
                return BiomesOPlenty.REDWOOD_BOAT;
            }
            case UMBRAN: {
                return BiomesOPlenty.UMBRAN_BOAT;
            }
            case WILLOW: 
        }
        return BiomesOPlenty.WILLOW_BOAT;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected Block getPlanks() {
        switch (this.getModBoatType()) {
            default: {
                return Blocks.field_196662_n;
            }
            case SPRUCE: {
                return Blocks.field_196664_o;
            }
            case BIRCH: {
                return Blocks.field_196666_p;
            }
            case JUNGLE: {
                return Blocks.field_196668_q;
            }
            case ACACIA: {
                return Blocks.field_196670_r;
            }
            case DARK_OAK: {
                return Blocks.field_196672_s;
            }
            case CHERRY: {
                return BiomesOPlenty.CHERRY_PLANKS;
            }
            case DEAD: {
                return BiomesOPlenty.DEAD_PLANKS;
            }
            case ETHEREAL: {
                return BiomesOPlenty.ETHEREAL_PLANKS;
            }
            case FIR: {
                return BiomesOPlenty.FIR_PLANKS;
            }
            case HELLBARK: {
                return BiomesOPlenty.HELLBARK_PLANKS;
            }
            case JACARANDA: {
                return BiomesOPlenty.JACARANDA_PLANKS;
            }
            case MAGIC: {
                return BiomesOPlenty.MAGIC_PLANKS;
            }
            case MAHOGANY: {
                return BiomesOPlenty.MAHOGANY_PLANKS;
            }
            case PALM: {
                return BiomesOPlenty.PALM_PLANKS;
            }
            case REDWOOD: {
                return BiomesOPlenty.REDWOOD_PLANKS;
            }
            case UMBRAN: {
                return BiomesOPlenty.UMBRAN_PLANKS;
            }
            case WILLOW: 
        }
        return BiomesOPlenty.WILLOW_PLANKS;
    }

    public static enum BoatType {
        OAK("oak"),
        SPRUCE("spruce"),
        BIRCH("birch"),
        JUNGLE("jungle"),
        ACACIA("acacia"),
        DARK_OAK("dark_oak"),
        CHERRY("cherry"),
        DEAD("dead"),
        ETHEREAL("ethereal"),
        FIR("fir"),
        HELLBARK("hellbark"),
        JACARANDA("jacaranda"),
        MAGIC("magic"),
        MAHOGANY("mahogany"),
        PALM("palm"),
        REDWOOD("redwood"),
        UMBRAN("umbran"),
        WILLOW("willow");

        private final String name;

        private BoatType(String nameIn) {
            this.name = nameIn;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        public static BoatType byId(int id) {
            BoatType[] aboatentity$type = BoatType.values();
            if (id < 0 || id >= aboatentity$type.length) {
                id = 0;
            }
            return aboatentity$type[id];
        }

        public static BoatType getTypeFromString(String nameIn) {
            BoatType[] aboatentity$type = BoatType.values();
            for (int i = 0; i < aboatentity$type.length; ++i) {
                if (!aboatentity$type[i].getName().equals(nameIn)) continue;
                return aboatentity$type[i];
            }
            return aboatentity$type[0];
        }
    }
}

