/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.automation.client.render;

import com.mojang.blaze3d.platform.GlStateManager;
import io.netty.util.collection.IntObjectHashMap;
import io.netty.util.collection.IntObjectMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.quark.automation.base.ChainHandler;

@OnlyIn(value=Dist.CLIENT)
public class ChainRenderer {
    private static final IntObjectMap<Entity> RENDER_MAP = new IntObjectHashMap();

    public static void drawChainSegment(double x, double y, double z, BufferBuilder buf, double offsetX, double offsetY, double offsetZ, double xOff, double zOff, float baseR, float baseG, float baseB, double height) {
        buf.func_181668_a(5, DefaultVertexFormats.field_181706_f);
        double centroid = xOff + zOff / 2.0;
        for (int seg = 0; seg <= 24; ++seg) {
            float r = baseR;
            float g = baseG;
            float b = baseB;
            if (seg % 2 == 0) {
                r *= 0.7f;
                g *= 0.7f;
                b *= 0.7f;
            }
            float amount = (float)seg / 24.0f;
            buf.func_181662_b(x + offsetX * (double)amount - centroid, y + offsetY * (double)(amount * amount + amount) * 0.5 + (double)((24.0f - (float)seg) / 18.0f + 0.125f) * height + xOff / 2.0 - zOff / 2.0, z + offsetZ * (double)amount - xOff / 2.0).func_181666_a(r, g, b, 1.0f).func_181675_d();
            buf.func_181662_b(x + offsetX * (double)amount + centroid, y + offsetY * (double)(amount * amount + amount) * 0.5 + (double)((24.0f - (float)seg) / 18.0f + 0.125f) * height + zOff / 2.0 - xOff / 2.0, z + offsetZ * (double)amount + xOff / 2.0).func_181666_a(r, g, b, 1.0f).func_181675_d();
        }
        Tessellator.func_178181_a().func_78381_a();
    }

    public static void renderChain(EntityRenderer render, double x, double y, double z, Entity entity, float partTicks) {
        if (ChainHandler.canBeLinked(entity) && !render.field_188301_f) {
            ChainRenderer.renderChain(entity, x, y, z, partTicks);
        }
    }

    private static double interp(double start, double end, double pct) {
        return start + (end - start) * pct;
    }

    private static double prevX(Entity entity) {
        if (entity instanceof AbstractMinecartEntity) {
            return entity.field_70142_S;
        }
        return entity.field_70169_q;
    }

    private static double prevY(Entity entity) {
        if (entity instanceof AbstractMinecartEntity) {
            return entity.field_70137_T;
        }
        return entity.field_70167_r;
    }

    private static double prevZ(Entity entity) {
        if (entity instanceof AbstractMinecartEntity) {
            return entity.field_70136_U;
        }
        return entity.field_70166_s;
    }

    private static void renderChain(Entity cart, double x, double y, double z, float partialTicks) {
        Entity entity = (Entity)RENDER_MAP.get(cart.func_145782_y());
        if (entity != null) {
            boolean player = entity instanceof PlayerEntity;
            y = player ? (y -= 1.3) : (y += 0.1);
            Tessellator tess = Tessellator.func_178181_a();
            BufferBuilder buf = tess.func_178180_c();
            double yaw = ChainRenderer.interp(entity.field_70126_B, entity.field_70177_z, partialTicks * 0.5f) * Math.PI / 180.0;
            double pitch = ChainRenderer.interp(entity.field_70127_C, entity.field_70125_A, partialTicks * 0.5f) * Math.PI / 180.0;
            double rotX = Math.cos(yaw);
            double rotZ = Math.sin(yaw);
            double rotY = Math.sin(pitch);
            double height = player ? (double)entity.func_70047_e() * 0.7 : 0.0;
            double pitchMod = Math.cos(pitch);
            double xLocus = ChainRenderer.interp(ChainRenderer.prevX(entity), entity.field_70165_t, partialTicks);
            double yLocus = ChainRenderer.interp(ChainRenderer.prevY(entity), entity.field_70163_u, partialTicks) + height;
            double zLocus = ChainRenderer.interp(ChainRenderer.prevZ(entity), entity.field_70161_v, partialTicks);
            if (player) {
                xLocus += -rotX * 0.7 - rotZ * 0.5 * pitchMod;
                yLocus += -rotY * 0.5 - 0.25;
                zLocus += -rotZ * 0.7 + rotX * 0.5 * pitchMod;
                zLocus -= 1.0;
                yLocus += 2.0;
            }
            double targetX = ChainRenderer.interp(ChainRenderer.prevX(cart), cart.field_70165_t, partialTicks);
            double targetY = ChainRenderer.interp(ChainRenderer.prevY(cart), cart.field_70163_u, partialTicks);
            double targetZ = ChainRenderer.interp(ChainRenderer.prevZ(cart), cart.field_70161_v, partialTicks);
            if (player) {
                xLocus -= rotX;
                zLocus -= rotZ;
            }
            double offsetX = (float)(xLocus - targetX);
            double offsetY = (float)(yLocus - targetY);
            double offsetZ = (float)(zLocus - targetZ);
            GlStateManager.disableTexture();
            GlStateManager.disableLighting();
            GlStateManager.disableCull();
            ChainRenderer.drawChainSegment(x, y, z, buf, offsetX, offsetY, offsetZ, 0.025, 0.0, 0.3f, 0.3f, 0.3f, height);
            ChainRenderer.drawChainSegment(x, y, z, buf, offsetX, offsetY, offsetZ, 0.0, 0.025, 0.3f, 0.3f, 0.3f, height);
            GlStateManager.enableLighting();
            GlStateManager.enableTexture();
            GlStateManager.enableCull();
        }
    }

    public static void updateTick() {
        RENDER_MAP.clear();
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        if (world == null) {
            return;
        }
        for (Entity entity : world.func_217416_b()) {
            Entity other;
            if (!ChainHandler.canBeLinked(entity) || (other = ChainHandler.getLinked(entity)) == null) continue;
            RENDER_MAP.put(entity.func_145782_y(), (Object)other);
        }
    }
}

