/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.world.generator.multichunk;

import java.util.Random;
import java.util.function.BooleanSupplier;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import vazkii.quark.base.world.config.ClusterSizeConfig;
import vazkii.quark.base.world.config.DimensionConfig;
import vazkii.quark.base.world.generator.Generator;
import vazkii.quark.base.world.generator.multichunk.ClusterShape;
import vazkii.quark.base.world.generator.multichunk.MultiChunkFeatureGenerator;

public abstract class ClusterBasedGenerator
extends MultiChunkFeatureGenerator {
    public final ClusterShape.Provider shapeProvider;

    public ClusterBasedGenerator(DimensionConfig dimConfig, ClusterSizeConfig sizeConfig, long seedXor) {
        this(dimConfig, Generator.NO_COND, sizeConfig, seedXor);
    }

    public ClusterBasedGenerator(DimensionConfig dimConfig, BooleanSupplier condition, ClusterSizeConfig sizeConfig, long seedXor) {
        super(dimConfig, condition, seedXor);
        this.shapeProvider = new ClusterShape.Provider(sizeConfig, seedXor);
    }

    @Override
    public int getFeatureRadius() {
        return this.shapeProvider.getRadius();
    }

    @Override
    public void generateChunkPart(BlockPos src, ChunkGenerator<? extends GenerationSettings> generator, Random random, BlockPos chunkCorner, IWorld world) {
        ClusterShape shape = this.shapeProvider.around(src);
        IGenerationContext context = this.createContext(src, generator, random, chunkCorner, world);
        this.forEachChunkBlock(chunkCorner, shape.getLowerBound(), shape.getUpperBound(), pos -> {
            if (shape.isInside((BlockPos)pos)) {
                context.consume(world, (BlockPos)pos);
            }
        });
        context.finish(world);
    }

    public abstract IGenerationContext createContext(BlockPos var1, ChunkGenerator<? extends GenerationSettings> var2, Random var3, BlockPos var4, IWorld var5);

    public static interface IGenerationContext {
        public void consume(IWorld var1, BlockPos var2);

        public void finish(IWorld var1);
    }
}

