/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.building.block;

import it.unimi.dsi.fastutil.floats.Float2ObjectArrayMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemGroup;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IEnviromentBlockReader;
import vazkii.quark.base.block.QuarkBlock;
import vazkii.quark.base.module.Module;
import vazkii.quark.building.module.GrateModule;

public class GrateBlock
extends QuarkBlock
implements IWaterLoggable {
    private static final VoxelShape TRUE_SHAPE = GrateBlock.func_208617_a((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SPAWN_BLOCK_SHAPE = GrateBlock.func_208617_a((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)32.0, (double)16.0);
    private static final VoxelShape SELECTION_SHAPE;
    private static final Float2ObjectArrayMap<Float2ObjectArrayMap<VoxelShape>> WALK_BLOCK_CACHE;
    public static BooleanProperty WATERLOGGED;

    public GrateBlock(String regname, Module module, ItemGroup creativeTab, Block.Properties properties) {
        super(regname, module, creativeTab, properties);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    private static VoxelShape createNewBox(double stepHeight, double height) {
        VoxelShape shape = TRUE_SHAPE;
        double steps = (stepHeight + 0.0625) / height;
        int i = 0;
        while ((double)i < steps) {
            double plateHeight = 17.0 + (double)(i * 16) * height;
            double extraComponent = stepHeight - (double)i * height;
            if (extraComponent < 1.0 / height) {
                plateHeight += extraComponent * 16.0;
            }
            shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)GrateBlock.func_208617_a((double)0.0, (double)(plateHeight - 1.0), (double)0.0, (double)16.0, (double)plateHeight, (double)16.0));
            ++i;
        }
        return shape;
    }

    public boolean func_208619_r() {
        return true;
    }

    @Nonnull
    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        if (GrateModule.RENDER_SHAPE.get().booleanValue()) {
            GrateModule.RENDER_SHAPE.remove();
            return SELECTION_SHAPE;
        }
        return context.func_216376_b() ? TRUE_SHAPE : SELECTION_SHAPE;
    }

    @Nonnull
    public VoxelShape func_196247_c(BlockState state, @Nonnull IBlockReader world, @Nonnull BlockPos pos) {
        return SELECTION_SHAPE;
    }

    private static VoxelShape getCachedShape(float stepHeight, float height) {
        Float2ObjectArrayMap heightMap = (Float2ObjectArrayMap)WALK_BLOCK_CACHE.computeIfAbsent(stepHeight, k -> new Float2ObjectArrayMap());
        return (VoxelShape)heightMap.computeIfAbsent(height, k -> GrateBlock.createNewBox(stepHeight, height));
    }

    @Nonnull
    public VoxelShape func_220071_b(@Nonnull BlockState state, @Nonnull IBlockReader world, @Nonnull BlockPos pos, ISelectionContext context) {
        Entity entity = context.getEntity();
        if (entity != null) {
            if (entity instanceof ItemEntity) {
                return VoxelShapes.func_197880_a();
            }
            if (entity instanceof AnimalEntity) {
                return GrateBlock.getCachedShape(entity.field_70138_W, entity.func_213302_cg());
            }
            if (!(entity instanceof PlayerEntity)) {
                return SPAWN_BLOCK_SHAPE;
            }
            return TRUE_SHAPE;
        }
        return TRUE_SHAPE;
    }

    @Nullable
    public PathNodeType getAiPathNodeType(BlockState state, IBlockReader world, BlockPos pos, @Nullable MobEntity entity) {
        if (entity instanceof AnimalEntity) {
            return PathNodeType.DAMAGE_OTHER;
        }
        return null;
    }

    @Nonnull
    public IFluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(context.func_195991_k().func_204610_c(context.func_195995_a()).func_206886_c() == Fluids.field_204546_a));
    }

    public boolean func_196266_a(@Nonnull BlockState state, @Nonnull IBlockReader world, @Nonnull BlockPos pos, PathType path) {
        return false;
    }

    public boolean doesSideBlockRendering(BlockState state, IEnviromentBlockReader world, BlockPos pos, Direction side) {
        if (side.func_176740_k() == Direction.Axis.Y) {
            return super.doesSideBlockRendering(state, world, pos, side);
        }
        BlockState stateAt = world.func_180495_p(pos.func_177972_a(side));
        Block block = stateAt.func_177230_c();
        return block != this && super.doesSideBlockRendering(stateAt, world, pos, side);
    }

    public boolean func_200123_i(BlockState state, @Nonnull IBlockReader world, @Nonnull BlockPos pos) {
        return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) == false;
    }

    public boolean func_220060_c(@Nonnull BlockState state, @Nonnull IBlockReader world, @Nonnull BlockPos pos) {
        return false;
    }

    public boolean func_220081_d(BlockState state, @Nonnull IBlockReader world, @Nonnull BlockPos pos) {
        return false;
    }

    public boolean func_220067_a(BlockState state, @Nonnull IBlockReader world, @Nonnull BlockPos pos, EntityType<?> type) {
        return false;
    }

    public boolean collisionExtendsVertically(BlockState state, IBlockReader world, BlockPos pos, Entity collidingEntity) {
        return true;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{WATERLOGGED});
    }

    static {
        WALK_BLOCK_CACHE = new Float2ObjectArrayMap();
        WATERLOGGED = BlockStateProperties.field_208198_y;
        VoxelShape shape = VoxelShapes.func_197880_a();
        for (int x = 0; x < 4; ++x) {
            shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)GrateBlock.func_208617_a((double)(1 + x * 4), (double)15.0, (double)0.0, (double)(3 + x * 4), (double)16.0, (double)16.0));
        }
        for (int z = 0; z < 4; ++z) {
            shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)GrateBlock.func_208617_a((double)0.0, (double)15.0, (double)(1 + z * 4), (double)16.0, (double)16.0, (double)(3 + z * 4)));
        }
        SELECTION_SHAPE = shape;
    }
}

