/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.building.block;

import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.ChestBlock;
import net.minecraft.client.renderer.tileentity.ItemStackTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.arl.interf.IBlockItemProvider;
import vazkii.arl.util.RegistryHelper;
import vazkii.quark.base.block.IQuarkBlock;
import vazkii.quark.base.module.Module;
import vazkii.quark.building.client.render.VariantChestTileEntityRenderer;
import vazkii.quark.building.tile.VariantChestTileEntity;

@OnlyIn(value=Dist.CLIENT, _interface=IBlockItemProvider.class)
public class VariantChestBlock
extends ChestBlock
implements IBlockItemProvider,
IQuarkBlock {
    public final String type;
    private final Module module;
    private BooleanSupplier enabledSupplier = () -> true;
    public final ResourceLocation modelNormal;
    public final ResourceLocation modelDouble;

    public VariantChestBlock(String type, Module module) {
        super(Block.Properties.func_200950_a((Block)Blocks.field_150486_ae));
        RegistryHelper.registerBlock((Block)this, (String)(type + "_chest"));
        RegistryHelper.setCreativeTab((Block)this, (ItemGroup)ItemGroup.field_78031_c);
        this.type = type;
        this.module = module;
        this.modelNormal = new ResourceLocation("quark", "textures/model/chest/" + type + ".png");
        this.modelDouble = new ResourceLocation("quark", "textures/model/chest/" + type + "_double.png");
    }

    public void func_149666_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.isEnabled() || group == ItemGroup.field_78027_g) {
            super.func_149666_a(group, items);
        }
    }

    @Override
    public VariantChestBlock setCondition(BooleanSupplier enabledSupplier) {
        this.enabledSupplier = enabledSupplier;
        return this;
    }

    @Override
    public boolean doesConditionApply() {
        return this.enabledSupplier.getAsBoolean();
    }

    @Override
    @Nullable
    public Module getModule() {
        return this.module;
    }

    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new VariantChestTileEntity();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void setTEISR(Item.Properties props, final ResourceLocation modelNormal, final ResourceLocation modelDouble) {
        props.setTEISR(() -> () -> new ItemStackTileEntityRenderer(){
            private final TileEntity tile = new VariantChestTileEntity();

            public void func_179022_a(ItemStack itemStackIn) {
                VariantChestTileEntityRenderer.forceNormal = modelNormal;
                VariantChestTileEntityRenderer.forceDouble = modelDouble;
                TileEntityRendererDispatcher.field_147556_a.func_203601_b(this.tile);
            }
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public BlockItem provideItemBlock(Block block, Item.Properties props) {
        VariantChestBlock.setTEISR(props, this.modelNormal, this.modelDouble);
        return new BlockItem(block, props);
    }
}

