/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.building.block;

import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.TrappedChestBlock;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.arl.interf.IBlockItemProvider;
import vazkii.arl.util.RegistryHelper;
import vazkii.quark.base.module.Module;
import vazkii.quark.building.block.VariantChestBlock;
import vazkii.quark.building.tile.VariantTrappedChestTileEntity;

@OnlyIn(value=Dist.CLIENT, _interface=IBlockItemProvider.class)
public class VariantTrappedChestBlock
extends TrappedChestBlock
implements IBlockItemProvider {
    public final String type;
    private final Module module;
    public final ResourceLocation modelNormal;
    public final ResourceLocation modelDouble;

    public VariantTrappedChestBlock(String type, Module module) {
        super(Block.Properties.func_200950_a((Block)Blocks.field_150486_ae));
        RegistryHelper.registerBlock((Block)this, (String)(type + "_trapped_chest"));
        RegistryHelper.setCreativeTab((Block)this, (ItemGroup)ItemGroup.field_78031_c);
        this.type = type;
        this.module = module;
        this.modelNormal = new ResourceLocation("quark", "textures/model/chest/" + type + "_trap.png");
        this.modelDouble = new ResourceLocation("quark", "textures/model/chest/" + type + "_trap_double.png");
    }

    public void func_149666_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.module.enabled || group == ItemGroup.field_78027_g) {
            super.func_149666_a(group, items);
        }
    }

    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new VariantTrappedChestTileEntity();
    }

    @OnlyIn(value=Dist.CLIENT)
    public BlockItem provideItemBlock(Block block, Item.Properties props) {
        VariantChestBlock.setTEISR(props, this.modelNormal, this.modelDouble);
        return new BlockItem(block, props);
    }
}

