/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.building.client.render;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.ItemFrameRenderer;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ModelManager;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.FilledMapItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapData;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderItemInFrameEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import vazkii.quark.building.entity.ColoredItemFrameEntity;

@OnlyIn(value=Dist.CLIENT)
public class ColoredItemFrameRenderer
extends EntityRenderer<ColoredItemFrameEntity> {
    private static final ResourceLocation MAP_BACKGROUND_TEXTURES = new ResourceLocation("textures/map/map_background.png");
    private static final Map<DyeColor, ModelResourceLocation> LOCATIONS_MODEL = new HashMap<DyeColor, ModelResourceLocation>();
    private static final Map<DyeColor, ModelResourceLocation> LOCATIONS_MODEL_MAP = new HashMap<DyeColor, ModelResourceLocation>();
    private final Minecraft mc = Minecraft.func_71410_x();
    private final ItemRenderer itemRenderer;
    private final ItemFrameRenderer defaultRenderer;

    public ColoredItemFrameRenderer(EntityRendererManager renderManagerIn, ItemRenderer itemRendererIn) {
        super(renderManagerIn);
        this.itemRenderer = itemRendererIn;
        this.defaultRenderer = (ItemFrameRenderer)renderManagerIn.func_78715_a(ItemFrameEntity.class);
        for (DyeColor color : DyeColor.values()) {
            LOCATIONS_MODEL.put(color, new ModelResourceLocation(new ResourceLocation("quark", color.func_176610_l() + "_frame_empty"), "inventory"));
            LOCATIONS_MODEL_MAP.put(color, new ModelResourceLocation(new ResourceLocation("quark", color.func_176610_l() + "_frame_map"), "inventory"));
        }
    }

    public void doRender(@Nonnull ColoredItemFrameEntity entity, double x, double y, double z, float entityYaw, float partialTicks) {
        GlStateManager.pushMatrix();
        BlockPos blockpos = entity.func_174857_n();
        double d0 = (double)blockpos.func_177958_n() - entity.field_70165_t + x;
        double d1 = (double)blockpos.func_177956_o() - entity.field_70163_u + y;
        double d2 = (double)blockpos.func_177952_p() - entity.field_70161_v + z;
        GlStateManager.translated((double)(d0 + 0.5), (double)(d1 + 0.5), (double)(d2 + 0.5));
        GlStateManager.rotatef((float)entity.field_70125_A, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.rotatef((float)(180.0f - entity.field_70177_z), (float)0.0f, (float)1.0f, (float)0.0f);
        this.field_76990_c.field_78724_e.func_110577_a(AtlasTexture.field_110575_b);
        BlockRendererDispatcher blockrendererdispatcher = this.mc.func_175602_ab();
        ModelManager modelmanager = blockrendererdispatcher.func_175023_a().func_178126_b();
        DyeColor color = entity.getColor();
        ModelResourceLocation modelresourcelocation = entity.func_82335_i().func_77973_b() instanceof FilledMapItem ? LOCATIONS_MODEL_MAP.get(color) : LOCATIONS_MODEL.get(color);
        GlStateManager.pushMatrix();
        GlStateManager.translatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        if (this.field_188301_f) {
            GlStateManager.enableColorMaterial();
            GlStateManager.setupSolidRenderingTextureCombine((int)this.func_188298_c((Entity)entity));
        }
        blockrendererdispatcher.func_175019_b().func_178262_a(modelmanager.func_174953_a(modelresourcelocation), 1.0f, 1.0f, 1.0f, 1.0f);
        if (this.field_188301_f) {
            GlStateManager.tearDownSolidRenderingTextureCombine();
            GlStateManager.disableColorMaterial();
        }
        GlStateManager.popMatrix();
        GlStateManager.enableLighting();
        if (entity.func_82335_i().func_77973_b() == Items.field_151098_aY) {
            GlStateManager.pushLightingAttributes();
            RenderHelper.func_74519_b();
        }
        GlStateManager.translatef((float)0.0f, (float)0.0f, (float)0.4375f);
        this.renderItem(entity);
        if (entity.func_82335_i().func_77973_b() == Items.field_151098_aY) {
            RenderHelper.func_74518_a();
            GlStateManager.popAttributes();
        }
        GlStateManager.enableLighting();
        GlStateManager.popMatrix();
        this.renderName(entity, x + (double)((float)entity.func_174811_aO().func_82601_c() * 0.3f), y - 0.25, z + (double)((float)entity.func_174811_aO().func_82599_e() * 0.3f));
    }

    @Nullable
    protected ResourceLocation getEntityTexture(@Nonnull ColoredItemFrameEntity entity) {
        return null;
    }

    private void renderItem(ColoredItemFrameEntity itemFrame) {
        ItemStack stack = itemFrame.func_82335_i();
        if (!stack.func_190926_b()) {
            GlStateManager.pushMatrix();
            MapData mapdata = FilledMapItem.func_195950_a((ItemStack)stack, (World)itemFrame.field_70170_p);
            int rotation = mapdata != null ? itemFrame.func_82333_j() % 4 * 2 : itemFrame.func_82333_j();
            GlStateManager.rotatef((float)((float)rotation * 360.0f / 8.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            if (!MinecraftForge.EVENT_BUS.post((Event)new RenderItemInFrameEvent((ItemFrameEntity)itemFrame, this.defaultRenderer))) {
                if (mapdata != null) {
                    GlStateManager.disableLighting();
                    this.field_76990_c.field_78724_e.func_110577_a(MAP_BACKGROUND_TEXTURES);
                    GlStateManager.rotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    GlStateManager.scalef((float)0.0078125f, (float)0.0078125f, (float)0.0078125f);
                    GlStateManager.translatef((float)-64.0f, (float)-64.0f, (float)0.0f);
                    GlStateManager.translatef((float)0.0f, (float)0.0f, (float)-1.0f);
                    this.mc.field_71460_t.func_147701_i().func_148250_a(mapdata, true);
                } else {
                    GlStateManager.scalef((float)0.5f, (float)0.5f, (float)0.5f);
                    this.itemRenderer.func_181564_a(stack, ItemCameraTransforms.TransformType.FIXED);
                }
            }
            GlStateManager.popMatrix();
        }
    }

    protected void renderName(@Nonnull ColoredItemFrameEntity entity, double x, double y, double z) {
        if (Minecraft.func_71382_s() && !entity.func_82335_i().func_190926_b() && entity.func_82335_i().func_82837_s() && this.field_76990_c.field_147941_i == entity) {
            float f;
            double d0 = entity.func_195048_a(this.field_76990_c.field_217783_c.func_216785_c());
            float f2 = f = entity.func_213287_bg() ? 32.0f : 64.0f;
            if (!(d0 >= (double)(f * f))) {
                String s = entity.func_82335_i().func_200301_q().func_150254_d();
                this.func_147906_a((Entity)entity, s, x, y, z, 64);
            }
        }
    }
}

