/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.building.module;

import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.PigEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.GameRules;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.furnace.FurnaceFuelBurnTimeEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import vazkii.quark.base.item.QuarkItem;
import vazkii.quark.base.module.Config;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.Module;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.building.block.CandleBlock;

@LoadModule(category=ModuleCategory.BUILDING, hasSubscriptions=true)
public class TallowAndCandlesModule
extends Module {
    @Config
    public static boolean candlesFall = true;
    @Config
    @Config.Min(value=0.0)
    public static int minDrop = 1;
    @Config
    @Config.Min(value=0.0)
    public static int maxDrop = 3;
    @Config
    @Config.Min(value=0.0)
    public static int tallowBurnTime = 200;
    @Config
    @Config.Min(value=0.0)
    @Config.Max(value=15.0)
    public static double enchantPower = 0.5;
    private Item tallow;

    @Override
    public void construct() {
        this.tallow = new QuarkItem("tallow", this, new Item.Properties().func_200916_a(ItemGroup.field_78035_l));
        for (DyeColor dye : DyeColor.values()) {
            new CandleBlock(dye.func_176610_l() + "_candle", this, dye);
        }
    }

    @SubscribeEvent
    public void onDrops(LivingDropsEvent event) {
        int drops;
        LivingEntity e = event.getEntityLiving();
        if (e instanceof PigEntity && maxDrop > 0 && e.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g) && (drops = minDrop + e.field_70170_p.field_73012_v.nextInt(maxDrop - minDrop + 1)) > 0) {
            event.getDrops().add(new ItemEntity(e.field_70170_p, e.field_70165_t, e.field_70163_u, e.field_70161_v, new ItemStack((IItemProvider)this.tallow, drops)));
        }
    }

    @SubscribeEvent
    public void onFurnaceTimeCheck(FurnaceFuelBurnTimeEvent event) {
        if (event.getItemStack().func_77973_b() == this.tallow && tallowBurnTime > 0) {
            event.setBurnTime(tallowBurnTime);
        }
    }
}

