/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.building.module;

import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.horse.AbstractChestedHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import vazkii.arl.util.RegistryHelper;
import vazkii.quark.base.handler.ItemOverrideHandler;
import vazkii.quark.base.module.Config;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.Module;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.building.block.VariantChestBlock;
import vazkii.quark.building.block.VariantTrappedChestBlock;
import vazkii.quark.building.client.render.VariantChestTileEntityRenderer;
import vazkii.quark.building.tile.VariantChestTileEntity;
import vazkii.quark.building.tile.VariantTrappedChestTileEntity;

@LoadModule(category=ModuleCategory.BUILDING, hasSubscriptions=true)
public class VariantChestsModule
extends Module {
    @Config
    public static boolean changeNames = true;
    public static TileEntityType<VariantChestTileEntity> chestTEType;
    public static TileEntityType<VariantTrappedChestTileEntity> trappedChestTEType;
    private static final String DONK_CHEST = "Quark:DonkChest";
    private static final ThreadLocal<ItemStack> WAIT_TO_REPLACE_CHEST;

    @Override
    public void construct() {
        VariantChestBlock spruceChest = new VariantChestBlock("spruce", this);
        VariantChestBlock birchChest = new VariantChestBlock("birch", this);
        VariantChestBlock jungleChest = new VariantChestBlock("jungle", this);
        VariantChestBlock acaciaChest = new VariantChestBlock("acacia", this);
        VariantChestBlock darkOakChest = new VariantChestBlock("dark_oak", this);
        VariantTrappedChestBlock spruceChestTrapped = new VariantTrappedChestBlock("spruce", this);
        VariantTrappedChestBlock birchChestTrapped = new VariantTrappedChestBlock("birch", this);
        VariantTrappedChestBlock jungleChestTrapped = new VariantTrappedChestBlock("jungle", this);
        VariantTrappedChestBlock acaciaChestTrapped = new VariantTrappedChestBlock("acacia", this);
        VariantTrappedChestBlock darkOakChestTrapped = new VariantTrappedChestBlock("dark_oak", this);
        chestTEType = TileEntityType.Builder.func_223042_a(VariantChestTileEntity::new, (Block[])new Block[]{spruceChest, birchChest, jungleChest, acaciaChest, darkOakChest}).func_206865_a(null);
        trappedChestTEType = TileEntityType.Builder.func_223042_a(VariantTrappedChestTileEntity::new, (Block[])new Block[]{spruceChestTrapped, birchChestTrapped, jungleChestTrapped, acaciaChestTrapped, darkOakChestTrapped}).func_206865_a(null);
        RegistryHelper.register(chestTEType, (String)"variant_chest");
        RegistryHelper.register(trappedChestTEType, (String)"variant_trapped_chest");
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientSetup() {
        ClientRegistry.bindTileEntitySpecialRenderer(VariantChestTileEntity.class, (TileEntityRenderer)new VariantChestTileEntityRenderer());
    }

    @Override
    public void configChanged() {
        ItemOverrideHandler.changeBlockLocalizationKey(Blocks.field_150486_ae, "block.quark.oak_chest", changeNames && this.enabled);
        ItemOverrideHandler.changeBlockLocalizationKey(Blocks.field_150447_bR, "block.quark.oak_trapped_chest", changeNames && this.enabled);
    }

    @SubscribeEvent
    public void onClickEntity(PlayerInteractEvent.EntityInteractSpecific event) {
        AbstractChestedHorseEntity horse;
        Entity target = event.getTarget();
        PlayerEntity player = event.getPlayer();
        ItemStack held = player.func_184586_b(event.getHand());
        if (!held.func_190926_b() && target instanceof AbstractChestedHorseEntity && !(horse = (AbstractChestedHorseEntity)target).func_190695_dh() && held.func_77973_b() != Items.field_221675_bZ && held.func_77973_b().func_206844_a(Tags.Items.CHESTS_WOODEN)) {
            event.setCanceled(true);
            event.setCancellationResult(ActionResultType.SUCCESS);
            if (!target.field_70170_p.field_72995_K) {
                ItemStack copy = held.func_77946_l();
                copy.func_190920_e(1);
                held.func_190918_g(1);
                horse.getPersistentData().func_218657_a(DONK_CHEST, (INBT)copy.serializeNBT());
                horse.func_110207_m(true);
                horse.func_110226_cD();
                horse.func_190697_dk();
            }
        }
    }

    @SubscribeEvent
    public void onDeath(LivingDeathEvent event) {
        AbstractChestedHorseEntity horse;
        ItemStack chest;
        LivingEntity target = event.getEntityLiving();
        if (target instanceof AbstractChestedHorseEntity && !(chest = ItemStack.func_199557_a((CompoundNBT)(horse = (AbstractChestedHorseEntity)target).getPersistentData().func_74775_l(DONK_CHEST))).func_190926_b() && horse.func_190695_dh()) {
            WAIT_TO_REPLACE_CHEST.set(chest);
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        Entity target = event.getEntity();
        if (target instanceof ItemEntity && ((ItemEntity)target).func_92059_d().func_77973_b() == Items.field_221675_bZ) {
            ItemStack local = WAIT_TO_REPLACE_CHEST.get();
            if (local != null && !local.func_190926_b()) {
                ((ItemEntity)target).func_92058_a(local);
            }
            WAIT_TO_REPLACE_CHEST.remove();
        }
    }

    static {
        WAIT_TO_REPLACE_CHEST = new ThreadLocal();
    }
}

