/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.tweaks.module;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LadderBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.MovementInput;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputUpdateEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import vazkii.quark.base.module.Config;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.Module;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.building.module.VariantLaddersModule;

@LoadModule(category=ModuleCategory.TWEAKS, hasSubscriptions=true)
public class EnchancedLaddersModule
extends Module {
    @Config
    @Config.Max(value=0.0)
    public double fallSpeed = -0.2;
    private static Tag<Item> laddersTag;

    @Override
    public void setup() {
        laddersTag = new ItemTags.Wrapper(new ResourceLocation("quark", "ladders"));
    }

    private static boolean canAttachTo(BlockState state, Block ladder, IWorldReader world, BlockPos pos, Direction facing) {
        if (ladder == VariantLaddersModule.iron_ladder) {
            return VariantLaddersModule.iron_ladder.func_196260_a(state, world, pos);
        }
        if (ladder instanceof LadderBlock) {
            BlockPos offset = pos.func_177972_a(facing);
            BlockState blockstate = world.func_180495_p(offset);
            return !blockstate.func_185897_m() && blockstate.func_224755_d((IBlockReader)world, offset, facing);
        }
        return false;
    }

    @SubscribeEvent
    public void onInteract(PlayerInteractEvent.RightClickBlock event) {
        Hand hand;
        PlayerEntity player = event.getPlayer();
        ItemStack stack = player.func_184586_b(hand = event.getHand());
        if (!stack.func_190926_b() && stack.func_77973_b().func_206844_a(laddersTag)) {
            Block block = Block.func_149634_a((Item)stack.func_77973_b());
            World world = event.getWorld();
            BlockPos pos = event.getPos();
            while (world.func_180495_p(pos).func_177230_c() == block) {
                Direction facing;
                BlockState copyState;
                event.setCanceled(true);
                BlockPos posDown = pos.func_177977_b();
                if (World.func_189509_E((BlockPos)posDown)) break;
                BlockState stateDown = world.func_180495_p(posDown);
                if (stateDown.func_177230_c() == block) {
                    pos = posDown;
                    continue;
                }
                if (!stateDown.func_177230_c().isAir(stateDown, (IBlockReader)world, posDown) || !EnchancedLaddersModule.canAttachTo(copyState = world.func_180495_p(pos), block, (IWorldReader)world, posDown, (facing = (Direction)copyState.func_177229_b((IProperty)LadderBlock.field_176382_a)).func_176734_d())) break;
                world.func_175656_a(posDown, copyState);
                world.func_184148_a(null, (double)posDown.func_177958_n(), (double)posDown.func_177956_o(), (double)posDown.func_177952_p(), SoundEvents.field_187650_cV, SoundCategory.BLOCKS, 1.0f, 1.0f);
                if (world.field_72995_K) {
                    player.func_184609_a(hand);
                }
                if (player.func_184812_l_()) break;
                stack.func_190918_g(1);
                if (stack.func_190916_E() > 0) break;
                player.func_184611_a(hand, ItemStack.field_190927_a);
                break;
            }
        }
    }

    @SubscribeEvent
    public void onPlayerTick(LivingEvent.LivingUpdateEvent event) {
        PlayerEntity player;
        if (event.getEntityLiving() instanceof PlayerEntity && (player = (PlayerEntity)event.getEntityLiving()).func_70617_f_()) {
            boolean scaffold;
            boolean bl = scaffold = player.field_70170_p.func_180495_p(player.func_180425_c()).func_177230_c() == Blocks.field_222420_lI;
            if (player.func_70093_af() == scaffold && player.field_191988_bg == 0.0f && player.field_70701_bs <= 0.0f && player.field_70702_br == 0.0f && player.field_70125_A > 70.0f && !player.field_70170_p.func_180495_p(player.func_180425_c().func_177977_b()).func_200132_m()) {
                Vec3d move = new Vec3d(0.0, this.fallSpeed, 0.0);
                player.func_213315_a(MoverType.SELF, move);
            }
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onInput(InputUpdateEvent event) {
        MovementInput input;
        PlayerEntity player = event.getPlayer();
        if (player.func_70617_f_() && Minecraft.func_71410_x().field_71462_r != null && (player.field_191988_bg != 0.0f || !(player.field_70125_A > 70.0f)) && (input = event.getMovementInput()) != null) {
            input.field_78899_d = true;
        }
    }
}

