/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.tweaks.module;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CropsBlock;
import net.minecraft.command.arguments.BlockStateParser;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.HoeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import vazkii.quark.base.module.Config;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.Module;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.network.QuarkNetwork;
import vazkii.quark.base.network.message.HarvestMessage;
import vazkii.quark.tweaks.module.HoeHarvestingModule;

@LoadModule(category=ModuleCategory.TWEAKS, hasSubscriptions=true)
public class SimpleHarvestModule
extends Module {
    @Config(description="Can players harvest crops with empty hand clicks?")
    public static boolean emptyHandHarvest = true;
    @Config(description="Does harvesting crops with a hoe cost durability?")
    public static boolean harvestingCostsDurability = false;
    @Config(description="Should Quark look for (nonvanilla) crops, and handle them?")
    public static boolean doHarvestingSearch = true;
    @Config(description="Which crops can be harvested?\nFormat is: \"harvestState[,afterHarvest]\", i.e. \"minecraft:wheat[age=7]\" or \"minecraft:cocoa[age=2,facing=north],minecraft:cocoa[age=0,facing=north]\"")
    public static List<String> harvestableBlocks = Lists.newArrayList((Object[])new String[]{"minecraft:wheat[age=7]", "minecraft:carrots[age=7]", "minecraft:potatoes[age=7]", "minecraft:beetroots[age=3]", "minecraft:nether_wart[age=3]", "minecraft:cocoa[age=2,facing=north],minecraft:cocoa[age=0,facing=north]", "minecraft:cocoa[age=2,facing=south],minecraft:cocoa[age=0,facing=south]", "minecraft:cocoa[age=2,facing=east],minecraft:cocoa[age=0,facing=east]", "minecraft:cocoa[age=2,facing=west],minecraft:cocoa[age=0,facing=west]"});
    public static final Map<BlockState, BlockState> crops = Maps.newHashMap();

    @Override
    public void configChanged() {
        crops.clear();
        if (doHarvestingSearch) {
            GameRegistry.findRegistry(Block.class).getValues().stream().filter(b -> !this.isVanilla((IForgeRegistryEntry<?>)b) && b instanceof CropsBlock).forEach(b -> crops.put((BlockState)b.func_176223_P().func_206870_a((IProperty)((CropsBlock)b).func_185524_e(), (Comparable)Integer.valueOf(((CropsBlock)b).func_185526_g())), b.func_176223_P()));
        }
        for (String harvestKey : harvestableBlocks) {
            String[] split = this.tokenize(harvestKey);
            BlockState initial = this.fromString(split[0]);
            BlockState result = split.length > 1 ? this.fromString(split[1]) : initial.func_177230_c().func_176223_P();
            if (initial.func_177230_c() == Blocks.field_150350_a) continue;
            crops.put(initial, result);
        }
    }

    private String[] tokenize(String harvestKey) {
        boolean inBracket = false;
        for (int i = 0; i < harvestKey.length(); ++i) {
            char charAt = harvestKey.charAt(i);
            if (charAt == '[') {
                inBracket = true;
                continue;
            }
            if (charAt == ']') {
                inBracket = false;
                continue;
            }
            if (charAt != ',' || inBracket) continue;
            return new String[]{harvestKey.substring(0, i), harvestKey.substring(i + 1)};
        }
        return new String[]{harvestKey};
    }

    private boolean isVanilla(IForgeRegistryEntry<?> entry) {
        ResourceLocation loc = entry.getRegistryName();
        if (loc == null) {
            return true;
        }
        return loc.func_110624_b().equals("minecraft");
    }

    private BlockState fromString(String key) {
        try {
            BlockStateParser parser = new BlockStateParser(new StringReader(key), false).func_197243_a(false);
            BlockState state = parser.func_197249_b();
            return state == null ? Blocks.field_150350_a.func_176223_P() : state;
        }
        catch (CommandSyntaxException e) {
            return Blocks.field_150350_a.func_176223_P();
        }
    }

    private static void replant(World world, BlockPos pos, BlockState inWorld, PlayerEntity player) {
        ItemStack mainHand = player.func_184614_ca();
        boolean isHoe = !mainHand.func_190926_b() && mainHand.func_77973_b() instanceof HoeItem;
        BlockState newBlock = crops.get(inWorld);
        int fortune = HoeHarvestingModule.canFortuneApply(Enchantments.field_185308_t, mainHand) && isHoe ? EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)mainHand) : 0;
        --fortune;
        ItemStack copy = mainHand.func_77946_l();
        if (copy.func_190926_b()) {
            copy = new ItemStack((IItemProvider)Items.field_151055_y);
        }
        Map enchMap = EnchantmentHelper.func_82781_a((ItemStack)copy);
        enchMap.put(Enchantments.field_185308_t, fortune);
        EnchantmentHelper.func_82782_a((Map)enchMap, (ItemStack)copy);
        if (world instanceof ServerWorld) {
            Item blockItem = inWorld.func_177230_c().func_199767_j();
            Block.func_220077_a((BlockState)inWorld, (ServerWorld)((ServerWorld)world), (BlockPos)pos, (TileEntity)world.func_175625_s(pos), (Entity)player, (ItemStack)copy).forEach(stack -> {
                if (stack.func_77973_b() == blockItem) {
                    stack.func_190918_g(1);
                }
                if (!stack.func_190926_b()) {
                    Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)stack);
                }
            });
            inWorld.func_215706_a(world, pos, copy);
            if (!world.field_72995_K) {
                world.func_217379_c(2001, pos, Block.func_196246_j((BlockState)newBlock));
                world.func_175656_a(pos, newBlock);
            }
        }
    }

    @SubscribeEvent
    public void onClick(PlayerInteractEvent.RightClickBlock event) {
        if (SimpleHarvestModule.click(event.getPlayer(), event.getPos())) {
            event.setCanceled(true);
            event.setCancellationResult(ActionResultType.SUCCESS);
        }
    }

    public static boolean click(PlayerEntity player, BlockPos pos) {
        boolean isHoe;
        if (player == null) {
            return false;
        }
        ItemStack mainHand = player.func_184614_ca();
        boolean bl = isHoe = !mainHand.func_190926_b() && mainHand.func_77973_b() instanceof HoeItem;
        if (!emptyHandHarvest && !isHoe) {
            return false;
        }
        int range = HoeHarvestingModule.getRange(mainHand);
        int harvests = 0;
        for (int x = 1 - range; x < range; ++x) {
            for (int z = 1 - range; z < range; ++z) {
                BlockPos shiftPos = pos.func_177982_a(x, 0, z);
                BlockState worldBlock = player.field_70170_p.func_180495_p(shiftPos);
                if (!crops.containsKey(worldBlock)) continue;
                SimpleHarvestModule.replant(player.field_70170_p, shiftPos, worldBlock, player);
                ++harvests;
            }
        }
        if (harvests > 0) {
            if (harvestingCostsDurability && isHoe && !player.field_70170_p.field_72995_K) {
                mainHand.func_222118_a(1, (LivingEntity)player, p -> p.func_213334_d(Hand.MAIN_HAND));
            }
            if (mainHand.func_190926_b() && player.field_70170_p.field_72995_K) {
                QuarkNetwork.sendToServer(new HarvestMessage(pos));
            }
            return true;
        }
        return false;
    }
}

