/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.vanity.client.emote;

import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.quark.vanity.client.emote.EmoteBase;
import vazkii.quark.vanity.client.emote.ModelAccessor;

@OnlyIn(value=Dist.CLIENT)
public class EmoteState {
    private float[] states = new float[0];
    private final EmoteBase emote;

    public EmoteState(EmoteBase emote) {
        this.emote = emote;
    }

    public void save(BipedModel<?> model) {
        float[] values = new float[1];
        for (int i = 0; i < 42; ++i) {
            ModelAccessor.INSTANCE.getValues(model, i, values);
            this.states[i] = values[0];
        }
    }

    public void load(BipedModel<?> model) {
        if (this.states.length == 0) {
            this.states = new float[42];
        } else {
            float[] values = new float[1];
            for (int i = 0; i < 42; ++i) {
                values[0] = this.states[i];
                int part = i / 6 * 6;
                if (!this.emote.usesBodyPart(part)) continue;
                ModelAccessor.INSTANCE.setValues(model, i, values);
            }
        }
    }

    public void rotateAndOffset(PlayerEntity player) {
        if (this.states.length == 0) {
            return;
        }
        float offsetX = this.states[39];
        float offsetY = this.states[40];
        float offsetZ = this.states[41];
        float rotX = this.states[36];
        float rotY = this.states[37];
        float rotZ = this.states[38];
        float height = player.func_213302_cg();
        GlStateManager.translatef((float)0.0f, (float)(height / 2.0f), (float)0.0f);
        GlStateManager.translatef((float)offsetX, (float)offsetY, (float)offsetZ);
        if (rotY != 0.0f) {
            GlStateManager.rotatef((float)(rotY * 180.0f / (float)Math.PI), (float)0.0f, (float)1.0f, (float)0.0f);
        }
        if (rotX != 0.0f) {
            GlStateManager.rotatef((float)(rotX * 180.0f / (float)Math.PI), (float)1.0f, (float)0.0f, (float)0.0f);
        }
        if (rotZ != 0.0f) {
            GlStateManager.rotatef((float)(rotZ * 180.0f / (float)Math.PI), (float)0.0f, (float)0.0f, (float)1.0f);
        }
        GlStateManager.translatef((float)0.0f, (float)(-height / 2.0f), (float)0.0f);
    }
}

