/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.vanity.module;

import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootTables;
import net.minecraft.world.storage.loot.TagLootEntry;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import vazkii.arl.util.ItemNBTHelper;
import vazkii.quark.api.IRuneColorProvider;
import vazkii.quark.api.QuarkCapabilities;
import vazkii.quark.base.handler.MiscUtil;
import vazkii.quark.base.module.Config;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.Module;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.vanity.item.RainbowRuneItem;
import vazkii.quark.vanity.item.RuneItem;

@LoadModule(category=ModuleCategory.VANITY, hasSubscriptions=true)
public class ColorRunesModule
extends Module {
    public static final String TAG_RUNE_ATTACHED = "quark:RuneAttached";
    public static final String TAG_RUNE_COLOR = "quark:RuneColor";
    private static final ThreadLocal<ItemStack> targetStack = new ThreadLocal();
    public static Tag<Item> runesTag;
    @Config
    public static int dungeonWeight;
    @Config
    public static int netherFortressWeight;
    @Config
    public static int jungleTempleWeight;
    @Config
    public static int desertTempleWeight;
    @Config
    public static int itemQuality;
    @Config
    public static int applyCost;

    public static void setTargetStack(ItemStack stack) {
        targetStack.set(stack);
    }

    public static int changeColor(int color) {
        ItemStack target = targetStack.get();
        if (target == null) {
            return color;
        }
        LazyOptional<IRuneColorProvider> cap = ColorRunesModule.get((ICapabilityProvider)target);
        if (cap.isPresent()) {
            return ((IRuneColorProvider)cap.orElse(s -> color)).getRuneColor(target);
        }
        if (!ItemNBTHelper.getBoolean((ItemStack)target, (String)TAG_RUNE_ATTACHED, (boolean)false)) {
            return color;
        }
        ItemStack proxied = ItemStack.func_199557_a((CompoundNBT)ItemNBTHelper.getCompound((ItemStack)target, (String)TAG_RUNE_COLOR, (boolean)false));
        LazyOptional<IRuneColorProvider> proxyCap = ColorRunesModule.get((ICapabilityProvider)proxied);
        return ((IRuneColorProvider)proxyCap.orElse(s -> color)).getRuneColor(target);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void applyColor() {
        int color = ColorRunesModule.changeColor(-8372020);
        if (color != -8372020) {
            int a = color >> 24 & 0xFF;
            int r = color >> 16 & 0xFF;
            int g = color >> 8 & 0xFF;
            int b = color & 0xFF;
            GlStateManager.color4f((float)((float)r / 255.0f), (float)((float)g / 255.0f), (float)((float)b / 255.0f), (float)((float)a / 255.0f));
        }
    }

    @Override
    public void construct() {
        for (DyeColor color : DyeColor.values()) {
            float[] components = color.func_193349_f();
            int rgb = 0xFF000000 | (int)(255.0f * components[0]) << 16 | (int)(255.0f * components[1]) << 8 | (int)(255.0f * components[2]);
            new RuneItem(color.func_176610_l() + "_rune", (Module)this, rgb);
        }
        new RainbowRuneItem(this);
    }

    @Override
    public void setup() {
        runesTag = new ItemTags.Wrapper(new ResourceLocation("quark", "runes"));
    }

    @SubscribeEvent
    public void onLootTableLoad(LootTableLoadEvent event) {
        int weight = 0;
        if (event.getName().equals((Object)LootTables.field_186422_d)) {
            weight = dungeonWeight;
        } else if (event.getName().equals((Object)LootTables.field_186425_g)) {
            weight = netherFortressWeight;
        } else if (event.getName().equals((Object)LootTables.field_186430_l)) {
            weight = jungleTempleWeight;
        } else if (event.getName().equals((Object)LootTables.field_186429_k)) {
            weight = desertTempleWeight;
        }
        if (weight > 0) {
            LootEntry entry = TagLootEntry.func_216176_b(runesTag).func_216086_a(weight).func_216085_b(itemQuality).func_216081_b();
            MiscUtil.addToLootTable(event.getTable(), entry);
        }
    }

    @SubscribeEvent
    public void onAnvilUpdate(AnvilUpdateEvent event) {
        ItemStack left = event.getLeft();
        ItemStack right = event.getRight();
        ItemStack output = event.getOutput();
        if (!left.func_190926_b() && !right.func_190926_b() && left.func_77948_v() && right.func_77973_b().func_206844_a(runesTag)) {
            ItemStack out = (output.func_190926_b() ? left : output).func_77946_l();
            ItemNBTHelper.setBoolean((ItemStack)out, (String)TAG_RUNE_ATTACHED, (boolean)true);
            ItemNBTHelper.setCompound((ItemStack)out, (String)TAG_RUNE_COLOR, (CompoundNBT)right.serializeNBT());
            event.setOutput(out);
            event.setCost(applyCost);
            event.setMaterialCost(1);
        }
    }

    private static LazyOptional<IRuneColorProvider> get(ICapabilityProvider provider) {
        return provider.getCapability(QuarkCapabilities.RUNE_COLOR);
    }

    static {
        dungeonWeight = 10;
        netherFortressWeight = 8;
        jungleTempleWeight = 8;
        desertTempleWeight = 8;
        itemQuality = 0;
        applyCost = 15;
    }
}

