/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.vanity.module;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.ChatScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.resources.ResourcePackInfo;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import vazkii.aurelienribon.tweenengine.Tween;
import vazkii.quark.base.client.ModKeybindHandler;
import vazkii.quark.base.handler.ContributorRewardHandler;
import vazkii.quark.base.module.Config;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.Module;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.network.QuarkNetwork;
import vazkii.quark.base.network.message.RequestEmoteMessage;
import vazkii.quark.vanity.client.emote.CustomEmoteIconResourcePack;
import vazkii.quark.vanity.client.emote.EmoteBase;
import vazkii.quark.vanity.client.emote.EmoteDescriptor;
import vazkii.quark.vanity.client.emote.EmoteHandler;
import vazkii.quark.vanity.client.emote.ModelAccessor;
import vazkii.quark.vanity.client.gui.EmoteButton;
import vazkii.quark.vanity.client.gui.TranslucentButton;

@LoadModule(category=ModuleCategory.VANITY, hasSubscriptions=true, subscribeOn={Dist.CLIENT})
public class EmotesModule
extends Module {
    private static final Set<String> DEFAULT_EMOTE_NAMES = ImmutableSet.of((Object)"no", (Object)"yes", (Object)"wave", (Object)"salute", (Object)"cheer", (Object)"clap", (Object[])new String[]{"think", "point", "shrug", "headbang", "weep", "facepalm"});
    private static final Set<String> PATREON_EMOTES = ImmutableSet.of((Object)"dance", (Object)"tpose", (Object)"dab", (Object)"jet", (Object)"exorcist", (Object)"zombie", (Object[])new String[0]);
    public static final int EMOTE_BUTTON_WIDTH = 25;
    public static final int EMOTES_PER_ROW = 3;
    @Config(description="The enabled default emotes. Remove from this list to disable them. You can also re-order them, if you feel like it.")
    public static List<String> enabledEmotes = Lists.newArrayList(DEFAULT_EMOTE_NAMES);
    @Config(description="The list of Custom Emotes to be loaded.\nWatch the tutorial on Custom Emotes to learn how to make your own: https://youtu.be/ourHUkan6aQ")
    public static List<String> customEmotes = Lists.newArrayList();
    @Config(description="Enable this to make custom emotes read the file every time they're triggered so you can edit on the fly.\nDO NOT ship enabled this in a modpack, please.")
    public static boolean customEmoteDebug = false;
    public static boolean emotesVisible = false;
    public static File emotesDir;
    @OnlyIn(value=Dist.CLIENT)
    public static CustomEmoteIconResourcePack resourcePack;
    @OnlyIn(value=Dist.CLIENT)
    private static Map<KeyBinding, String> emoteKeybinds;

    @OnlyIn(value=Dist.CLIENT)
    public static <T extends ResourcePackInfo> void addResourcePack(Map<String, T> nameToPackMap, ResourcePackInfo.IFactory<T> packInfoFactory) {
        resourcePack = new CustomEmoteIconResourcePack();
        String name = "quark:emote_resources";
        ResourcePackInfo t = ResourcePackInfo.func_195793_a((String)name, (boolean)true, () -> resourcePack, packInfoFactory, (ResourcePackInfo.Priority)ResourcePackInfo.Priority.TOP);
        nameToPackMap.put(name, t);
    }

    @Override
    public void clientSetup() {
        Tween.registerAccessor(BipedModel.class, ModelAccessor.INSTANCE);
        int sortOrder = 0;
        emoteKeybinds = new HashMap<KeyBinding, String>();
        for (String s : DEFAULT_EMOTE_NAMES) {
            emoteKeybinds.put(ModKeybindHandler.init("quark.emote." + s, null, "quark.gui.keygroup.emote", sortOrder++, false), s);
        }
        for (String s : PATREON_EMOTES) {
            emoteKeybinds.put(ModKeybindHandler.init("patreon_emote." + s, null, "quark.gui.keygroup.emote", sortOrder++), s);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void configChangedClient() {
        EmoteHandler.clearEmotes();
        for (String s : enabledEmotes) {
            if (!DEFAULT_EMOTE_NAMES.contains(s)) continue;
            EmoteHandler.addEmote(s);
        }
        for (String s : PATREON_EMOTES) {
            EmoteHandler.addEmote(s);
        }
        for (String s : customEmotes) {
            EmoteHandler.addCustomEmote(s);
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void initGui(GuiScreenEvent.InitGuiEvent.Post event) {
        Screen gui = event.getGui();
        if (gui instanceof ChatScreen) {
            TreeMap<Integer, List> descriptorSorting = new TreeMap<Integer, List>();
            for (EmoteDescriptor desc : EmoteHandler.emoteMap.values()) {
                if (desc.getTier() > ContributorRewardHandler.localPatronTier) continue;
                List descriptors = descriptorSorting.computeIfAbsent(desc.getTier(), k -> new LinkedList());
                descriptors.add(desc);
            }
            int rows = 0;
            int row = 0;
            Set keys = descriptorSorting.keySet();
            Iterator iterator = keys.iterator();
            while (iterator.hasNext()) {
                int tier = (Integer)iterator.next();
                List descriptors = (List)descriptorSorting.get(tier);
                if (descriptors == null) continue;
                rows += descriptors.size() / 3;
                if (descriptors.size() % 3 == 0) continue;
                ++rows;
            }
            LinkedList<EmoteButton> emoteButtons = new LinkedList<EmoteButton>();
            Iterator iterator2 = keys.iterator();
            while (iterator2.hasNext()) {
                int tier = (Integer)iterator2.next();
                int rowPos = 0;
                int tierRow = 0;
                List descriptors = (List)descriptorSorting.get(tier);
                if (descriptors != null) {
                    for (EmoteDescriptor desc : descriptors) {
                        int rowSize = Math.min(descriptors.size() - tierRow * 3, 3);
                        int x = gui.width - (((rowPos + 1) * 2 + 3 - rowSize) * 25 / 2 + 1);
                        int y = gui.height - (40 + 25 * (rows - row));
                        EmoteButton button = new EmoteButton(x, y, desc, b -> {
                            String name = desc.getRegistryName();
                            QuarkNetwork.sendToServer(new RequestEmoteMessage(name));
                        });
                        emoteButtons.add(button);
                        button.visible = emotesVisible;
                        button.active = emotesVisible;
                        event.addWidget((Widget)button);
                        if (++rowPos != 3) continue;
                        ++tierRow;
                        ++row;
                        rowPos = 0;
                    }
                }
                if (rowPos == 0) continue;
                ++row;
            }
            event.addWidget((Widget)new TranslucentButton(gui.width - 1 - 75, gui.height - 40, 75, 20, I18n.func_135052_a((String)"quark.gui.button.emotes", (Object[])new Object[0]), b -> {
                for (Button bt : emoteButtons) {
                    if (!(bt instanceof EmoteButton)) continue;
                    bt.visible = !bt.visible;
                    bt.active = !bt.active;
                }
                emotesVisible = !emotesVisible;
            }));
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onKeyInput(InputEvent.KeyInputEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.func_195544_aj()) {
            for (KeyBinding key : emoteKeybinds.keySet()) {
                if (!key.func_151470_d()) continue;
                String emote = emoteKeybinds.get(key);
                QuarkNetwork.sendToServer(new RequestEmoteMessage(emote));
                return;
            }
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void drawHUD(RenderGameOverlayEvent.Post event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.ALL) {
            Minecraft mc = Minecraft.func_71410_x();
            MainWindow res = event.getWindow();
            EmoteBase emote = EmoteHandler.getPlayerEmote((PlayerEntity)mc.field_71439_g);
            if (emote != null && emote.timeDone < emote.totalTime) {
                ResourceLocation resource = emote.desc.texture;
                int x = res.func_198107_o() / 2 - 16;
                int y = res.func_198087_p() / 2 - 60;
                float transparency = 1.0f;
                float tween = 5.0f;
                if (emote.timeDone < tween) {
                    transparency = emote.timeDone / tween;
                } else if (emote.timeDone > emote.totalTime - tween) {
                    transparency = (emote.totalTime - emote.timeDone) / tween;
                }
                GlStateManager.pushMatrix();
                GlStateManager.disableLighting();
                GlStateManager.enableBlend();
                GlStateManager.disableAlphaTest();
                GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)transparency);
                mc.func_110434_K().func_110577_a(resource);
                Screen.blit((int)x, (int)y, (float)0.0f, (float)0.0f, (int)32, (int)32, (int)32, (int)32);
                GlStateManager.enableBlend();
                String name = I18n.func_135052_a((String)emote.desc.getTranslationKey(), (Object[])new Object[0]);
                mc.field_71466_p.func_175063_a(name, (float)res.func_198107_o() / 2.0f - (float)mc.field_71466_p.func_78256_a(name) / 2.0f, (float)(y + 34), 0xFFFFFF + ((int)(transparency * 255.0f) << 24));
                GlStateManager.popMatrix();
            }
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void renderTick(TickEvent.RenderTickEvent event) {
        EmoteHandler.onRenderTick(Minecraft.func_71410_x());
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    @OnlyIn(value=Dist.CLIENT)
    public void preRenderLiving(RenderLivingEvent.Pre<PlayerEntity, ?> event) {
        if (event.getEntity() instanceof PlayerEntity) {
            EmoteHandler.preRender((PlayerEntity)event.getEntity());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    @OnlyIn(value=Dist.CLIENT)
    public void postRenderLiving(RenderLivingEvent.Post<PlayerEntity, ?> event) {
        if (event.getEntity() instanceof PlayerEntity) {
            EmoteHandler.postRender((PlayerEntity)event.getEntity());
        }
    }
}

