/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.block;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemGroup;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;
import vazkii.quark.base.block.QuarkGlassBlock;
import vazkii.quark.base.module.Module;

public class CaveCrystalBlock
extends QuarkGlassBlock {
    private final float[] colorComponents;
    private final Vec3d colorVector;

    public CaveCrystalBlock(String regname, int color, Module module, MaterialColor materialColor) {
        super(regname, module, ItemGroup.field_78031_c, Block.Properties.func_200949_a((Material)Material.field_151592_s, (MaterialColor)materialColor).func_200948_a(0.3f, 0.0f).func_200947_a(SoundType.field_185853_f).func_200951_a(11).harvestTool(ToolType.PICKAXE).harvestLevel(0));
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        this.colorComponents = new float[]{r, g, b};
        this.colorVector = new Vec3d((double)r, (double)g, (double)b);
    }

    @Nullable
    public float[] getBeaconColorMultiplier(BlockState state, IWorldReader world, BlockPos pos, BlockPos beaconPos) {
        return this.colorComponents;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Vec3d getFogColor(BlockState state, IWorldReader world, BlockPos pos, Entity entity, Vec3d originalColor, float partialTicks) {
        return this.colorVector;
    }

    @Nonnull
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }
}

