/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.block;

import java.util.Random;
import java.util.function.BooleanSupplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.MushroomBlock;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.IPlantable;
import vazkii.arl.util.RegistryHelper;
import vazkii.quark.base.block.IQuarkBlock;
import vazkii.quark.base.module.Module;
import vazkii.quark.world.block.HugeGlowshroomBlock;
import vazkii.quark.world.module.underground.GlowshroomUndergroundBiomeModule;

public class GlowshroomBlock
extends MushroomBlock
implements IQuarkBlock {
    private final Module module;
    private BooleanSupplier enabledSupplier = () -> true;

    public GlowshroomBlock(Module module) {
        super(Block.Properties.func_200950_a((Block)Blocks.field_150337_Q).func_200951_a(14).func_200944_c());
        this.module = module;
        RegistryHelper.registerBlock((Block)this, (String)"glowshroom");
        RegistryHelper.setCreativeTab((Block)this, (ItemGroup)ItemGroup.field_78031_c);
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.func_177977_b();
        return worldIn.func_180495_p(blockpos).func_177230_c() == GlowshroomUndergroundBiomeModule.glowcelium;
    }

    public boolean canSustainPlant(@Nonnull BlockState state, @Nonnull IBlockReader world, BlockPos pos, @Nonnull Direction facing, IPlantable plantable) {
        return state.func_177230_c() == GlowshroomUndergroundBiomeModule.glowcelium;
    }

    public void func_196267_b(@Nonnull BlockState state, @Nonnull World worldIn, @Nonnull BlockPos pos, Random rand) {
        if (rand.nextInt(GlowshroomUndergroundBiomeModule.glowshroomGrowthRate) == 0) {
            int i = 5;
            for (BlockPos targetPos : BlockPos.func_218278_a((BlockPos)pos.func_177982_a(-4, -1, -4), (BlockPos)pos.func_177982_a(4, 1, 4))) {
                if (worldIn.func_180495_p(targetPos).func_177230_c() != this || --i > 0) continue;
                return;
            }
            BlockPos shiftedPos = pos.func_177982_a(rand.nextInt(3) - 1, rand.nextInt(2) - rand.nextInt(2), rand.nextInt(3) - 1);
            for (int k = 0; k < 4; ++k) {
                if (worldIn.func_175623_d(shiftedPos) && state.func_196955_c((IWorldReader)worldIn, shiftedPos)) {
                    pos = shiftedPos;
                }
                shiftedPos = pos.func_177982_a(rand.nextInt(3) - 1, rand.nextInt(2) - rand.nextInt(2), rand.nextInt(3) - 1);
            }
            if (worldIn.func_175623_d(shiftedPos) && state.func_196955_c((IWorldReader)worldIn, shiftedPos)) {
                worldIn.func_180501_a(shiftedPos, this.func_176223_P(), 2);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        super.func_180655_c(stateIn, worldIn, pos, rand);
        if (rand.nextInt(20) == 0) {
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197624_q, (double)pos.func_177958_n() + 0.2 + (double)rand.nextFloat() * 0.6, (double)((float)pos.func_177956_o() + 0.3f), (double)pos.func_177952_p() + 0.2 + (double)rand.nextFloat() * 0.6, 0.0, 0.0, 0.0);
        }
    }

    public boolean func_176473_a(@Nonnull IBlockReader worldIn, @Nonnull BlockPos pos, @Nonnull BlockState state, boolean isClient) {
        return GlowshroomUndergroundBiomeModule.enableHugeGlowshrooms;
    }

    public boolean func_180670_a(@Nonnull World worldIn, @Nonnull Random rand, @Nonnull BlockPos pos, @Nonnull BlockState state) {
        return GlowshroomUndergroundBiomeModule.enableHugeGlowshrooms && (double)rand.nextFloat() < 0.4;
    }

    public void func_176474_b(@Nonnull World worldIn, @Nonnull Random rand, @Nonnull BlockPos pos, @Nonnull BlockState state) {
        if (GlowshroomUndergroundBiomeModule.enableHugeGlowshrooms) {
            worldIn.func_217377_a(pos, false);
            if (!HugeGlowshroomBlock.place(worldIn, rand, pos)) {
                worldIn.func_175656_a(pos, this.func_176223_P());
            }
        }
    }

    public void func_149666_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.isEnabled() || group == ItemGroup.field_78027_g) {
            super.func_149666_a(group, items);
        }
    }

    @Override
    public GlowshroomBlock setCondition(BooleanSupplier enabledSupplier) {
        this.enabledSupplier = enabledSupplier;
        return this;
    }

    @Override
    public boolean doesConditionApply() {
        return this.enabledSupplier.getAsBoolean();
    }

    @Override
    @Nullable
    public Module getModule() {
        return this.module;
    }
}

