/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.module;

import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import vazkii.arl.util.RegistryHelper;
import vazkii.quark.base.module.Config;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.Module;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.world.EntitySpawnHandler;
import vazkii.quark.base.world.config.BiomeTypeConfig;
import vazkii.quark.base.world.config.EntitySpawnConfig;
import vazkii.quark.world.client.render.FoxhoundRenderer;
import vazkii.quark.world.entity.FoxhoundEntity;

@LoadModule(category=ModuleCategory.WORLD, hasSubscriptions=true)
public class FoxhoundModule
extends Module {
    public static EntityType<FoxhoundEntity> foxhoundType;
    @Config(description="The chance coal will tame a foxhound")
    public static double tameChance;
    @Config
    public static EntitySpawnConfig spawnConfig;

    @Override
    public void construct() {
        foxhoundType = EntityType.Builder.func_220322_a(FoxhoundEntity::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(0.8f, 0.8f).setTrackingRange(80).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true).func_220320_c().setCustomClientFactory((spawnEntity, world) -> new FoxhoundEntity((EntityType<? extends FoxhoundEntity>)foxhoundType, (World)world)).func_206830_a("foxhound");
        RegistryHelper.register(foxhoundType, (String)"foxhound");
        EntitySpawnHandler.registerSpawn(this, foxhoundType, EntityClassification.MONSTER, EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, FoxhoundEntity::spawnPredicate, spawnConfig);
        EntitySpawnHandler.addEgg(foxhoundType, 8981773, 15904587, spawnConfig);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientSetup() {
        RenderingRegistry.registerEntityRenderingHandler(FoxhoundEntity.class, FoxhoundRenderer::new);
    }

    static {
        tameChance = 0.05;
        spawnConfig = new EntitySpawnConfig(30, 1, 2, new BiomeTypeConfig(false, BiomeDictionary.Type.NETHER));
    }
}

