/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.module;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.world.gen.GenerationStage;
import vazkii.quark.base.module.Config;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.Module;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.world.WorldGenHandler;
import vazkii.quark.base.world.config.DimensionConfig;
import vazkii.quark.base.world.generator.Generator;
import vazkii.quark.world.block.SpeleothemBlock;
import vazkii.quark.world.gen.SpeleothemGenerator;
import vazkii.quark.world.module.NewStoneTypesModule;

@LoadModule(category=ModuleCategory.WORLD)
public class SpeleothemsModule
extends Module {
    @Config
    public static DimensionConfig dimensions = DimensionConfig.all();
    @Config
    public static int triesPerChunk = 60;
    @Config
    public static int speleothemsPerChunk = 12;
    @Config
    public static int triesPerChunkInNether = 4;
    @Config
    public static int speleothemsPerChunkInNether = 12;
    @Config
    public static int maxYlevel = 55;
    public static Map<Block, Block> speleothemMapping = new HashMap<Block, Block>();

    @Override
    public void modulesStarted() {
        this.make("stone", Blocks.field_150348_b, MaterialColor.field_151665_m, false);
        this.make("netherrack", Blocks.field_150424_aL, MaterialColor.field_151655_K, true);
        this.make("granite", Blocks.field_196650_c, MaterialColor.field_151664_l, false);
        this.make("diorite", Blocks.field_196654_e, MaterialColor.field_151677_p, false);
        this.make("andesite", Blocks.field_196656_g, MaterialColor.field_151665_m, false);
        this.make("marble", NewStoneTypesModule.marbleBlock, MaterialColor.field_151677_p, false).setCondition(() -> NewStoneTypesModule.enableMarble);
        this.make("limestone", NewStoneTypesModule.limestoneBlock, MaterialColor.field_151665_m, false).setCondition(() -> NewStoneTypesModule.enableLimestone);
        this.make("jasper", NewStoneTypesModule.jasperBlock, MaterialColor.field_193559_aa, false).setCondition(() -> NewStoneTypesModule.enableJasper);
        this.make("slate", NewStoneTypesModule.slateBlock, MaterialColor.field_151657_g, false).setCondition(() -> NewStoneTypesModule.enableSlate);
        this.make("basalt", NewStoneTypesModule.basaltBlock, MaterialColor.field_151646_E, false).setCondition(() -> NewStoneTypesModule.enableBasalt);
    }

    private SpeleothemBlock make(String name, Block parent, MaterialColor color, boolean nether) {
        SpeleothemBlock block = new SpeleothemBlock(name, (Module)this, color, nether);
        speleothemMapping.put(parent, (Block)block);
        return block;
    }

    @Override
    public void setup() {
        WorldGenHandler.addGenerator(this, new SpeleothemGenerator(dimensions, Generator.NO_COND), GenerationStage.Decoration.UNDERGROUND_DECORATION, 2);
    }
}

