/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.useful_railroads.data.provider;

import com.google.gson.JsonElement;
import info.u_team.u_team_core.data.CommonProvider;
import info.u_team.useful_railroads.data.builder.FuelRecipeBuilder;
import info.u_team.useful_railroads.init.UsefulRailroadsBlocks;
import info.u_team.useful_railroads.init.UsefulRailroadsItems;
import info.u_team.useful_railroads.init.UsefulRailroadsRecipeSerializers;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.criterion.InventoryChangeTrigger;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.advancements.criterion.MinMaxBounds;
import net.minecraft.data.CustomRecipeBuilder;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.data.ShapedRecipeBuilder;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.Tags;

public class UsefulRailroadsRecipesProvider
extends CommonProvider {
    public UsefulRailroadsRecipesProvider(DataGenerator generator) {
        super("Recipes", generator);
    }

    public void func_200398_a(DirectoryCache cache) throws IOException {
        Path recipePath = this.path.resolve("recipes");
        Path advancementPath = this.path.resolve("advancements");
        Consumer<IFinishedRecipe> consumer = recipe -> {
            try {
                this.write(cache, (JsonElement)recipe.func_200441_a(), recipePath.resolve(recipe.func_200442_b().func_110623_a() + ".json"));
                if (recipe.func_200440_c() != null) {
                    this.write(cache, (JsonElement)recipe.func_200440_c(), advancementPath.resolve(recipe.func_200442_b().func_110623_a() + ".json"));
                }
            }
            catch (IOException ex) {
                LOGGER.error(this.marker, "Could not write data.", (Throwable)ex);
            }
        };
        this.addCraftingRecipes(consumer);
        this.addFuelRecipes(consumer);
    }

    protected Path resolvePath(Path outputFolder) {
        return this.resolveData(outputFolder, "usefulrailroads");
    }

    private void addCraftingRecipes(Consumer<IFinishedRecipe> consumer) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)UsefulRailroadsBlocks.HIGHSPEED_RAIL, (int)24).func_200472_a("IDI").func_200472_a("LSL").func_200472_a("IRI").func_200471_a(Character.valueOf('R'), this.getIngredientOfTag((Tag<Item>)Tags.Items.DUSTS_REDSTONE)).func_200462_a(Character.valueOf('S'), (IItemProvider)Items.field_151055_y).func_200471_a(Character.valueOf('I'), this.getIngredientOfTag((Tag<Item>)Tags.Items.INGOTS_IRON)).func_200471_a(Character.valueOf('D'), this.getIngredientOfTag((Tag<Item>)Tags.Items.GEMS_DIAMOND)).func_200471_a(Character.valueOf('L'), this.getIngredientOfTag((Tag<Item>)Tags.Items.GEMS_LAPIS)).func_200465_a("has_minecart", (ICriterionInstance)this.hasItem((IItemProvider)Items.field_151143_au)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)UsefulRailroadsBlocks.DIRECTION_RAIL, (int)16).func_200472_a("IEI").func_200472_a("IRI").func_200472_a("ISI").func_200462_a(Character.valueOf('S'), (IItemProvider)Items.field_151055_y).func_200471_a(Character.valueOf('R'), this.getIngredientOfTag((Tag<Item>)Tags.Items.DUSTS_REDSTONE)).func_200471_a(Character.valueOf('I'), this.getIngredientOfTag((Tag<Item>)Tags.Items.INGOTS_IRON)).func_200462_a(Character.valueOf('E'), (IItemProvider)Items.field_222027_iT).func_200465_a("has_minecart", (ICriterionInstance)this.hasItem((IItemProvider)Items.field_151143_au)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)UsefulRailroadsBlocks.TELEPORT_RAIL, (int)1).func_200472_a("IDI").func_200472_a("ESE").func_200472_a("IRI").func_200471_a(Character.valueOf('R'), this.getIngredientOfTag((Tag<Item>)Tags.Items.DUSTS_REDSTONE)).func_200462_a(Character.valueOf('S'), (IItemProvider)Items.field_151055_y).func_200471_a(Character.valueOf('I'), this.getIngredientOfTag((Tag<Item>)Tags.Items.INGOTS_IRON)).func_200471_a(Character.valueOf('D'), this.getIngredientOfTag((Tag<Item>)Tags.Items.GEMS_DIAMOND)).func_200462_a(Character.valueOf('E'), (IItemProvider)Items.field_151079_bi).func_200465_a("has_minecart", (ICriterionInstance)this.hasItem((IItemProvider)Items.field_151143_au)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)UsefulRailroadsBlocks.INTERSECTION_RAIL, (int)8).func_200472_a("III").func_200472_a("ISI").func_200472_a("III").func_200462_a(Character.valueOf('S'), (IItemProvider)Items.field_151055_y).func_200471_a(Character.valueOf('I'), this.getIngredientOfTag((Tag<Item>)Tags.Items.INGOTS_IRON)).func_200465_a("has_minecart", (ICriterionInstance)this.hasItem((IItemProvider)Items.field_151143_au)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)UsefulRailroadsBlocks.BUFFER_STOP, (int)2).func_200472_a("III").func_200472_a(" B ").func_200472_a("I I").func_200471_a(Character.valueOf('B'), this.getIngredientOfTag((Tag<Item>)Tags.Items.STORAGE_BLOCKS_IRON)).func_200471_a(Character.valueOf('I'), this.getIngredientOfTag((Tag<Item>)Tags.Items.INGOTS_IRON)).func_200465_a("has_minecart", (ICriterionInstance)this.hasItem((IItemProvider)Items.field_151143_au)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)UsefulRailroadsItems.SINGLE_TRACK_BUILDER, (int)1).func_200472_a("IBI").func_200472_a("PRC").func_200472_a("IAI").func_200471_a(Character.valueOf('I'), this.getIngredientOfTag((Tag<Item>)Tags.Items.INGOTS_IRON)).func_200471_a(Character.valueOf('B'), this.getIngredientOfTag((Tag<Item>)Tags.Items.STORAGE_BLOCKS_REDSTONE)).func_200462_a(Character.valueOf('P'), (IItemProvider)Items.field_222027_iT).func_200471_a(Character.valueOf('R'), this.getIngredientOfTag((Tag<Item>)Tags.Items.DUSTS_REDSTONE)).func_200462_a(Character.valueOf('C'), (IItemProvider)Items.field_222029_iU).func_200462_a(Character.valueOf('A'), (IItemProvider)Items.field_221666_au).func_200465_a("has_redstone", (ICriterionInstance)this.hasItem((Tag<Item>)Tags.Items.DUSTS_REDSTONE)).func_200465_a("has_iron", (ICriterionInstance)this.hasItem((Tag<Item>)Tags.Items.INGOTS_IRON)).func_200465_a("has_rail", (ICriterionInstance)this.hasItem((IItemProvider)Items.field_221666_au)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)UsefulRailroadsItems.DOUBLE_TRACK_BUILDER, (int)1).func_200472_a("IBI").func_200472_a("PRC").func_200472_a("AIA").func_200471_a(Character.valueOf('I'), this.getIngredientOfTag((Tag<Item>)Tags.Items.STORAGE_BLOCKS_IRON)).func_200471_a(Character.valueOf('B'), this.getIngredientOfTag((Tag<Item>)Tags.Items.STORAGE_BLOCKS_REDSTONE)).func_200462_a(Character.valueOf('P'), (IItemProvider)Items.field_222027_iT).func_200471_a(Character.valueOf('R'), this.getIngredientOfTag((Tag<Item>)Tags.Items.DUSTS_REDSTONE)).func_200462_a(Character.valueOf('C'), (IItemProvider)Items.field_222029_iU).func_200462_a(Character.valueOf('A'), (IItemProvider)Items.field_221666_au).func_200465_a("has_redstone", (ICriterionInstance)this.hasItem((Tag<Item>)Tags.Items.DUSTS_REDSTONE)).func_200465_a("has_iron", (ICriterionInstance)this.hasItem((Tag<Item>)Tags.Items.INGOTS_IRON)).func_200465_a("has_rail", (ICriterionInstance)this.hasItem((IItemProvider)Items.field_221666_au)).func_200464_a(consumer);
        CustomRecipeBuilder.func_218656_a(UsefulRailroadsRecipeSerializers.CRAFTING_SPECIAL_TELEPORT_RAIL_REMOVE_LOCATION).func_200499_a(consumer, "teleport_rail_remove_location");
    }

    private void addFuelRecipes(Consumer<IFinishedRecipe> consumer) {
        this.addTeleportRailFuel(Items.field_151079_bi, 100, consumer, "ender_pearl");
        this.addTeleportRailFuel(Items.field_151061_bv, 150, consumer, "ender_eye");
        this.addTeleportRailFuel(Items.field_221663_bT, 250, consumer, "chorus_flower");
        this.addTeleportRailFuel(Items.field_185161_cS, 200, consumer, "chorus_fruit");
        this.addTeleportRailFuel(Items.field_185162_cT, 210, consumer, "popped_chorus_fruit");
        this.addTeleportRailFuel((Tag<Item>)Tags.Items.DUSTS_REDSTONE, 5, consumer, "redstone_dusts");
        this.addTeleportRailFuel((Tag<Item>)Tags.Items.INGOTS_GOLD, 10, consumer, "gold_ingots");
        this.addTeleportRailFuel((Tag<Item>)Tags.Items.GEMS_DIAMOND, 50, consumer, "diamond_gems");
        this.addTrackBuilderFuel((Tag<Item>)ItemTags.field_219775_L, 100, consumer, "coals");
        this.addTrackBuilderFuel((Tag<Item>)Tags.Items.STORAGE_BLOCKS_COAL, 900, consumer, "coal_blocks");
    }

    private void addTeleportRailFuel(Item item, int fuel, Consumer<IFinishedRecipe> consumer, String name) {
        this.addTeleportRailFuel(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{item}), this.hasItem((IItemProvider)item), fuel, consumer, name);
    }

    private void addTeleportRailFuel(Tag<Item> tag, int fuel, Consumer<IFinishedRecipe> consumer, String name) {
        this.addTeleportRailFuel(this.getIngredientOfTag(tag), this.hasItem(tag), fuel, consumer, name);
    }

    private void addTeleportRailFuel(Ingredient ingredient, InventoryChangeTrigger.Instance trigger, int fuel, Consumer<IFinishedRecipe> consumer, String name) {
        FuelRecipeBuilder.teleportRailFuel(ingredient, fuel).addCriterion("has_ingredient", (ICriterionInstance)trigger).build(consumer, new ResourceLocation("usefulrailroads", "fuel/teleport_rail/" + name));
    }

    private void addTrackBuilderFuel(Tag<Item> tag, int fuel, Consumer<IFinishedRecipe> consumer, String name) {
        this.addTrackBuilderFuel(this.getIngredientOfTag(tag), this.hasItem(tag), fuel, consumer, name);
    }

    private void addTrackBuilderFuel(Ingredient ingredient, InventoryChangeTrigger.Instance trigger, int fuel, Consumer<IFinishedRecipe> consumer, String name) {
        FuelRecipeBuilder.trackBuilderFuel(ingredient, fuel).addCriterion("has_ingredient", (ICriterionInstance)trigger).build(consumer, new ResourceLocation("usefulrailroads", "fuel/track_builder/" + name));
    }

    protected InventoryChangeTrigger.Instance hasItem(Tag<Item> tag) {
        return this.hasItem(ItemPredicate.Builder.func_200309_a().func_200307_a(tag).func_200310_b());
    }

    private InventoryChangeTrigger.Instance hasItem(IItemProvider item) {
        return this.hasItem(ItemPredicate.Builder.func_200309_a().func_200308_a(item).func_200310_b());
    }

    private InventoryChangeTrigger.Instance hasItem(ItemPredicate ... predicates) {
        return new InventoryChangeTrigger.Instance(MinMaxBounds.IntBound.field_211347_e, MinMaxBounds.IntBound.field_211347_e, MinMaxBounds.IntBound.field_211347_e, predicates);
    }

    private Ingredient getIngredientOfTag(Tag<Item> tag) {
        return Ingredient.func_209357_a(Stream.of(new Ingredient.TagList(tag){

            public Collection<ItemStack> func_199799_a() {
                return Arrays.asList(new ItemStack((IItemProvider)Items.field_185153_aK));
            }
        }));
    }
}

