/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.useful_railroads.item;

import info.u_team.useful_railroads.block.TeleportRailBlock;
import info.u_team.useful_railroads.util.Location;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.Rarity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class TeleportRailBlockItem
extends BlockItem {
    public TeleportRailBlockItem(TeleportRailBlock block, Item.Properties builder) {
        super((Block)block, builder.func_200917_a(1).func_208103_a(Rarity.EPIC));
    }

    public ActionResultType func_195942_a(BlockItemUseContext context) {
        CompoundNBT compound = context.func_195996_i().func_179543_a("BlockEntityTag");
        if (compound != null && compound.func_74764_b("location")) {
            return super.func_195942_a(context);
        }
        PlayerEntity player = context.func_195999_j();
        if (player != null && player.func_130014_f_().field_72995_K) {
            player.func_145747_a(new TranslationTextComponent("block.usefulrailroads.teleport_rail.missing_setup", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
        }
        return ActionResultType.FAIL;
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity itemEntity) {
        CompoundNBT compound = stack.func_179543_a("BlockEntityTag");
        if (compound != null && compound.func_74764_b("location")) {
            return false;
        }
        World world = itemEntity.func_130014_f_();
        if (world.field_72995_K) {
            if (world.field_73012_v.nextInt(10) == 0) {
                for (int i = 0; i < 5; ++i) {
                    world.func_195590_a((IParticleData)ParticleTypes.field_197623_p, true, itemEntity.field_70165_t, itemEntity.field_70163_u + 0.5, itemEntity.field_70161_v, TeleportRailBlockItem.getRandomNumberInRange(world.field_73012_v, -0.2, 0.2), TeleportRailBlockItem.getRandomNumberInRange(world.field_73012_v, 0.1, 1.5), TeleportRailBlockItem.getRandomNumberInRange(world.field_73012_v, -0.2, 0.2));
                }
            }
        } else {
            int age = itemEntity.field_70292_b;
            if (age < 100) {
                return false;
            }
            AxisAlignedBB aabb = new AxisAlignedBB(itemEntity.field_70165_t - 1.0, itemEntity.field_70163_u - 1.0, itemEntity.field_70161_v - 1.0, itemEntity.field_70165_t + 1.0, itemEntity.field_70163_u + 1.0, itemEntity.field_70161_v + 1.0);
            world.func_175674_a((Entity)itemEntity, aabb, ItemEntity.class::isInstance).stream().map(ItemEntity.class::cast).map(ItemEntity::func_92059_d).filter(otherStack -> otherStack.func_77973_b() == Items.field_151079_bi).findAny().ifPresent(otherStack -> {
                otherStack.func_190918_g(1);
                stack.func_190925_c("BlockEntityTag").func_218657_a("location", (INBT)new Location(world.func_201675_m().func_186058_p(), itemEntity.func_180425_c()).serializeNBT());
                ItemEntity newItemEntity = new ItemEntity(world, itemEntity.field_70165_t, itemEntity.field_70163_u, itemEntity.field_70161_v, stack);
                newItemEntity.func_174869_p();
                itemEntity.func_70106_y();
                world.func_217376_c((Entity)newItemEntity);
                if (world instanceof ServerWorld) {
                    ((ServerWorld)world).func_217468_a(new LightningBoltEntity(world, itemEntity.field_70165_t, itemEntity.field_70163_u, itemEntity.field_70161_v, true));
                }
            });
        }
        return false;
    }

    public static double getRandomNumberInRange(Random random, double min, double max) {
        return random.nextDouble() * (max - min) + min;
    }
}

