/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.useful_railroads.item;

import info.u_team.u_team_core.item.UItem;
import info.u_team.useful_railroads.container.TrackBuilderContainer;
import info.u_team.useful_railroads.init.UsefulRailroadsItemGroups;
import info.u_team.useful_railroads.inventory.TrackBuilderInventoryWrapper;
import info.u_team.useful_railroads.util.TrackBuilderManager;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Rarity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class TrackBuilderItem
extends UItem {
    private final boolean doubleTrack;

    public TrackBuilderItem(String name, boolean doubleTrack) {
        super(name, (ItemGroup)UsefulRailroadsItemGroups.GROUP, new Item.Properties().func_200917_a(1).func_208103_a(doubleTrack ? Rarity.EPIC : Rarity.RARE));
        this.doubleTrack = doubleTrack;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K && !player.func_70093_af() && player instanceof ServerPlayerEntity) {
            final TrackBuilderInventoryWrapper.Server wrapper = new TrackBuilderInventoryWrapper.Server(stack, () -> player.field_70170_p);
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new INamedContainerProvider(){

                public Container createMenu(int id, PlayerInventory playerInventory, PlayerEntity player) {
                    return new TrackBuilderContainer(id, playerInventory, wrapper);
                }

                public ITextComponent func_145748_c_() {
                    return new TranslationTextComponent("container.usefulrailroads.track_builder", new Object[0]);
                }
            }, buffer -> {
                buffer.func_150787_b(wrapper.getFuel());
                buffer.func_179249_a((Enum)wrapper.getMode());
            });
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        World world = context.func_195991_k();
        if (world.field_72995_K) {
            return ActionResultType.PASS;
        }
        PlayerEntity player = context.func_195999_j();
        if (player == null || !context.func_195998_g() || context.func_221531_n() == Hand.OFF_HAND) {
            return ActionResultType.PASS;
        }
        TrackBuilderInventoryWrapper.Server wrapper = new TrackBuilderInventoryWrapper.Server(context.func_195996_i(), () -> player.field_70170_p);
        TrackBuilderManager.create(context.func_195995_a(), context.func_196000_l(), world, player.func_70040_Z(), wrapper.getMode(), this.doubleTrack).ifPresent(manager -> manager.execute(player, wrapper));
        return ActionResultType.SUCCESS;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !ItemStack.func_179545_c((ItemStack)oldStack, (ItemStack)newStack);
    }

    public boolean isDoubleTrack() {
        return this.doubleTrack;
    }
}

