/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.useful_railroads.tileentity;

import info.u_team.u_team_core.api.sync.IInitSyncedTileEntity;
import info.u_team.u_team_core.tileentity.UTileEntity;
import info.u_team.useful_railroads.container.TeleportRailContainer;
import info.u_team.useful_railroads.init.UsefulRailroadsRecipeTypes;
import info.u_team.useful_railroads.init.UsefulRailroadsTileEntityTypes;
import info.u_team.useful_railroads.inventory.FuelItemHandler;
import info.u_team.useful_railroads.recipe.TeleportRailFuelRecipe;
import info.u_team.useful_railroads.util.Location;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Direction;
import net.minecraft.util.concurrent.TickDelayedTask;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.server.TicketType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TeleportRailTileEntity
extends UTileEntity
implements IInitSyncedTileEntity {
    private Location location = Location.getOrigin();
    private int fuel;
    private int cost;
    private final LazyOptional<IItemHandler> slot = LazyOptional.of(() -> new FuelItemHandler<TeleportRailFuelRecipe>(UsefulRailroadsRecipeTypes.TELEPORT_RAIL_FUEL, () -> this.func_145831_w(), () -> this.fuel < 10000, fuelAdder -> {
        this.fuel += fuelAdder;
        this.func_70296_d();
    }));

    public TeleportRailTileEntity() {
        super(UsefulRailroadsTileEntityTypes.TELEPORT_RAIL);
    }

    private void checkCost() {
        if (this.cost == 0) {
            this.cost = this.calculateCost();
        }
    }

    private int calculateCost() {
        int calculatedCost = 0;
        if (this.location.getDimensionType() != this.field_145850_b.func_201675_m().func_186058_p()) {
            calculatedCost += 100;
        }
        double calculatedDistance = Math.log(this.field_174879_c.func_177951_i((Vec3i)this.location.getPos())) / Math.log(5.0);
        if ((calculatedCost += MathHelper.func_76128_c((double)(calculatedDistance *= calculatedDistance))) == 0) {
            return 1;
        }
        return calculatedCost;
    }

    public void teleport(BlockPos pos, AbstractMinecartEntity cart) {
        Entity entity;
        this.checkCost();
        cart.func_213293_j(0.0, 0.0, 0.0);
        Entity entity2 = entity = cart.func_184188_bt().isEmpty() ? null : (Entity)cart.func_184188_bt().get(0);
        if (this.fuel < this.cost) {
            if (entity instanceof PlayerEntity) {
                ((PlayerEntity)entity).func_146105_b(new TranslationTextComponent("block.usefulrailroads.teleport_rail.not_enough_fuel", new Object[]{this.cost}).func_150255_a(new Style().func_150238_a(TextFormatting.RED)), true);
            }
            return;
        }
        this.fuel -= this.cost;
        this.func_70296_d();
        ServerWorld teleportWorld = cart.func_184102_h().func_71218_a(this.location.getDimensionType());
        cart.func_184102_h().func_212871_a_((Runnable)new TickDelayedTask(0, () -> {
            if (entity != null) {
                entity.func_213319_R();
                TeleportRailTileEntity.teleportEntity(entity, teleportWorld, this.location.getPos());
            }
            TeleportRailTileEntity.teleportEntity((Entity)cart, teleportWorld, this.location.getPos());
            if (entity != null) {
                entity.func_184205_a(teleportWorld.func_217461_a(cart.func_110124_au()), true);
            }
        }));
    }

    private static void teleportEntity(Entity entity, ServerWorld world, BlockPos pos) {
        TeleportRailTileEntity.teleportEntity(entity, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), entity.field_70177_z, entity.field_70125_A);
    }

    private static void teleportEntity(Entity entity, ServerWorld world, double x, double y, double z, float yaw, float pitch) {
        if (entity instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)entity;
            ChunkPos chunkpos = new ChunkPos(new BlockPos(x, y, z));
            world.func_72863_F().func_217228_a(TicketType.field_223185_g, chunkpos, 1, (Object)entity.func_145782_y());
            if (world == entity.field_70170_p) {
                player.field_71135_a.func_147364_a(x, y, z, yaw, pitch);
            } else {
                player.func_200619_a(world, x, y, z, yaw, pitch);
            }
            entity.func_70034_d(yaw);
        } else {
            float wrapedYaw = MathHelper.func_76142_g((float)yaw);
            float wrapedPitch = MathHelper.func_76131_a((float)MathHelper.func_76142_g((float)pitch), (float)-90.0f, (float)90.0f);
            if (world == entity.field_70170_p) {
                entity.func_70012_b(x, y, z, wrapedYaw, wrapedPitch);
                entity.func_70034_d(wrapedYaw);
            } else {
                entity.field_71093_bK = world.field_73011_w.func_186058_p();
                Entity entityCopy = entity;
                if ((entity = entity.func_200600_R().func_200721_a((World)world)) == null) {
                    return;
                }
                entity.func_180432_n(entityCopy);
                entityCopy.remove(false);
                entity.func_70012_b(x, y, z, wrapedYaw, wrapedPitch);
                entity.func_70034_d(wrapedYaw);
                world.func_217460_e(entity);
            }
        }
    }

    public void writeNBT(CompoundNBT compound) {
        compound.func_218657_a("location", (INBT)this.location.serializeNBT());
        if (this.fuel != 0) {
            compound.func_74768_a("fuel", this.fuel);
        }
    }

    public void readNBT(CompoundNBT compound) {
        this.location.deserializeNBT(compound.func_74775_l("location"));
        this.fuel = compound.func_74762_e("fuel");
    }

    public void sendInitialDataBuffer(PacketBuffer buffer) {
        this.checkCost();
        this.location.serialize(buffer);
        buffer.writeInt(this.fuel);
        buffer.writeInt(this.cost);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handleInitialDataBuffer(PacketBuffer buffer) {
        this.location.deserialize(buffer);
        this.fuel = buffer.readInt();
        this.cost = buffer.readInt();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction direction) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && direction != Direction.UP) {
            return this.slot.cast();
        }
        return super.getCapability(capability, direction);
    }

    public Container createMenu(int id, PlayerInventory playerInventory, PlayerEntity player) {
        return new TeleportRailContainer(id, playerInventory, this);
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("container.usefulrailroads.teleport_rail", new Object[0]);
    }

    public int getFuel() {
        return this.fuel;
    }

    public void setFuel(int fuel) {
        this.fuel = fuel;
    }

    public Location getLocation() {
        return this.location;
    }

    public int getCost() {
        return this.cost;
    }
}

