/*
 * Decompiled with CFR 0.152.
 */
package subaraki.paintings.packet.server;

import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.HangingEntity;
import net.minecraft.entity.item.PaintingEntity;
import net.minecraft.entity.item.PaintingType;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;
import subaraki.paintings.mod.Paintings;
import subaraki.paintings.packet.IPacketBase;
import subaraki.paintings.packet.NetworkHandler;
import subaraki.paintings.packet.client.CPacketPainting;

public class SPacketPainting
implements IPacketBase {
    private PaintingType type;
    private int entityID;

    public SPacketPainting() {
    }

    public SPacketPainting(PaintingType type, int entityID) {
        this.type = type;
        this.entityID = entityID;
    }

    public SPacketPainting(PacketBuffer buff) {
        this.decode(buff);
    }

    @Override
    public void encode(PacketBuffer buf) {
        buf.func_180714_a(this.type.getRegistryName().toString());
        buf.writeInt(this.entityID);
    }

    @Override
    public void decode(PacketBuffer buf) {
        String name = buf.func_150789_c(256);
        this.type = (PaintingType)ForgeRegistries.PAINTING_TYPES.getValue(new ResourceLocation(name));
        this.entityID = buf.readInt();
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            World world = ((NetworkEvent.Context)context.get()).getSender().field_70170_p;
            Entity entity = world.func_73045_a(this.entityID);
            if (entity instanceof PaintingEntity) {
                PaintingEntity painting = (PaintingEntity)entity;
                Paintings.utility.setArt(painting, this.type);
                Paintings.utility.updatePaintingBoundingBox((HangingEntity)painting);
                ServerPlayerEntity playerMP = ((NetworkEvent.Context)context.get()).getSender();
                NetworkHandler.NETWORK.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> playerMP), (Object)new CPacketPainting(painting, new ResourceLocation[]{this.type.getRegistryName()}));
            }
        });
        context.get().setPacketHandled(true);
    }

    @Override
    public void encrypt(int id) {
        NetworkHandler.NETWORK.registerMessage(id, SPacketPainting.class, SPacketPainting::encode, SPacketPainting::new, SPacketPainting::handle);
    }
}

