/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.weapon_craftery.event;

import com.stal111.weapon_craftery.item.ItemLevel;
import com.stal111.weapon_craftery.item.ItemRarity;
import com.stal111.weapon_craftery.util.ModUtils;
import java.util.UUID;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SwordItem;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class PlayerTickListener {
    @SubscribeEvent
    public static void onItemCrafted(TickEvent.PlayerTickEvent event) {
        NonNullList list = event.player.field_71071_by.field_70462_a;
        for (ItemStack stack : list) {
            if (!(stack.func_77973_b() instanceof SwordItem) || stack.func_77942_o() && ItemRarity.getRarity(stack) != ItemRarity.Rarity.UNKNOWN) continue;
            System.out.println(stack.func_77973_b().getRegistryName());
            float attackDamage = ((SwordItem)stack.func_77973_b()).field_150934_a;
            float attackSpeed = ((SwordItem)stack.func_77973_b()).field_200895_b;
            stack.func_185129_a(SharedMonsterAttributes.field_111264_e.func_111108_a(), new AttributeModifier(UUID.fromString("CB3F55D3-645C-4F38-A497-9C13A33DB5CF"), "Weapon modifier", (double)attackDamage, AttributeModifier.Operation.ADDITION), EquipmentSlotType.MAINHAND);
            stack.func_185129_a(SharedMonsterAttributes.field_188790_f.func_111108_a(), new AttributeModifier(UUID.fromString("FA233E1C-4180-4865-B01B-BCCE9785ACA3"), "Weapon modifier", (double)attackSpeed, AttributeModifier.Operation.ADDITION), EquipmentSlotType.MAINHAND);
            if (ItemRarity.getRarity(stack) == ItemRarity.Rarity.UNKNOWN) {
                ModUtils.setTag("rarity", String.valueOf((Object)ItemRarity.getRandomRarity()), stack);
                ModUtils.setTag("damageBonus", ItemRarity.getRarityDurabilityBonus(stack), stack);
            } else {
                ModUtils.setTag("level", 2, stack);
                ModUtils.setTag("xp", 0, stack);
                ModUtils.setTag("rarity", String.valueOf((Object)ItemRarity.getRandomRarity()), stack);
                ModUtils.setTag("kills", 0, stack);
                ModUtils.setTag("damageBonus", ItemRarity.getRarityDurabilityBonus(stack), stack);
            }
            stack.func_77973_b().func_185043_a(new ResourceLocation("level"), (stack1, world, livingEntity) -> {
                if (livingEntity == null) {
                    return 0.0f;
                }
                return (float)ItemLevel.getLevel(stack1) / 10.0f;
            });
        }
    }

    @SubscribeEvent
    public static void onItemCrafted(LivingAttackEvent event) {
        PlayerEntity player;
        ItemStack stack;
        LivingEntity entity = event.getEntityLiving();
        if (event.getSource().field_76373_n.equals("player") && (stack = (player = (PlayerEntity)event.getSource().func_76346_g()).func_184614_ca()).func_77973_b() instanceof SwordItem) {
            int i = stack.func_77978_p().func_74762_e("damageBonus");
            System.out.println(i);
            if (i != 0) {
                stack.func_196085_b(0);
                ModUtils.setTag("damageBonus", i - 1, stack);
            }
        }
    }
}

