/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.weapon_craftery.event;

import com.stal111.weapon_craftery.item.ItemLevel;
import com.stal111.weapon_craftery.item.ItemRarity;
import com.stal111.weapon_craftery.util.ModUtils;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SwordItem;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class ToolTipListener {
    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onItemCrafted(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        if (stack.func_77973_b() instanceof SwordItem) {
            List tooltip = event.getToolTip();
            tooltip.clear();
            tooltip.add(new StringTextComponent("").func_150257_a(stack.func_200301_q()).func_211708_a(stack.func_77953_t().field_77937_e).func_150258_a(" ").func_150257_a(new TranslationTextComponent("rarity.weapon_craftery." + ItemRarity.getRarity(stack).toString(), new Object[0]).func_211708_a(ItemRarity.getRarityColor(ItemRarity.getRarity(stack)))));
            if (!ItemLevel.isMaxLevel(stack)) {
                tooltip.add(ModUtils.createTextComponent("level", ItemRarity.getRarityColor(ItemRarity.getRarity(stack))).func_150258_a("\u00a77: " + ItemLevel.getLevel(stack)));
                tooltip.add(ModUtils.createTextComponent("xp", TextFormatting.GRAY).func_150258_a(": " + ItemLevel.getXP(stack) + "/" + ItemLevel.getNeededXP(stack)));
            } else {
                tooltip.add(ModUtils.createTextComponent("level", ItemRarity.getRarityColor(ItemRarity.getRarity(stack))).func_150258_a("\u00a77: " + ItemLevel.getLevel(stack) + " \u00a72(MAX)"));
            }
            tooltip.add(new StringTextComponent(""));
            if (ItemRarity.getRarity(stack) != ItemRarity.Rarity.COMMON && ItemRarity.getRarity(stack) != ItemRarity.Rarity.UNKNOWN) {
                tooltip.add(ModUtils.createTextComponent("enchantability", TextFormatting.GRAY).func_150258_a(": " + ((SwordItem)stack.func_77973_b()).func_200891_e().func_200927_e()).func_150258_a(" + \u00a7" + ModUtils.getTextFormattingAsChar(ItemRarity.getRarityColor(ItemRarity.getRarity(stack))) + ItemRarity.getRarityEnchantabilityBonus(stack)));
                tooltip.add(ModUtils.createTextComponent("durability", TextFormatting.GRAY).func_150258_a(": " + (stack.func_77973_b().getMaxDamage(stack) - stack.func_77973_b().getDamage(stack) + stack.func_77978_p().func_74762_e("damageBonus")) + "/" + ((SwordItem)stack.func_77973_b()).func_200891_e().func_200926_a()).func_150258_a(" + \u00a7" + ModUtils.getTextFormattingAsChar(ItemRarity.getRarityColor(ItemRarity.getRarity(stack))) + ItemRarity.getRarityDurabilityBonus(stack)));
            } else {
                tooltip.add(ModUtils.createTextComponent("enchantability", TextFormatting.GRAY).func_150258_a("\u00a77: " + ((SwordItem)stack.func_77973_b()).func_200891_e().func_200927_e()));
                tooltip.add(ModUtils.createTextComponent("durability", TextFormatting.GRAY).func_150258_a(": " + (stack.func_77973_b().getMaxDamage(stack) - stack.func_77973_b().getDamage(stack)) + "/" + ((SwordItem)stack.func_77973_b()).func_200891_e().func_200926_a()));
            }
            tooltip.add(new StringTextComponent(""));
            if (!ModUtils.isShiftDown()) {
                tooltip.add(ModUtils.createTextComponent("shift", TextFormatting.GRAY));
            } else {
                tooltip.add(ModUtils.createTextComponent("kills", TextFormatting.GRAY).func_150258_a(": " + ModUtils.getKills(stack)));
            }
            tooltip.add(new StringTextComponent(""));
            if (!stack.func_77986_q().isEmpty()) {
                ItemStack.func_222120_a((List)event.getToolTip(), (ListNBT)stack.func_77986_q());
                tooltip.add(new StringTextComponent(""));
            }
            tooltip.add(ModUtils.createTextComponent("attackDamage", TextFormatting.DARK_GREEN).func_150258_a("\u00a77: " + (ModUtils.calculateAttackDamage(stack) + 1.0f)));
            float value = ModUtils.calculateAttackSpeed(stack) + 4.0f + 1.0E-7f;
            tooltip.add(ModUtils.createTextComponent("attackSpeed", TextFormatting.DARK_GREEN).func_150258_a("\u00a77: " + (double)Math.round(100.0 * (double)value) / 100.0));
        }
    }
}

