/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.weapon_craftery.item;

import com.stal111.weapon_craftery.item.ItemMaterial;
import com.stal111.weapon_craftery.util.ModUtils;
import net.minecraft.item.ItemStack;

public class ItemLevel {
    public static int getLevel(ItemStack stack) {
        return ModUtils.getTag("level", stack) != null ? (Integer)ModUtils.getTag("level", stack) : 1;
    }

    public static void setLevel(ItemStack stack, int level) {
        ModUtils.setTag("level", level, stack);
    }

    public static int getMaxLevel(ItemStack stack) {
        return ItemMaterial.getMaterialAsString(stack) == "DIAMOND" ? 6 : 3;
    }

    public static boolean isMaxLevel(ItemStack stack) {
        return ItemLevel.getLevel(stack) == ItemLevel.getMaxLevel(stack);
    }

    public static void levelUp(ItemStack stack) {
        ModUtils.setTag("level", ItemLevel.getLevel(stack) + 1, stack);
    }

    public static void checkForLevelUp(ItemStack stack) {
        int neededXP = ItemLevel.getNeededXP(stack);
        if (ItemLevel.getXP(stack) >= neededXP) {
            ItemLevel.removeXP(stack, neededXP);
            ItemLevel.levelUp(stack);
        }
    }

    public static float getLevelDamageBonus(ItemStack stack) {
        return 0.5f * (float)ItemLevel.getLevel(stack) - 0.5f;
    }

    public static float getLevelSpeedBonus(ItemStack stack) {
        if (ItemLevel.getLevel(stack) != 1) {
            return 0.05f * (float)ItemLevel.getLevel(stack) - 0.05f;
        }
        return 0.0f;
    }

    public static int getXP(ItemStack stack) {
        return ModUtils.getTag("xp", stack) != null ? (Integer)ModUtils.getTag("xp", stack) : 0;
    }

    public static void setXP(ItemStack stack, int amount) {
        ModUtils.setTag("xp", amount, stack);
    }

    public static void addXP(ItemStack stack, int amount) {
        ModUtils.setTag("xp", ItemLevel.getXP(stack) + amount, stack);
        ItemLevel.checkForLevelUp(stack);
    }

    public static void removeXP(ItemStack stack, int amount) {
        if (ItemLevel.getXP(stack) - amount < 0) {
            ModUtils.setTag("xp", 0, stack);
        } else {
            ModUtils.setTag("xp", ItemLevel.getXP(stack) - amount, stack);
        }
    }

    public static int getNeededXP(ItemStack stack) {
        int i;
        switch (ItemMaterial.getMaterialAsString(stack)) {
            case "IRON": {
                i = 16;
                break;
            }
            case "DIAMOND": {
                i = 30;
                break;
            }
            default: {
                i = 5;
            }
        }
        return ItemMaterial.getMaterialAsString(stack) == "WOOD" || ItemMaterial.getMaterialAsString(stack) == "GOLD" ? i : (i *= ItemLevel.getLevel(stack)) * ItemMaterial.getMaterialXPModifier(stack) + 10 * ItemLevel.getLevel(stack);
    }
}

