/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.weapon_craftery.item;

import com.stal111.weapon_craftery.item.ItemMaterial;
import com.stal111.weapon_craftery.util.ModUtils;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;

public class ItemRarity {
    public static Rarity getRarity(ItemStack stack) {
        return ModUtils.getTag("rarity", stack) != null ? Rarity.valueOf(((String)ModUtils.getTag("rarity", stack)).toUpperCase()) : Rarity.UNKNOWN;
    }

    public static void setRarity(ItemStack stack, Rarity rarity) {
        ModUtils.setTag("rarity", rarity.name().toLowerCase(), stack);
    }

    public static TextFormatting getRarityColor(Rarity rarity) {
        return rarity.color;
    }

    public static Rarity getRandomRarity() {
        int i = new Random().nextInt(16) + 1;
        if (i <= 6) {
            return Rarity.COMMON;
        }
        if (i == 7 || i == 8 || i == 9 || i == 10) {
            return Rarity.UNCOMMON;
        }
        if (i == 11 || i == 12 || i == 13) {
            return Rarity.RARE;
        }
        if (i == 14 || i == 15) {
            return Rarity.EPIC;
        }
        return Rarity.LEGENDARY;
    }

    public static int getRarityEnchantabilityBonus(ItemStack stack) {
        return ItemRarity.getRarityEnchantabilityBonus(ItemRarity.getRarity(stack));
    }

    public static int getRarityEnchantabilityBonus(Rarity rarity) {
        switch (rarity) {
            case UNCOMMON: {
                return 2;
            }
            case RARE: {
                return 5;
            }
            case EPIC: {
                return 8;
            }
            case LEGENDARY: {
                return 12;
            }
        }
        return 0;
    }

    public static int getRarityDurabilityBonus(ItemStack stack) {
        int i;
        switch (ItemRarity.getRarity(stack)) {
            case UNCOMMON: {
                i = 7;
                break;
            }
            case RARE: {
                i = 13;
                break;
            }
            case EPIC: {
                i = 19;
                break;
            }
            case LEGENDARY: {
                i = 27;
                break;
            }
            default: {
                i = 0;
            }
        }
        return i * ItemMaterial.getMaterialDurabilityModifier(stack);
    }

    public static enum Rarity {
        COMMON(TextFormatting.WHITE),
        UNCOMMON(TextFormatting.YELLOW),
        RARE(TextFormatting.AQUA),
        EPIC(TextFormatting.LIGHT_PURPLE),
        LEGENDARY(TextFormatting.GOLD),
        UNKNOWN(TextFormatting.WHITE);

        public final TextFormatting color;

        private Rarity(TextFormatting textFormatting) {
            this.color = textFormatting;
        }

        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

