/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.weapon_craftery.item;

import com.google.common.collect.Multimap;
import com.stal111.weapon_craftery.item.ItemLevel;
import com.stal111.weapon_craftery.item.ItemRarity;
import com.stal111.weapon_craftery.util.ModUtils;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.WebBlock;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.TieredItem;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ModSwordItem
extends TieredItem {
    private final IItemTier tier;
    private final float attackSpeed;
    private final float attackDamage;

    public ModSwordItem(IItemTier tier, float attackDamage, float attackSpeed, Item.Properties properties) {
        super(tier, properties.func_200917_a(1));
        this.func_185043_a(new ResourceLocation("level"), (stack, world, livingEntity) -> {
            if (livingEntity == null) {
                return 0.0f;
            }
            return (float)ItemLevel.getLevel(stack) / 10.0f;
        });
        this.tier = tier;
        this.attackSpeed = attackSpeed;
        this.attackDamage = attackDamage + tier.func_200929_c();
    }

    public IItemTier func_200891_e() {
        return this.tier;
    }

    public int getMaxDamage(ItemStack stack) {
        return stack.func_77942_o() ? this.tier.func_200926_a() + ItemRarity.getRarityDurabilityBonus(stack) : 0;
    }

    public int getItemEnchantability(ItemStack stack) {
        return this.tier.func_200927_e() + ItemRarity.getRarityEnchantabilityBonus(stack);
    }

    public float getAttackSpeed(ItemStack stack) {
        return this.attackSpeed + ItemLevel.getLevelSpeedBonus(stack);
    }

    public float getAttackDamage(ItemStack stack) {
        return this.attackDamage + ItemLevel.getLevelDamageBonus(stack);
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        if (stack.func_77978_p() != null) {
            return new TranslationTextComponent(this.func_200296_o().getString() + " ", new Object[0]).func_150257_a(new TranslationTextComponent("rarity.weapon_craftery." + ItemRarity.getRarity(stack).toString(), new Object[0]).func_211708_a(ItemRarity.getRarityColor(ItemRarity.getRarity(stack))));
        }
        return super.func_200295_i(stack);
    }

    public boolean func_82789_a(ItemStack p_82789_1_, ItemStack p_82789_2_) {
        return this.tier.func_200924_f().test(p_82789_2_) || super.func_82789_a(p_82789_1_, p_82789_2_);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (stack.func_77978_p() == null) {
            this.createTag(stack, ItemRarity.getRandomRarity().name().toLowerCase());
        } else if (ItemRarity.getRarity(stack) == ItemRarity.Rarity.UNKNOWN) {
            this.createTag(stack, ItemLevel.getLevel(stack), ItemRarity.getRandomRarity().toString());
        }
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            for (int i = 1; i <= ItemLevel.getMaxLevel(new ItemStack((IItemProvider)this)); ++i) {
                ItemStack stack = new ItemStack((IItemProvider)this);
                this.createTag(stack, ItemRarity.Rarity.UNKNOWN.toString());
                stack.func_77978_p().func_74768_a("level", i);
                items.add((Object)stack);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (stack.func_77978_p() != null) {
            if (!ItemLevel.isMaxLevel(stack)) {
                tooltip.add(ModUtils.createTextComponent("level", ItemRarity.getRarityColor(ItemRarity.getRarity(stack))).func_150258_a("\u00a77: " + ItemLevel.getLevel(stack)));
                tooltip.add(ModUtils.createTextComponent("xp", TextFormatting.GRAY).func_150258_a(": " + ItemLevel.getXP(stack) + "/" + ItemLevel.getNeededXP(stack)));
            } else {
                tooltip.add(ModUtils.createTextComponent("level", ItemRarity.getRarityColor(ItemRarity.getRarity(stack))).func_150258_a("\u00a77: " + ItemLevel.getLevel(stack) + " \u00a72(MAX)"));
            }
            tooltip.add((ITextComponent)new StringTextComponent(""));
            if (ItemRarity.getRarity(stack) != ItemRarity.Rarity.COMMON && ItemRarity.getRarity(stack) != ItemRarity.Rarity.UNKNOWN) {
                tooltip.add(ModUtils.createTextComponent("enchantability", TextFormatting.GRAY).func_150258_a(": " + this.tier.func_200927_e()).func_150258_a(" + \u00a7" + ModUtils.getTextFormattingAsChar(ItemRarity.getRarityColor(ItemRarity.getRarity(stack))) + ItemRarity.getRarityEnchantabilityBonus(stack)));
                tooltip.add(ModUtils.createTextComponent("durability", TextFormatting.GRAY).func_150258_a(": " + (this.getMaxDamage(stack) - this.getDamage(stack)) + "/" + this.tier.func_200926_a()).func_150258_a(" + \u00a7" + ModUtils.getTextFormattingAsChar(ItemRarity.getRarityColor(ItemRarity.getRarity(stack))) + ItemRarity.getRarityDurabilityBonus(stack)));
            } else {
                tooltip.add(ModUtils.createTextComponent("enchantability", TextFormatting.GRAY).func_150258_a("\u00a77: " + this.tier.func_200927_e()));
                tooltip.add(ModUtils.createTextComponent("durability", TextFormatting.GRAY).func_150258_a(": " + (this.getMaxDamage(stack) - this.getDamage(stack)) + "/" + this.tier.func_200926_a()));
            }
            tooltip.add((ITextComponent)new StringTextComponent(""));
            if (!ModUtils.isShiftDown()) {
                tooltip.add(ModUtils.createTextComponent("shift", TextFormatting.GRAY));
            } else {
                tooltip.add(ModUtils.createTextComponent("kills", TextFormatting.GRAY).func_150258_a(": " + ModUtils.getKills(stack)));
            }
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public boolean func_195938_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player) {
        return !player.func_184812_l_();
    }

    public float func_150893_a(ItemStack stack, BlockState state) {
        Block lvt_3_1_ = state.func_177230_c();
        if (lvt_3_1_ instanceof WebBlock) {
            return 15.0f;
        }
        Material lvt_4_1_ = state.func_185904_a();
        if (lvt_4_1_ == Material.field_151585_k || lvt_4_1_ == Material.field_151582_l || lvt_4_1_ == Material.field_151589_v || state.func_203425_a(BlockTags.field_206952_E) || lvt_4_1_ == Material.field_151572_C) {
            return 1.5f;
        }
        return 1.0f;
    }

    public boolean func_179218_a(ItemStack stack, World world, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if (state.func_185887_b((IBlockReader)world, pos) != 0.0f) {
            stack.func_222118_a(2, entityLiving, p_220044_0_ -> p_220044_0_.func_213361_c(EquipmentSlotType.MAINHAND));
        }
        return true;
    }

    public boolean func_150897_b(BlockState block) {
        return block.func_177230_c() instanceof WebBlock;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        System.out.println(stack.func_77978_p());
        return super.func_77659_a(world, player, hand);
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (target.func_110143_aJ() <= 0.0f) {
            if (!ItemLevel.isMaxLevel(stack)) {
                if (target instanceof MonsterEntity) {
                    if (ItemLevel.getXP(stack) == ItemLevel.getNeededXP(stack) - 1) {
                        ItemLevel.addXP(stack, 1);
                    } else {
                        ItemLevel.addXP(stack, 2);
                    }
                } else {
                    ItemLevel.addXP(stack, 1);
                }
            }
            ModUtils.addKill(stack);
        }
        stack.func_222118_a(1, attacker, p_220045_0_ -> p_220045_0_.func_213361_c(EquipmentSlotType.MAINHAND));
        return true;
    }

    private ItemStack createTag(ItemStack stack, String rarity) {
        return this.createTag(stack, 1, rarity);
    }

    private ItemStack createTag(ItemStack stack, int level, String rarity) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("rarity", rarity);
        map.put("level", level);
        map.put("xp", 0);
        map.put("kills", 0);
        return ModUtils.setTag(map, stack);
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        Multimap multimap = super.func_111205_h(slot);
        if (slot == EquipmentSlotType.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)this.getAttackDamage(stack), AttributeModifier.Operation.ADDITION));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", (double)this.getAttackSpeed(stack), AttributeModifier.Operation.ADDITION));
        }
        return multimap;
    }
}

