/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.weapon_craftery.util;

import com.stal111.weapon_craftery.item.ItemLevel;
import com.stal111.weapon_craftery.item.ItemRarity;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.util.InputMappings;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SwordItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import org.lwjgl.glfw.GLFW;

public class ModUtils {
    public static ResourceLocation location(String path) {
        return new ResourceLocation("weapon_craftery", path);
    }

    public static ITextComponent createTextComponent(String translationKey, TextFormatting textFormatting) {
        return new TranslationTextComponent("tooltip.weapon_craftery." + translationKey, new Object[0]).func_211708_a(textFormatting);
    }

    public static boolean isShiftDown() {
        return InputMappings.func_216506_a((long)GLFW.glfwGetCurrentContext(), (int)340) || InputMappings.func_216506_a((long)GLFW.glfwGetCurrentContext(), (int)344);
    }

    public static <T extends ItemStack> T setTag(String key, Object value, T stack) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(key, value);
        return ModUtils.setTag(map, stack);
    }

    public static <T extends ItemStack> T setTag(Map<String, Object> map, T stack) {
        CompoundNBT compoundNBT = stack.func_77978_p() == null ? new CompoundNBT() : stack.func_77978_p();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String string = entry.getKey();
            if (string == null) continue;
            Object o = entry.getValue();
            if (o instanceof String) {
                compoundNBT.func_74778_a(string, (String)o);
                continue;
            }
            if (!(o instanceof Integer)) continue;
            compoundNBT.func_74768_a(string, ((Integer)o).intValue());
        }
        stack.func_77982_d(compoundNBT);
        return stack;
    }

    public static Object getTag(String key, ItemStack stack) {
        if (stack.func_77978_p() != null && key != null) {
            INBT inbt = stack.func_77978_p().func_74781_a(key);
            if (inbt instanceof StringNBT) {
                return stack.func_77978_p().func_74779_i(key);
            }
            if (inbt instanceof IntNBT) {
                return stack.func_77978_p().func_74762_e(key);
            }
            return null;
        }
        return null;
    }

    public static ListNBT getAttributeModifierTagList(ItemStack stack) {
        return stack.func_77978_p() != null ? stack.func_77978_p().func_150295_c("AttributeModifiers", 10) : new ListNBT();
    }

    public static char getTextFormattingAsChar(TextFormatting textFormatting) {
        return textFormatting.field_96329_z;
    }

    public static ITextComponent createDisplayName(ItemStack stack) {
        return new TranslationTextComponent(stack.func_77973_b().func_200296_o().getString() + " ", new Object[0]).func_150257_a(new TranslationTextComponent("rarity.weapon_craftery." + ItemRarity.getRarity(stack).toString(), new Object[0]).func_211708_a(ItemRarity.getRarityColor(ItemRarity.getRarity(stack))));
    }

    public static float calculateAttackDamage(ItemStack stack) {
        if (stack.func_77973_b() instanceof SwordItem) {
            return ((SwordItem)stack.func_77973_b()).field_150934_a + ItemLevel.getLevelDamageBonus(stack);
        }
        return 0.0f;
    }

    public static float calculateAttackSpeed(ItemStack stack) {
        if (stack.func_77973_b() instanceof SwordItem) {
            return ((SwordItem)stack.func_77973_b()).field_200895_b + (ItemLevel.getLevelSpeedBonus(stack) - 1.0E-7f);
        }
        return 0.0f;
    }

    public static int getKills(ItemStack stack) {
        return ModUtils.getTag("kills", stack) != null ? (Integer)ModUtils.getTag("kills", stack) : 0;
    }

    public static void addKill(ItemStack stack) {
        ModUtils.setTag("kills", ModUtils.getKills(stack) + 1, stack);
    }
}

