/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.api.sync;

import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import java.util.function.LongConsumer;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;

public abstract class BufferReferenceHolder {
    private PacketBuffer lastKnownValue;

    public abstract PacketBuffer get();

    public abstract void set(PacketBuffer var1);

    public boolean isDirty() {
        PacketBuffer buffer = this.get();
        boolean dirty = !buffer.equals((Object)this.lastKnownValue);
        this.lastKnownValue = buffer;
        return dirty;
    }

    public static final BufferReferenceHolder createHolder(final Supplier<PacketBuffer> get, final Consumer<PacketBuffer> set) {
        return new BufferReferenceHolder(){

            @Override
            public PacketBuffer get() {
                return (PacketBuffer)get.get();
            }

            @Override
            public void set(PacketBuffer buffer) {
                set.accept(buffer);
            }
        };
    }

    public static final BufferReferenceHolder createIntHolder(final IntSupplier get, final IntConsumer set) {
        return new BufferReferenceHolder(){

            @Override
            public PacketBuffer get() {
                return new PacketBuffer(Unpooled.copyInt((int)get.getAsInt()));
            }

            @Override
            public void set(PacketBuffer buffer) {
                set.accept(buffer.readInt());
            }
        };
    }

    public static final BufferReferenceHolder createByteHolder(final Supplier<Byte> get, final Consumer<Byte> set) {
        return new BufferReferenceHolder(){

            @Override
            public PacketBuffer get() {
                return new PacketBuffer(Unpooled.buffer((int)1).writeByte((int)((Byte)get.get()).byteValue()));
            }

            @Override
            public void set(PacketBuffer buffer) {
                set.accept(buffer.readByte());
            }
        };
    }

    public static final BufferReferenceHolder createShortHolder(final Supplier<Short> get, final Consumer<Short> set) {
        return new BufferReferenceHolder(){

            @Override
            public PacketBuffer get() {
                return new PacketBuffer(Unpooled.copyShort((int)((Short)get.get()).shortValue()));
            }

            @Override
            public void set(PacketBuffer buffer) {
                set.accept(buffer.readShort());
            }
        };
    }

    public static final BufferReferenceHolder createLongHolder(final LongSupplier get, final LongConsumer set) {
        return new BufferReferenceHolder(){

            @Override
            public PacketBuffer get() {
                return new PacketBuffer(Unpooled.copyLong((long)get.getAsLong()));
            }

            @Override
            public void set(PacketBuffer buffer) {
                set.accept(buffer.readLong());
            }
        };
    }

    public static final BufferReferenceHolder createBooleanHolder(final BooleanSupplier get, final BooleanConsumer set) {
        return new BufferReferenceHolder(){

            @Override
            public PacketBuffer get() {
                return new PacketBuffer(Unpooled.copyBoolean((boolean)get.getAsBoolean()));
            }

            @Override
            public void set(PacketBuffer buffer) {
                set.accept(buffer.readBoolean());
            }
        };
    }
}

