/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.container;

import info.u_team.u_team_core.api.sync.IAutoSyncedTileEntity;
import info.u_team.u_team_core.api.sync.ISyncedTileEntity;
import info.u_team.u_team_core.container.USyncedContainer;
import io.netty.buffer.Unpooled;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@Deprecated
public abstract class USyncedTileEntityContainer<T extends TileEntity>
extends USyncedContainer {
    protected final PlayerInventory playerInventory;
    protected final T tileEntity;
    private PacketBuffer lastBuffer;

    public USyncedTileEntityContainer(ContainerType<?> type, int id, PlayerInventory playerInventory, T tileEntity) {
        this(type, id, playerInventory, tileEntity, true);
    }

    public USyncedTileEntityContainer(ContainerType<?> type, int id, PlayerInventory playerInventory, T tileEntity, boolean init) {
        super(type, id);
        this.playerInventory = playerInventory;
        this.tileEntity = tileEntity;
        if (init) {
            this.init(true);
        }
    }

    public USyncedTileEntityContainer(ContainerType<?> type, int id, PlayerInventory playerInventory, PacketBuffer buffer) {
        this(type, id, playerInventory, buffer, true);
    }

    public USyncedTileEntityContainer(ContainerType<?> type, int id, PlayerInventory playerInventory, PacketBuffer buffer, boolean init) {
        super(type, id, buffer);
        this.playerInventory = playerInventory;
        this.tileEntity = this.getClientTileEntity(buffer);
        ((ISyncedTileEntity)this.tileEntity).handleInitialDataBuffer(new PacketBuffer(Unpooled.wrappedBuffer((byte[])buffer.func_189425_b(32592))));
        if (init) {
            this.init(false);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private T getClientTileEntity(PacketBuffer buffer) {
        TileEntity tile = Minecraft.func_71410_x().field_71441_e.func_175625_s(buffer.func_179259_c());
        if (tile == null || !(tile instanceof ISyncedTileEntity)) {
            throw new IllegalStateException("The client tile entity must be present.");
        }
        return (T)tile;
    }

    protected abstract void init(boolean var1);

    protected IInventory getInventoryOnDist(boolean server, IInventory inventory) {
        return server ? inventory : new Inventory(inventory.func_70302_i_());
    }

    public T getTileEntity() {
        return this.tileEntity;
    }

    public void func_75132_a(IContainerListener listener) {
        super.func_75132_a(listener);
        if (this.tileEntity instanceof IAutoSyncedTileEntity && listener instanceof ServerPlayerEntity) {
            if (this.lastBuffer == null) {
                this.lastBuffer = new PacketBuffer(Unpooled.buffer());
                this.sendToClient(this.lastBuffer);
            }
            this.sendDataToClient((ServerPlayerEntity)listener, new PacketBuffer(this.lastBuffer.copy()));
        }
    }

    @Override
    public void func_75142_b() {
        super.func_75142_b();
        if (this.tileEntity instanceof IAutoSyncedTileEntity) {
            PacketBuffer buffer = new PacketBuffer(Unpooled.buffer());
            this.sendToClient(buffer);
            if (buffer.equals((Object)this.lastBuffer)) {
                return;
            }
            this.lastBuffer = buffer;
            this.field_75149_d.stream().filter(listener -> listener instanceof ServerPlayerEntity).map(listener -> (ServerPlayerEntity)listener).forEach(player -> this.sendDataToClient((ServerPlayerEntity)player, new PacketBuffer(this.lastBuffer.copy())));
        }
    }

    @Override
    public void sendToClient(PacketBuffer buffer) {
        ((ISyncedTileEntity)this.tileEntity).sendToClient(buffer);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void handleFromServer(PacketBuffer buffer) {
        ((ISyncedTileEntity)this.tileEntity).handleFromServer(buffer);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void sendToServer(PacketBuffer buffer) {
        ((ISyncedTileEntity)this.tileEntity).sendToServer(buffer);
    }

    @Override
    public void handleFromClient(PacketBuffer buffer) {
        ((ISyncedTileEntity)this.tileEntity).handleFromClient(buffer);
    }
}

