/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.container;

import info.u_team.u_team_core.api.sync.IInitSyncedTileEntity;
import info.u_team.u_team_core.container.UContainer;
import io.netty.buffer.Unpooled;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class UTileEntityContainer<T extends TileEntity>
extends UContainer {
    protected final PlayerInventory playerInventory;
    protected final T tileEntity;

    public UTileEntityContainer(ContainerType<?> type, int id, PlayerInventory playerInventory, T tileEntity) {
        this(type, id, playerInventory, tileEntity, true);
    }

    public UTileEntityContainer(ContainerType<?> type, int id, PlayerInventory playerInventory, T tileEntity, boolean init) {
        super(type, id);
        this.playerInventory = playerInventory;
        this.tileEntity = tileEntity;
        if (init) {
            this.init(true);
        }
    }

    public UTileEntityContainer(ContainerType<?> type, int id, PlayerInventory playerInventory, PacketBuffer buffer) {
        this(type, id, playerInventory, buffer, true);
    }

    public UTileEntityContainer(ContainerType<?> type, int id, PlayerInventory playerInventory, PacketBuffer buffer, boolean init) {
        super(type, id);
        this.playerInventory = playerInventory;
        this.tileEntity = this.getClientTileEntity(buffer);
        if (this.tileEntity instanceof IInitSyncedTileEntity) {
            ((IInitSyncedTileEntity)this.tileEntity).handleInitialDataBuffer(new PacketBuffer(Unpooled.wrappedBuffer((byte[])buffer.func_189425_b(32592))));
        }
        if (init) {
            this.init(false);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private T getClientTileEntity(PacketBuffer buffer) {
        TileEntity tile = Minecraft.func_71410_x().field_71441_e.func_175625_s(buffer.func_179259_c());
        if (tile == null) {
            throw new IllegalStateException("The client tile entity must be present.");
        }
        return (T)tile;
    }

    protected abstract void init(boolean var1);

    @Deprecated
    protected IInventory getInventoryOnDist(boolean server, IInventory inventory) {
        return server ? inventory : new Inventory(inventory.func_70302_i_());
    }

    public T getTileEntity() {
        return this.tileEntity;
    }
}

