/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.intern.discord;

import info.u_team.u_team_core.UCoreMain;
import info.u_team.u_team_core.repack.com.jagrosh.discordipc.IPCClient;
import info.u_team.u_team_core.repack.com.jagrosh.discordipc.entities.DiscordBuild;
import info.u_team.u_team_core.repack.com.jagrosh.discordipc.entities.RichPresence;
import info.u_team.u_team_core.repack.com.jagrosh.discordipc.exceptions.NoDiscordClientException;
import java.time.OffsetDateTime;
import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.world.dimension.Dimension;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.versions.mcp.MCPVersion;

@OnlyIn(value=Dist.CLIENT)
public class DiscordRichPresence {
    private static final IPCClient CLIENT = new IPCClient(427196986064764928L);
    private static boolean isEnabled = false;
    private static final OffsetDateTime TIME = OffsetDateTime.now();
    public static State currentState = new State(EnumState.STARTUP);
    private static int errorCount = 0;
    private static final Timer TIMER = new Timer("Discord Rich Presence Timer Thread");
    private static TimerTask timerTask;

    public static void start() {
        try {
            CLIENT.connect(new DiscordBuild[0]);
            timerTask = new TimerTask(){

                @Override
                public void run() {
                    DiscordRichPresence.setState(currentState);
                }
            };
            TIMER.schedule(timerTask, 1000L, 120000L);
            isEnabled = true;
            UCoreMain.LOGGER.info("Discord client found and connected.");
        }
        catch (NoDiscordClientException ex) {
            UCoreMain.LOGGER.info("Discord client was not found.");
        }
    }

    public static void stop() {
        if (timerTask != null) {
            timerTask.cancel();
            timerTask = null;
        }
        try {
            CLIENT.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        errorCount = 0;
        isEnabled = false;
        UCoreMain.LOGGER.info("Discord client closed.");
    }

    public static void setIdling() {
        DiscordRichPresence.setState(new State(EnumState.MENU));
    }

    public static void setDimension(Dimension dimension) {
        DiscordRichPresence.setState(DiscordRichPresence.getStateFromDimension(dimension));
    }

    public static State getStateFromDimension(Dimension dimension) {
        switch (dimension.func_186058_p().func_186068_a()) {
            case -1: {
                return new State(EnumState.NETHER);
            }
            case 0: {
                return new State(EnumState.OVERWORLD);
            }
            case 1: {
                return new State(EnumState.END);
            }
        }
        return new State(EnumState.DIM, DimensionType.func_212678_a((DimensionType)dimension.func_186058_p()).func_110623_a());
    }

    public static void setState(State state) {
        block7: {
            currentState = state;
            RichPresence.Builder builder = new RichPresence.Builder();
            builder.setDetails(MCPVersion.getMCVersion() + " with " + ModList.get().size() + " Mods");
            builder.setState(state.getState().getMessage(state.getReplace()));
            builder.setStartTimestamp(TIME);
            builder.setLargeImage(state.getState().getImageKey(), state.getState().getImageName(state.getReplace()));
            if (state.getState() == EnumState.MENU || state.getState() == EnumState.STARTUP) {
                builder.setSmallImage("uteamcore", "U-Team Core");
            }
            try {
                CLIENT.sendRichPresence(builder.build());
            }
            catch (Exception ex) {
                try {
                    CLIENT.connect(new DiscordBuild[0]);
                    errorCount = 0;
                    CLIENT.sendRichPresence(builder.build());
                }
                catch (Exception ex2) {
                    try {
                        CLIENT.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (++errorCount <= 10) break block7;
                    UCoreMain.LOGGER.info("Discord rich presence stopped cause connection is not working.");
                    DiscordRichPresence.stop();
                }
            }
        }
    }

    public static boolean isEnabled() {
        return isEnabled;
    }

    public static State getCurrent() {
        return currentState;
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> DiscordRichPresence.stop(), "Discord Rich Presence Stop Thread"));
    }

    public static enum EnumState {
        STARTUP("Starting Minecraft", "Minecraft", "minecraft"),
        MENU("Idling in menu", "Minecraft", "minecraft"),
        OVERWORLD("Dimension: Overworld", "Overworld", "world_overworld"),
        NETHER("Dimension: Nether", "Nether", "world_nether"),
        END("Dimension: The End", "The End", "world_the_end"),
        DIM("Dimension: %s", "%s", "world_dim");

        private String message;
        private String imagename;
        private String imagekey;

        private EnumState(String message, String imagename, String imagekey) {
            this.message = message;
            this.imagename = imagename;
            this.imagekey = imagekey;
        }

        public String getMessage(String replace) {
            return this.message.replace("%s", replace);
        }

        public String getImageName(String replace) {
            return this.imagename.replace("%s", replace);
        }

        public String getImageKey() {
            return this.imagekey;
        }
    }

    public static class State {
        private EnumState state;
        private String replace;

        public State(EnumState state) {
            this(state, "");
        }

        public State(EnumState state, String replace) {
            this.state = state;
            this.replace = replace;
        }

        public EnumState getState() {
            return this.state;
        }

        public String getReplace() {
            return this.replace;
        }
    }
}

