/*
 * Decompiled with CFR 0.152.
 */
package net.quetzi.morpheus.helpers;

import net.minecraft.block.BedBlock;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.state.IProperty;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.biome.Biomes;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.quetzi.morpheus.Morpheus;
import net.quetzi.morpheus.world.WorldSleepState;

public class MorpheusEventHandler {
    @SubscribeEvent
    public void loggedInEvent(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.getPlayer().func_130014_f_().field_72995_K) {
            if (!Morpheus.playerSleepStatus.containsKey(event.getPlayer().field_71093_bK.func_186068_a())) {
                Morpheus.playerSleepStatus.put(event.getPlayer().field_71093_bK.func_186068_a(), new WorldSleepState(event.getPlayer().field_71093_bK.func_186068_a()));
            }
            Morpheus.playerSleepStatus.get(event.getPlayer().field_71093_bK.func_186068_a()).setPlayerAwake(event.getPlayer().func_146103_bH().getName());
        }
    }

    @SubscribeEvent
    public void loggedOutEvent(PlayerEvent.PlayerLoggedOutEvent event) {
        if (!event.getPlayer().func_130014_f_().field_72995_K && Morpheus.playerSleepStatus.get(event.getPlayer().field_71093_bK.func_186068_a()) != null) {
            Morpheus.playerSleepStatus.get(event.getPlayer().field_71093_bK.func_186068_a()).removePlayer(event.getPlayer().func_146103_bH().getName());
        }
    }

    @SubscribeEvent
    public void changedDimensionEvent(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (!event.getPlayer().func_130014_f_().field_72995_K) {
            if (!Morpheus.playerSleepStatus.containsKey(event.getTo().func_186068_a())) {
                Morpheus.playerSleepStatus.put(event.getTo().func_186068_a(), new WorldSleepState(event.getTo().func_186068_a()));
            }
            if (Morpheus.playerSleepStatus.get(event.getFrom().func_186068_a()) != null) {
                Morpheus.playerSleepStatus.get(event.getFrom().func_186068_a()).removePlayer(event.getPlayer().func_146103_bH().getName());
            }
            Morpheus.playerSleepStatus.get(event.getTo().func_186068_a()).setPlayerAwake(event.getPlayer().func_146103_bH().getName());
        }
    }

    @SubscribeEvent
    public void worldTickEvent(TickEvent.WorldTickEvent event) {
        int dimid = event.world.func_201675_m().func_186058_p().func_186068_a();
        if (!event.world.field_72995_K && event.world.func_82737_E() % 20L == 10L && event.phase == TickEvent.Phase.END) {
            if (event.world.func_217369_A().size() > 0) {
                if (!Morpheus.playerSleepStatus.containsKey(dimid)) {
                    Morpheus.playerSleepStatus.put(dimid, new WorldSleepState(dimid));
                }
                Morpheus.checker.updatePlayerStates(event.world);
            } else {
                Morpheus.playerSleepStatus.remove(dimid);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void bedClicked(PlayerInteractEvent.RightClickBlock event) {
        if (Morpheus.setSpawnDaytime) {
            BlockState state;
            PlayerEntity player = event.getEntityPlayer();
            BlockPos pos = event.getPos();
            if (!event.getWorld().field_72995_K && event.getWorld().func_72935_r() && !event.getEntityPlayer().func_70093_af() && (player.getBedLocation(player.field_71093_bK) == null || player.getBedLocation(player.field_71093_bK).compareTo((Vec3i)pos) > 4) && (state = event.getWorld().func_180495_p(pos)).func_177230_c() instanceof BedBlock && event.getWorld().func_201675_m().func_76567_e() && event.getWorld().func_201675_m().getBiome(pos) != Biomes.field_76778_j && !((Boolean)state.func_177229_b((IProperty)BedBlock.field_176471_b)).booleanValue()) {
                player.setSpawnPoint(pos, false, event.getWorld().func_201675_m().func_186058_p());
                player.func_145747_a((ITextComponent)new StringTextComponent("New spawnpoint has been set!"));
                event.setCanceled(true);
            }
        }
    }
}

