/*
 * Decompiled with CFR 0.152.
 */
package net.quetzi.morpheus.helpers;

import java.util.HashMap;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.quetzi.morpheus.Morpheus;
import net.quetzi.morpheus.MorpheusRegistry;
import net.quetzi.morpheus.helpers.Config;
import net.quetzi.morpheus.helpers.DateHandler;

public class SleepChecker {
    private HashMap<Integer, Boolean> alertSent = new HashMap();

    public void updatePlayerStates(World world) {
        if (world.func_217369_A().size() > 1) {
            for (PlayerEntity player : world.func_217369_A()) {
                String username = player.func_146103_bH().getName();
                if (player.func_71026_bH() && !Morpheus.playerSleepStatus.get(player.field_71093_bK.func_186068_a()).isPlayerSleeping(username)) {
                    Morpheus.playerSleepStatus.get(player.field_71093_bK.func_186068_a()).setPlayerAsleep(username);
                    this.alertPlayers(this.createAlert(player.field_71093_bK.func_186068_a(), player.func_145748_c_().getString(), (String)Config.SERVER.onSleepText.get()), world);
                    continue;
                }
                if (player.func_71026_bH() || !Morpheus.playerSleepStatus.get(player.field_71093_bK.func_186068_a()).isPlayerSleeping(username)) continue;
                Morpheus.playerSleepStatus.get(player.field_71093_bK.func_186068_a()).setPlayerAwake(username);
                if (world.func_72935_r() || this.alertSent.get(world.func_201675_m().func_186058_p().func_186068_a()).booleanValue()) continue;
                this.alertPlayers(this.createAlert(player.field_71093_bK.func_186068_a(), player.func_145748_c_().getString(), (String)Config.SERVER.onWakeText.get()), world);
            }
            if (this.areEnoughPlayersAsleep(world.func_201675_m().func_186058_p().func_186068_a())) {
                if (!this.alertSent.containsKey(world.func_201675_m().func_186058_p().func_186068_a())) {
                    this.alertSent.put(world.func_201675_m().func_186058_p().func_186068_a(), false);
                }
                this.advanceToMorning(world);
            } else {
                this.alertSent.put(world.func_201675_m().func_186058_p().func_186068_a(), false);
            }
        }
    }

    private void alertPlayers(StringTextComponent alert, World world) {
        if (alert != null && Morpheus.isAlertEnabled()) {
            for (PlayerEntity player : world.func_217369_A()) {
                player.func_145747_a((ITextComponent)alert);
            }
        }
    }

    private StringTextComponent createAlert(int dimension, String username, String text) {
        Morpheus.logger.info(String.format("%s %s %s", username, text, Morpheus.playerSleepStatus.get(dimension).toString()));
        return new StringTextComponent(String.format("%s%s%s %s %s", TextFormatting.WHITE, username, TextFormatting.GOLD, text, Morpheus.playerSleepStatus.get(dimension).toString()));
    }

    private void advanceToMorning(World world) {
        try {
            MorpheusRegistry.registry.get(world.func_201675_m().func_186058_p().func_186068_a()).startNewDay();
        }
        catch (Exception e) {
            Morpheus.logger.error("Exception caught while starting a new day for dimension " + world.func_201675_m().func_186058_p().func_186068_a());
        }
        if (!this.alertSent.get(world.func_201675_m().func_186058_p().func_186068_a()).booleanValue()) {
            this.alertPlayers(new StringTextComponent(DateHandler.getMorningText()), world);
            Morpheus.playerSleepStatus.get(world.func_201675_m().func_186058_p().func_186068_a()).wakeAllPlayers();
            this.alertSent.put(world.func_201675_m().func_186058_p().func_186068_a(), true);
        }
        world.func_201675_m().resetRainAndThunder();
    }

    private boolean areEnoughPlayersAsleep(int dimension) {
        if (Morpheus.playerSleepStatus.get(dimension).getSleepingPlayers() > 0) {
            return (dimension == 0 || MorpheusRegistry.registry.get(dimension) != null) && Morpheus.playerSleepStatus.get(dimension).getPercentSleeping() >= (Integer)Config.SERVER.perc.get();
        }
        return false;
    }
}

