/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.shaders;

import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlStateManager;
import java.nio.IntBuffer;
import net.optifine.Config;
import net.optifine.shaders.ClippingHelperShadow;
import net.optifine.shaders.Shaders;
import org.lwjgl.opengl.EXTFramebufferObject;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;

public class ShadersRender {
    private static final qv END_PORTAL_TEXTURE = new qv("textures/entity/end_portal.png");

    public static void setFrustrumPosition(dqe frustum, double x, double y, double z) {
        frustum.a(x, y, z);
    }

    public static void setupTerrain(dng worldRenderer, cxq activeRenderInfo, dqe camera, int frameCount, boolean playerSpectator) {
        worldRenderer.a(activeRenderInfo, camera, frameCount, playerSpectator);
    }

    public static void beginTerrainSolid() {
        if (Shaders.isRenderingWorld) {
            Shaders.fogEnabled = true;
            Shaders.useProgram(Shaders.ProgramTerrain);
        }
    }

    public static void beginTerrainCutoutMipped() {
        if (Shaders.isRenderingWorld) {
            Shaders.useProgram(Shaders.ProgramTerrain);
        }
    }

    public static void beginTerrainCutout() {
        if (Shaders.isRenderingWorld) {
            Shaders.useProgram(Shaders.ProgramTerrain);
        }
    }

    public static void endTerrain() {
        if (Shaders.isRenderingWorld) {
            Shaders.useProgram(Shaders.ProgramTexturedLit);
        }
    }

    public static void beginTranslucent() {
        if (Shaders.isRenderingWorld) {
            if (Shaders.usedDepthBuffers >= 2) {
                GlStateManager.activeTexture((int)33995);
                Shaders.checkGLError("pre copy depth");
                GL11.glCopyTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)0, (int)0, (int)Shaders.renderWidth, (int)Shaders.renderHeight);
                Shaders.checkGLError("copy depth");
                GlStateManager.activeTexture((int)33984);
            }
            Shaders.useProgram(Shaders.ProgramWater);
        }
    }

    public static void endTranslucent() {
        if (Shaders.isRenderingWorld) {
            Shaders.useProgram(Shaders.ProgramTexturedLit);
        }
    }

    public static void renderHand0(dnc er, cxq activeRenderInfo, float partialTicks) {
        if (!Shaders.isShadowPass) {
            boolean blockTranslucentMain = Shaders.isItemToRenderMainTranslucent();
            boolean blockTranslucentOff = Shaders.isItemToRenderOffTranslucent();
            if (!blockTranslucentMain || !blockTranslucentOff) {
                Shaders.readCenterDepth();
                Shaders.beginHand(false);
                GL30.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                Shaders.setSkipRenderHands(blockTranslucentMain, blockTranslucentOff);
                er.renderHand(activeRenderInfo, partialTicks, true, false, false);
                Shaders.endHand();
                Shaders.setHandsRendered(!blockTranslucentMain, !blockTranslucentOff);
                Shaders.setSkipRenderHands(false, false);
            }
        }
    }

    public static void renderHand1(dnc er, cxq activeRenderInfo, float partialTicks) {
        if (!Shaders.isShadowPass && !Shaders.isBothHandsRendered()) {
            Shaders.readCenterDepth();
            GlStateManager.enableBlend();
            Shaders.beginHand(true);
            GL30.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Shaders.setSkipRenderHands(Shaders.isHandRenderedMain(), Shaders.isHandRenderedOff());
            er.renderHand(activeRenderInfo, partialTicks, true, false, true);
            Shaders.endHand();
            Shaders.setHandsRendered(true, true);
            Shaders.setSkipRenderHands(false, false);
        }
    }

    public static void renderItemFP(dne itemRenderer, float par1, boolean renderTranslucent) {
        Shaders.setRenderingFirstPersonHand(true);
        GlStateManager.depthMask((boolean)true);
        if (renderTranslucent) {
            GlStateManager.depthFunc((int)519);
            GL11.glPushMatrix();
            IntBuffer drawBuffers = Shaders.activeDrawBuffers;
            Shaders.setDrawBuffers(Shaders.drawBuffersNone);
            Shaders.renderItemKeepDepthMask = true;
            itemRenderer.a(par1);
            Shaders.renderItemKeepDepthMask = false;
            Shaders.setDrawBuffers(drawBuffers);
            GL11.glPopMatrix();
        }
        GlStateManager.depthFunc((int)515);
        GL30.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        itemRenderer.a(par1);
        Shaders.setRenderingFirstPersonHand(false);
    }

    public static void renderFPOverlay(dnc er, cxq activeRenderInfo, float partialTicks) {
        if (!Shaders.isShadowPass) {
            Shaders.beginFPOverlay();
            er.renderHand(activeRenderInfo, partialTicks, false, true, false);
            Shaders.endFPOverlay();
        }
    }

    public static void beginBlockDamage() {
        if (Shaders.isRenderingWorld) {
            Shaders.useProgram(Shaders.ProgramDamagedBlock);
            if (Shaders.ProgramDamagedBlock.getId() == Shaders.ProgramTerrain.getId()) {
                Shaders.setDrawBuffers(Shaders.drawBuffersColorAtt0);
                GlStateManager.depthMask((boolean)false);
            }
        }
    }

    public static void endBlockDamage() {
        if (Shaders.isRenderingWorld) {
            GlStateManager.depthMask((boolean)true);
            Shaders.useProgram(Shaders.ProgramTexturedLit);
        }
    }

    public static void renderShadowMap(dnc entityRenderer, cxq activeRenderInfo, int pass, float partialTicks, long finishTimeNano) {
        if (Shaders.usedShadowDepthBuffers > 0 && --Shaders.shadowPassCounter <= 0) {
            cyc mc = cyc.u();
            mc.ap().b("shadow pass");
            dng renderGlobal = mc.h;
            Shaders.isShadowPass = true;
            Shaders.shadowPassCounter = Shaders.shadowPassInterval;
            Shaders.checkGLError("pre shadow");
            GL30.glMatrixMode((int)5889);
            GL11.glPushMatrix();
            GL30.glMatrixMode((int)5888);
            GL11.glPushMatrix();
            mc.ap().b("shadow clear");
            EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)Shaders.sfb);
            Shaders.checkGLError("shadow bind sfb");
            mc.ap().b("shadow camera");
            entityRenderer.f(partialTicks);
            ShadersRender.updateActiveRenderInfo(activeRenderInfo, mc, partialTicks);
            Shaders.setCameraShadow(activeRenderInfo, partialTicks);
            Shaders.checkGLError("shadow camera");
            Shaders.useProgram(Shaders.ProgramShadow);
            GL30.glDrawBuffers((IntBuffer)Shaders.sfbDrawBuffers);
            Shaders.checkGLError("shadow drawbuffers");
            GL30.glReadBuffer((int)0);
            Shaders.checkGLError("shadow readbuffer");
            EXTFramebufferObject.glFramebufferTexture2DEXT((int)36160, (int)36096, (int)3553, (int)Shaders.sfbDepthTextures.get(0), (int)0);
            if (Shaders.usedShadowColorBuffers != 0) {
                EXTFramebufferObject.glFramebufferTexture2DEXT((int)36160, (int)36064, (int)3553, (int)Shaders.sfbColorTextures.get(0), (int)0);
            }
            Shaders.checkFramebufferStatus("shadow fb");
            GL30.glClearColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL30.glClear((int)(Shaders.usedShadowColorBuffers != 0 ? 16640 : 256));
            Shaders.checkGLError("shadow clear");
            mc.ap().b("shadow frustum");
            dqh clippingHelper = ClippingHelperShadow.getInstance();
            mc.ap().b("shadow culling");
            dqg frustum = new dqg(clippingHelper);
            csi cameraPos = activeRenderInfo.c();
            frustum.a(cameraPos.b, cameraPos.c, cameraPos.d);
            GlStateManager.shadeModel((int)7425);
            GlStateManager.enableDepthTest();
            GlStateManager.depthFunc((int)515);
            GlStateManager.depthMask((boolean)true);
            GlStateManager.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            GlStateManager.disableCull();
            mc.ap().b("shadow prepareterrain");
            mc.F().a(dxa.f);
            mc.ap().b("shadow setupterrain");
            int frameCount = 0;
            frameCount = entityRenderer.K;
            entityRenderer.K = frameCount + 1;
            renderGlobal.a(activeRenderInfo, (dqe)frustum, frameCount, mc.i.t());
            mc.ap().b("shadow updatechunks");
            mc.ap().b("shadow terrain");
            GlStateManager.matrixMode((int)5888);
            GlStateManager.pushMatrix();
            GlStateManager.disableAlphaTest();
            renderGlobal.a(bhc.a, activeRenderInfo);
            Shaders.checkGLError("shadow terrain solid");
            GlStateManager.enableAlphaTest();
            renderGlobal.a(bhc.b, activeRenderInfo);
            Shaders.checkGLError("shadow terrain cutoutmipped");
            mc.F().b(dxa.f).b(false, false);
            renderGlobal.a(bhc.c, activeRenderInfo);
            Shaders.checkGLError("shadow terrain cutout");
            mc.F().b(dxa.f).b();
            GlStateManager.shadeModel((int)7424);
            GlStateManager.alphaFunc((int)516, (float)0.1f);
            GlStateManager.matrixMode((int)5888);
            GlStateManager.popMatrix();
            GlStateManager.pushMatrix();
            mc.ap().b("shadow entities");
            renderGlobal.a(activeRenderInfo, (dqe)frustum, partialTicks);
            Shaders.checkGLError("shadow entities");
            GlStateManager.matrixMode((int)5888);
            GlStateManager.popMatrix();
            GlStateManager.depthMask((boolean)true);
            GlStateManager.disableBlend();
            GlStateManager.enableCull();
            GlStateManager.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
            GlStateManager.alphaFunc((int)516, (float)0.1f);
            if (Shaders.usedShadowDepthBuffers >= 2) {
                GlStateManager.activeTexture((int)33989);
                Shaders.checkGLError("pre copy shadow depth");
                GL11.glCopyTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)0, (int)0, (int)Shaders.shadowMapWidth, (int)Shaders.shadowMapHeight);
                Shaders.checkGLError("copy shadow depth");
                GlStateManager.activeTexture((int)33984);
            }
            GlStateManager.disableBlend();
            GlStateManager.depthMask((boolean)true);
            mc.F().a(dxa.f);
            GlStateManager.shadeModel((int)7425);
            Shaders.checkGLError("shadow pre-translucent");
            GL30.glDrawBuffers((IntBuffer)Shaders.sfbDrawBuffers);
            Shaders.checkGLError("shadow drawbuffers pre-translucent");
            Shaders.checkFramebufferStatus("shadow pre-translucent");
            if (Shaders.isRenderShadowTranslucent()) {
                mc.ap().b("shadow translucent");
                renderGlobal.a(bhc.d, activeRenderInfo);
                Shaders.checkGLError("shadow translucent");
            }
            GlStateManager.shadeModel((int)7424);
            GlStateManager.depthMask((boolean)true);
            GlStateManager.enableCull();
            GlStateManager.disableBlend();
            GL30.glFlush();
            Shaders.checkGLError("shadow flush");
            Shaders.isShadowPass = false;
            mc.ap().b("shadow postprocess");
            if (Shaders.hasGlGenMipmap) {
                if (Shaders.usedShadowDepthBuffers >= 1) {
                    if (Shaders.shadowMipmapEnabled[0]) {
                        GlStateManager.activeTexture((int)33988);
                        GlStateManager.bindTexture((int)Shaders.sfbDepthTextures.get(0));
                        GL30.glGenerateMipmap((int)3553);
                        GL30.glTexParameteri((int)3553, (int)10241, (int)(Shaders.shadowFilterNearest[0] ? 9984 : 9987));
                    }
                    if (Shaders.usedShadowDepthBuffers >= 2 && Shaders.shadowMipmapEnabled[1]) {
                        GlStateManager.activeTexture((int)33989);
                        GlStateManager.bindTexture((int)Shaders.sfbDepthTextures.get(1));
                        GL30.glGenerateMipmap((int)3553);
                        GL30.glTexParameteri((int)3553, (int)10241, (int)(Shaders.shadowFilterNearest[1] ? 9984 : 9987));
                    }
                    GlStateManager.activeTexture((int)33984);
                }
                if (Shaders.usedShadowColorBuffers >= 1) {
                    if (Shaders.shadowColorMipmapEnabled[0]) {
                        GlStateManager.activeTexture((int)33997);
                        GlStateManager.bindTexture((int)Shaders.sfbColorTextures.get(0));
                        GL30.glGenerateMipmap((int)3553);
                        GL30.glTexParameteri((int)3553, (int)10241, (int)(Shaders.shadowColorFilterNearest[0] ? 9984 : 9987));
                    }
                    if (Shaders.usedShadowColorBuffers >= 2 && Shaders.shadowColorMipmapEnabled[1]) {
                        GlStateManager.activeTexture((int)33998);
                        GlStateManager.bindTexture((int)Shaders.sfbColorTextures.get(1));
                        GL30.glGenerateMipmap((int)3553);
                        GL30.glTexParameteri((int)3553, (int)10241, (int)(Shaders.shadowColorFilterNearest[1] ? 9984 : 9987));
                    }
                    GlStateManager.activeTexture((int)33984);
                }
            }
            Shaders.checkGLError("shadow postprocess");
            EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)Shaders.dfb);
            GL11.glViewport((int)0, (int)0, (int)Shaders.renderWidth, (int)Shaders.renderHeight);
            Shaders.activeDrawBuffers = null;
            mc.F().a(dxa.f);
            Shaders.useProgram(Shaders.ProgramTerrain);
            GL30.glMatrixMode((int)5888);
            GL11.glPopMatrix();
            GL30.glMatrixMode((int)5889);
            GL11.glPopMatrix();
            GL30.glMatrixMode((int)5888);
            Shaders.checkGLError("shadow end");
        }
    }

    public static void updateActiveRenderInfo(cxq activeRenderInfo, cyc mc, float partialTicks) {
        activeRenderInfo.a((bhb)mc.g, (aio)(mc.T() == null ? mc.i : mc.T()), mc.v.aB > 0, mc.v.aB == 2, partialTicks);
    }

    public static void preRenderChunkLayer(bhc blockLayerIn) {
        if (Shaders.isRenderBackFace(blockLayerIn)) {
            GlStateManager.disableCull();
        }
        if (GLX.useVbo()) {
            GL11.glEnableClientState((int)32885);
            GL20.glEnableVertexAttribArray((int)Shaders.midTexCoordAttrib);
            GL20.glEnableVertexAttribArray((int)Shaders.tangentAttrib);
            GL20.glEnableVertexAttribArray((int)Shaders.entityAttrib);
        }
    }

    public static void postRenderChunkLayer(bhc blockLayerIn) {
        if (GLX.useVbo()) {
            GL11.glDisableClientState((int)32885);
            GL20.glDisableVertexAttribArray((int)Shaders.midTexCoordAttrib);
            GL20.glDisableVertexAttribArray((int)Shaders.tangentAttrib);
            GL20.glDisableVertexAttribArray((int)Shaders.entityAttrib);
        }
        if (Shaders.isRenderBackFace(blockLayerIn)) {
            GlStateManager.enableCull();
        }
    }

    public static void setupArrayPointersVbo() {
        int vertexSizeI = 14;
        GL11.glVertexPointer((int)3, (int)5126, (int)56, (long)0L);
        GL11.glColorPointer((int)4, (int)5121, (int)56, (long)12L);
        GL11.glTexCoordPointer((int)2, (int)5126, (int)56, (long)16L);
        GLX.glClientActiveTexture((int)GLX.GL_TEXTURE1);
        GL11.glTexCoordPointer((int)2, (int)5122, (int)56, (long)24L);
        GLX.glClientActiveTexture((int)GLX.GL_TEXTURE0);
        GL11.glNormalPointer((int)5120, (int)56, (long)28L);
        GL20.glVertexAttribPointer((int)Shaders.midTexCoordAttrib, (int)2, (int)5126, (boolean)false, (int)56, (long)32L);
        GL20.glVertexAttribPointer((int)Shaders.tangentAttrib, (int)4, (int)5122, (boolean)false, (int)56, (long)40L);
        GL20.glVertexAttribPointer((int)Shaders.entityAttrib, (int)3, (int)5122, (boolean)false, (int)56, (long)48L);
    }

    public static void beaconBeamBegin() {
        Shaders.useProgram(Shaders.ProgramBeaconBeam);
    }

    public static void beaconBeamStartQuad1() {
    }

    public static void beaconBeamStartQuad2() {
    }

    public static void beaconBeamDraw1() {
    }

    public static void beaconBeamDraw2() {
        GlStateManager.disableBlend();
    }

    public static void renderEnchantedGlintBegin() {
        Shaders.useProgram(Shaders.ProgramArmorGlint);
    }

    public static void renderEnchantedGlintEnd() {
        if (Shaders.isRenderingWorld) {
            if (Shaders.isRenderingFirstPersonHand() && Shaders.isRenderBothHands()) {
                Shaders.useProgram(Shaders.ProgramHand);
            } else {
                Shaders.useProgram(Shaders.ProgramEntities);
            }
        } else {
            Shaders.useProgram(Shaders.ProgramNone);
        }
    }

    public static boolean renderEndPortal(buy te, double x, double y, double z, float partialTicks, int destroyStage, float offset) {
        int lu;
        float du;
        if (!Shaders.isShadowPass && Shaders.activeProgram.getId() == 0) {
            return false;
        }
        GlStateManager.disableLighting();
        Config.getTextureManager().a(END_PORTAL_TEXTURE);
        cuz tessellator = cuz.a();
        cuw bufferbuilder = tessellator.c();
        bufferbuilder.a(7, cuy.g);
        float col = 0.5f;
        float r = col * 0.15f;
        float g = col * 0.3f;
        float b2 = col * 0.4f;
        float u0 = 0.0f;
        float u1 = 0.2f;
        float v0 = u0;
        float v1 = u1;
        float dv = du = (float)(System.currentTimeMillis() % 100000L) / 100000.0f;
        float dy = offset;
        int lv = lu = 240;
        if (te.a(fb.d)) {
            bufferbuilder.b(x, y, z + 1.0).a(r, g, b2, 1.0f).a((double)(u0 + du), (double)(v0 + dv)).a(lu, lv).d();
            bufferbuilder.b(x + 1.0, y, z + 1.0).a(r, g, b2, 1.0f).a((double)(u0 + du), (double)(v1 + dv)).a(lu, lv).d();
            bufferbuilder.b(x + 1.0, y + 1.0, z + 1.0).a(r, g, b2, 1.0f).a((double)(u1 + du), (double)(v1 + dv)).a(lu, lv).d();
            bufferbuilder.b(x, y + 1.0, z + 1.0).a(r, g, b2, 1.0f).a((double)(u1 + du), (double)(v0 + dv)).a(lu, lv).d();
        }
        if (te.a(fb.c)) {
            bufferbuilder.b(x, y + 1.0, z).a(r, g, b2, 1.0f).a((double)(u1 + du), (double)(v1 + dv)).a(lu, lv).d();
            bufferbuilder.b(x + 1.0, y + 1.0, z).a(r, g, b2, 1.0f).a((double)(u1 + du), (double)(v0 + dv)).a(lu, lv).d();
            bufferbuilder.b(x + 1.0, y, z).a(r, g, b2, 1.0f).a((double)(u0 + du), (double)(v0 + dv)).a(lu, lv).d();
            bufferbuilder.b(x, y, z).a(r, g, b2, 1.0f).a((double)(u0 + du), (double)(v1 + dv)).a(lu, lv).d();
        }
        if (te.a(fb.f)) {
            bufferbuilder.b(x + 1.0, y + 1.0, z).a(r, g, b2, 1.0f).a((double)(u1 + du), (double)(v1 + dv)).a(lu, lv).d();
            bufferbuilder.b(x + 1.0, y + 1.0, z + 1.0).a(r, g, b2, 1.0f).a((double)(u1 + du), (double)(v0 + dv)).a(lu, lv).d();
            bufferbuilder.b(x + 1.0, y, z + 1.0).a(r, g, b2, 1.0f).a((double)(u0 + du), (double)(v0 + dv)).a(lu, lv).d();
            bufferbuilder.b(x + 1.0, y, z).a(r, g, b2, 1.0f).a((double)(u0 + du), (double)(v1 + dv)).a(lu, lv).d();
        }
        if (te.a(fb.e)) {
            bufferbuilder.b(x, y, z).a(r, g, b2, 1.0f).a((double)(u0 + du), (double)(v0 + dv)).a(lu, lv).d();
            bufferbuilder.b(x, y, z + 1.0).a(r, g, b2, 1.0f).a((double)(u0 + du), (double)(v1 + dv)).a(lu, lv).d();
            bufferbuilder.b(x, y + 1.0, z + 1.0).a(r, g, b2, 1.0f).a((double)(u1 + du), (double)(v1 + dv)).a(lu, lv).d();
            bufferbuilder.b(x, y + 1.0, z).a(r, g, b2, 1.0f).a((double)(u1 + du), (double)(v0 + dv)).a(lu, lv).d();
        }
        if (te.a(fb.a)) {
            bufferbuilder.b(x, y, z).a(r, g, b2, 1.0f).a((double)(u0 + du), (double)(v0 + dv)).a(lu, lv).d();
            bufferbuilder.b(x + 1.0, y, z).a(r, g, b2, 1.0f).a((double)(u0 + du), (double)(v1 + dv)).a(lu, lv).d();
            bufferbuilder.b(x + 1.0, y, z + 1.0).a(r, g, b2, 1.0f).a((double)(u1 + du), (double)(v1 + dv)).a(lu, lv).d();
            bufferbuilder.b(x, y, z + 1.0).a(r, g, b2, 1.0f).a((double)(u1 + du), (double)(v0 + dv)).a(lu, lv).d();
        }
        if (te.a(fb.b)) {
            bufferbuilder.b(x, y + (double)dy, z + 1.0).a(r, g, b2, 1.0f).a((double)(u0 + du), (double)(v0 + dv)).a(lu, lv).d();
            bufferbuilder.b(x + 1.0, y + (double)dy, z + 1.0).a(r, g, b2, 1.0f).a((double)(u0 + du), (double)(v1 + dv)).a(lu, lv).d();
            bufferbuilder.b(x + 1.0, y + (double)dy, z).a(r, g, b2, 1.0f).a((double)(u1 + du), (double)(v1 + dv)).a(lu, lv).d();
            bufferbuilder.b(x, y + (double)dy, z).a(r, g, b2, 1.0f).a((double)(u1 + du), (double)(v0 + dv)).a(lu, lv).d();
        }
        tessellator.b();
        GlStateManager.enableLighting();
        return true;
    }
}

