/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.block.master;

import com.google.common.collect.Lists;
import com.lothrazar.storagenetwork.StorageNetwork;
import com.lothrazar.storagenetwork.api.capability.IConnectable;
import com.lothrazar.storagenetwork.api.capability.IConnectableItemAutoIO;
import com.lothrazar.storagenetwork.api.capability.IConnectableLink;
import com.lothrazar.storagenetwork.api.data.DimPos;
import com.lothrazar.storagenetwork.api.data.EnumStorageDirection;
import com.lothrazar.storagenetwork.api.data.IItemStackMatcher;
import com.lothrazar.storagenetwork.api.data.ItemStackMatcher;
import com.lothrazar.storagenetwork.api.util.UtilInventory;
import com.lothrazar.storagenetwork.capabilities.StorageNetworkCapabilities;
import com.lothrazar.storagenetwork.registry.SsnRegistry;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunk;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class TileMaster
extends TileEntity
implements ITickableTileEntity {
    private Set<DimPos> connectables;
    private Map<String, DimPos> importCache = new HashMap<String, DimPos>();
    private static String[] blacklist = new String[0];
    private boolean shouldRefresh = true;

    private DimPos getDimPos() {
        return new DimPos(this.field_145850_b, this.field_174879_c);
    }

    public TileMaster() {
        super(SsnRegistry.mastertile);
    }

    public List<ItemStack> getStacks() {
        ArrayList stacks = Lists.newArrayList();
        if (this.getConnectablePositions() == null) {
            this.refreshNetwork();
        }
        for (IConnectableLink storage : this.getSortedConnectableStorage()) {
            for (ItemStack stack : storage.getStoredStacks()) {
                if (stack == null || stack.func_190926_b()) continue;
                TileMaster.addOrMergeIntoList(stacks, stack.func_77946_l());
            }
        }
        return stacks;
    }

    private static void addOrMergeIntoList(List<ItemStack> list, ItemStack stackToAdd) {
        boolean added = false;
        for (ItemStack stack : list) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stackToAdd, (ItemStack)stack)) continue;
            stack.func_190920_e(stack.func_190916_E() + stackToAdd.func_190916_E());
            added = true;
            break;
        }
        if (!added) {
            list.add(stackToAdd);
        }
    }

    int emptySlots() {
        int countEmpty = 0;
        for (IConnectableLink storage : this.getSortedConnectableStorage()) {
            countEmpty += storage.getEmptySlots();
        }
        return countEmpty;
    }

    public int getAmount(ItemStackMatcher fil) {
        if (fil == null) {
            return 0;
        }
        int totalCount = 0;
        for (ItemStack stack : this.getStacks()) {
            if (!fil.match(stack)) continue;
            totalCount += stack.func_190916_E();
        }
        return totalCount;
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    private Set<DimPos> getConnectables(DimPos sourcePos) {
        HashSet<DimPos> result = new HashSet<DimPos>();
        this.addConnectables(sourcePos, result);
        return result;
    }

    private void addConnectables(DimPos sourcePos, Set<DimPos> set) {
        if (sourcePos == null || sourcePos.getWorld() == null || !sourcePos.isLoaded()) {
            return;
        }
        for (Direction direction : Direction.values()) {
            IConnectable capabilityConnectable;
            IChunk chunk;
            DimPos lookPos = sourcePos.offset(direction);
            if (!lookPos.isLoaded() || (chunk = lookPos.getChunk()) == null) continue;
            TileMaster maybeMasterTile = lookPos.getTileEntity(TileMaster.class);
            if (maybeMasterTile != null && !lookPos.equals(this.field_145850_b, this.field_174879_c)) {
                TileMaster.nukeAndDrop(lookPos);
                continue;
            }
            TileEntity tileHere = lookPos.getTileEntity(TileEntity.class);
            if (tileHere == null || (capabilityConnectable = (IConnectable)tileHere.getCapability(StorageNetworkCapabilities.CONNECTABLE_CAPABILITY, direction.func_176734_d()).orElse(null)) == null) continue;
            capabilityConnectable.setMasterPos(this.getDimPos());
            DimPos realConnectablePos = capabilityConnectable.getPos();
            boolean beenHereBefore = set.contains(realConnectablePos);
            if (beenHereBefore) continue;
            set.add(realConnectablePos);
            this.addConnectables(realConnectablePos, set);
            tileHere.func_70296_d();
            chunk.func_177427_f(true);
        }
    }

    private static void nukeAndDrop(DimPos lookPos) {
        lookPos.getWorld().func_175655_b(lookPos.getBlockPos(), true);
        lookPos.getWorld().func_175713_t(lookPos.getBlockPos());
    }

    public static boolean isTargetAllowed(BlockState BlockState2) {
        String blockId = BlockState2.func_177230_c().getRegistryName().toString();
        for (String s : blacklist) {
            if (!blockId.equals(s)) continue;
            StorageNetwork.LOGGER.info(BlockState2 + " Connection blocked by config ");
            return false;
        }
        return true;
    }

    public void refreshNetwork() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.shouldRefresh = true;
    }

    private boolean hasCachedSlot(ItemStack stack) {
        return this.importCache.containsKey(TileMaster.getStackKey(stack));
    }

    private DimPos getCachedSlot(ItemStack stack) {
        return this.importCache.get(TileMaster.getStackKey(stack));
    }

    public int insertStack(ItemStack rawStack, boolean simulate) {
        if (rawStack.func_190926_b()) {
            return 0;
        }
        ItemStack stack = rawStack.func_77946_l();
        String key = TileMaster.getStackKey(stack);
        if (this.hasCachedSlot(stack)) {
            DimPos cachedStoragePos = this.getCachedSlot(stack);
            IConnectableLink storage = cachedStoragePos.getCapability(StorageNetworkCapabilities.CONNECTABLE_ITEM_STORAGE_CAPABILITY, null);
            if (storage == null) {
                this.importCache.remove(key);
            } else {
                boolean canStillImport = storage.getSupportedTransferDirection().match(EnumStorageDirection.IN);
                if (canStillImport && storage.insertStack(stack, true).func_190916_E() < stack.func_190916_E()) {
                    stack = storage.insertStack(stack, simulate);
                } else {
                    this.importCache.remove(key);
                }
            }
        }
        if (stack.func_190926_b()) {
            return 0;
        }
        List<IConnectableLink> storages = this.getSortedConnectableStorage();
        for (IConnectableLink storage : storages) {
            if (!storage.getSupportedTransferDirection().match(EnumStorageDirection.IN) || storage.insertStack(stack, true).func_190916_E() >= stack.func_190916_E()) continue;
            stack = storage.insertStack(stack, simulate);
        }
        return stack.func_190916_E();
    }

    private static String getStackKey(ItemStack stackInCopy) {
        return stackInCopy.func_77973_b().getRegistryName().toString();
    }

    private void updateImports() {
        for (IConnectable connectable : this.getConnectables()) {
            ItemStack stack;
            IConnectableItemAutoIO storage = connectable.getPos().getCapability(StorageNetworkCapabilities.CONNECTABLE_AUTO_IO, null);
            if (storage == null || storage.ioDirection() != EnumStorageDirection.IN || !storage.runNow(connectable.getPos(), this) || (stack = storage.extractNextStack(storage.getTransferRate(), true)).func_190926_b()) continue;
            int countUnmoved = this.insertStack(stack.func_77946_l(), true);
            int countMoved = stack.func_190916_E() - countUnmoved;
            if (countMoved <= 0) continue;
            ItemStack actuallyExtracted = storage.extractNextStack(countMoved, false);
            connectable.getPos().getWorld().func_175726_f(connectable.getPos().getBlockPos()).func_76630_e();
            this.insertStack(actuallyExtracted.func_77946_l(), false);
        }
    }

    private void updateProcess() {
    }

    private void updateExports() {
        block2: for (IConnectable connectable : this.getConnectables()) {
            IConnectableItemAutoIO storage = connectable.getPos().getCapability(StorageNetworkCapabilities.CONNECTABLE_AUTO_IO, null);
            if (storage == null || storage.ioDirection() != EnumStorageDirection.OUT || !storage.runNow(connectable.getPos(), this)) continue;
            for (IItemStackMatcher matcher : storage.getAutoExportList()) {
                ItemStack realExtractedStack;
                ItemStack requestedStack;
                boolean stockMode = storage.isStockMode();
                int amtToRequest = storage.getTransferRate();
                if (stockMode) {
                    try {
                        TileEntity tileEntity = this.field_145850_b.func_175625_s(connectable.getPos().getBlockPos().func_177972_a(storage.facingInventory()));
                        IItemHandler targetInventory = (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.UP).orElse(null);
                        int stillNeeds = UtilInventory.containsAtLeastHowManyNeeded(targetInventory, matcher.getStack(), matcher.getStack().func_190916_E());
                        if (stillNeeds == 0) continue;
                        amtToRequest = Math.min(stillNeeds, amtToRequest);
                    }
                    catch (Throwable e) {
                        StorageNetwork.LOGGER.error("error thrown ", e);
                    }
                }
                if (matcher.getStack().func_190926_b() || amtToRequest == 0 || (requestedStack = this.request(matcher, amtToRequest, true)).func_190926_b()) continue;
                ItemStack insertedSim = storage.insertStack(requestedStack.func_77946_l(), true);
                ItemStack targetStack = requestedStack.func_77946_l();
                if (!insertedSim.func_190926_b()) {
                    int movedItems = requestedStack.func_190916_E() - insertedSim.func_190916_E();
                    if (movedItems <= 0) continue;
                    targetStack.func_190920_e(movedItems);
                }
                if ((realExtractedStack = this.request(new ItemStackMatcher(requestedStack, false, true), targetStack.func_190916_E(), false)).func_190926_b()) continue;
                storage.insertStack(realExtractedStack.func_77946_l(), false);
                continue block2;
            }
        }
    }

    public ItemStack request(IItemStackMatcher matcher, int size, boolean simulate) {
        if (size == 0 || matcher == null) {
            return ItemStack.field_190927_a;
        }
        IItemStackMatcher usedMatcher = matcher;
        int alreadyTransferred = 0;
        for (IConnectableLink storage : this.getSortedConnectableStorage()) {
            int req;
            ItemStack simExtract = storage.extractStack(usedMatcher, req = size - alreadyTransferred, simulate);
            if (simExtract.func_190926_b()) continue;
            usedMatcher = new ItemStackMatcher(simExtract, false, true);
            if ((alreadyTransferred += simExtract.func_190916_E()) < size) continue;
            break;
        }
        if (alreadyTransferred <= 0) {
            return ItemStack.field_190927_a;
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)usedMatcher.getStack(), (int)alreadyTransferred);
    }

    private Set<IConnectable> getConnectables() {
        Set<DimPos> positions = this.getConnectablePositions();
        if (positions == null) {
            return new HashSet<IConnectable>();
        }
        HashSet<IConnectable> result = new HashSet<IConnectable>();
        for (DimPos pos : positions) {
            TileEntity tileEntity;
            if (!pos.isLoaded() || (tileEntity = pos.getTileEntity(TileEntity.class)) == null) continue;
            IConnectable cap = (IConnectable)tileEntity.getCapability(StorageNetworkCapabilities.CONNECTABLE_CAPABILITY, null).orElse(null);
            if (cap == null) {
                StorageNetwork.LOGGER.error("Somehow stored a dimpos that is not connectable... Skipping " + pos);
                continue;
            }
            result.add(cap);
        }
        return result;
    }

    private Set<IConnectableLink> getConnectableStorage() {
        HashSet<IConnectableLink> result = new HashSet<IConnectableLink>();
        for (DimPos dimpos : this.getConnectablePositions()) {
            IConnectableLink capConnect;
            TileEntity tileEntity;
            if (!dimpos.isLoaded() || (tileEntity = dimpos.getTileEntity(TileEntity.class)) == null || (capConnect = (IConnectableLink)tileEntity.getCapability(StorageNetworkCapabilities.CONNECTABLE_ITEM_STORAGE_CAPABILITY, null).orElse(null)) == null) continue;
            result.add(capConnect);
        }
        return result;
    }

    private List<IConnectableLink> getSortedConnectableStorage() {
        return this.getConnectableStorage().stream().sorted(Comparator.comparingInt(IConnectableLink::getPriority)).collect(Collectors.toList());
    }

    public void func_73660_a() {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.getConnectablePositions() == null || this.field_145850_b.func_82737_E() % 20L == 0L || this.shouldRefresh) {
            try {
                this.connectables = this.getConnectables(this.getDimPos());
                this.shouldRefresh = false;
                this.field_145850_b.func_217349_x(this.field_174879_c).func_177427_f(true);
            }
            catch (Throwable e) {
                StorageNetwork.LOGGER.error("Refresh network error ", e);
                e.printStackTrace();
            }
        }
        this.updateImports();
        this.updateExports();
        this.updateProcess();
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT syncData = new CompoundNBT();
        this.func_189515_b(syncData);
        return new SUpdateTileEntityPacket(this.field_174879_c, 1, syncData);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public static boolean shouldRefresh(World world, BlockPos pos, BlockState oldState, BlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    public Set<DimPos> getConnectablePositions() {
        if (this.connectables == null) {
            this.connectables = new HashSet<DimPos>();
        }
        return new HashSet<DimPos>(this.connectables);
    }

    public void clearCache() {
        this.importCache = new HashMap<String, DimPos>();
    }
}

