/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.gui;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.lothrazar.storagenetwork.StorageNetwork;
import com.lothrazar.storagenetwork.api.data.EnumSortType;
import com.lothrazar.storagenetwork.api.util.UtilTileEntity;
import com.lothrazar.storagenetwork.block.request.ContainerRequest;
import com.lothrazar.storagenetwork.block.request.GuiButtonRequest;
import com.lothrazar.storagenetwork.gui.IGuiPrivate;
import com.lothrazar.storagenetwork.gui.ItemSlotNetwork;
import com.lothrazar.storagenetwork.jei.JeiHooks;
import com.lothrazar.storagenetwork.jei.JeiSettings;
import com.lothrazar.storagenetwork.network.ClearRecipeMessage;
import com.lothrazar.storagenetwork.network.InsertMessage;
import com.lothrazar.storagenetwork.network.RequestMessage;
import com.lothrazar.storagenetwork.network.SortMessage;
import com.lothrazar.storagenetwork.registry.PacketRegistry;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;

public abstract class GuiContainerStorageInventory
extends ContainerScreen<ContainerRequest>
implements IGuiPrivate {
    private static final int HEIGHT = 256;
    private static final int WIDTH = 176;
    private final ResourceLocation texture = new ResourceLocation("storagenetwork", "textures/gui/request.png");
    private int page = 1;
    private int maxPage = 1;
    private List<ItemStack> stacks;
    private List<ItemStack> craftableStacks;
    private ItemStack stackUnderMouse = ItemStack.field_190927_a;
    private TextFieldWidget searchBar;
    private List<ItemSlotNetwork> slots;
    private long lastClick;
    private boolean forceFocus;
    private GuiButtonRequest directionBtn;
    private GuiButtonRequest sortBtn;
    private GuiButtonRequest jeiBtn;
    private GuiButtonRequest clearTextBtn;

    public GuiContainerStorageInventory(ContainerRequest container, PlayerInventory inv, ITextComponent name) {
        super((Container)container, inv, name);
        this.field_146999_f = 176;
        this.field_147000_g = 256;
        this.stacks = Lists.newArrayList();
        this.craftableStacks = Lists.newArrayList();
        PacketRegistry.INSTANCE.sendToServer((Object)new RequestMessage());
        this.lastClick = System.currentTimeMillis();
    }

    private boolean canClick() {
        return System.currentTimeMillis() > this.lastClick + 100L;
    }

    public void setStacks(List<ItemStack> stacks) {
        this.stacks = stacks;
    }

    public void setCraftableStacks(List<ItemStack> stacks) {
        this.craftableStacks = stacks;
    }

    public void init() {
        super.init();
        this.font.getClass();
        this.searchBar = new TextFieldWidget(this.font, this.field_147003_i + 81, this.field_147009_r + 96, 85, 9, "search");
        this.searchBar.func_146203_f(30);
        this.searchBar.func_146185_a(false);
        this.searchBar.func_146189_e(true);
        this.searchBar.func_146193_g(0xFFFFFF);
        this.searchBar.func_146195_b(true);
        if (JeiSettings.isJeiLoaded() && JeiSettings.isJeiSearchSynced()) {
            this.searchBar.func_146180_a(JeiHooks.getFilterText());
        }
        int y = this.searchBar.y - 3;
        this.directionBtn = new GuiButtonRequest(this.field_147003_i + 7, y, "", p -> {
            this.setDownwards(!this.getDownwards());
            this.syncData();
        });
        this.directionBtn.setHeight(16);
        this.addButton((Widget)this.directionBtn);
        this.sortBtn = new GuiButtonRequest(this.field_147003_i + 21, y, "", p -> {
            this.setSort(this.getSort().next());
            this.syncData();
        });
        this.sortBtn.setHeight(16);
        this.addButton((Widget)this.sortBtn);
        this.jeiBtn = new GuiButtonRequest(this.field_147003_i + 35, y, "", p -> StorageNetwork.LOGGER.info("TODOjeiBtn "));
        if (JeiSettings.isJeiLoaded()) {
            this.addButton((Widget)this.jeiBtn);
        }
        this.clearTextBtn = new GuiButtonRequest(this.field_147003_i + 64, y, "X", p -> this.clearSearch());
        this.clearTextBtn.setHeight(16);
        this.addButton((Widget)this.clearTextBtn);
    }

    private void syncData() {
        PacketRegistry.INSTANCE.sendToServer((Object)new SortMessage(this.getPos(), this.getDownwards(), this.getSort()));
    }

    private int getLines() {
        return 4;
    }

    private static int getColumns() {
        return 9;
    }

    public abstract boolean getDownwards();

    public abstract void setDownwards(boolean var1);

    public abstract EnumSortType getSort();

    public abstract void setSort(EnumSortType var1);

    public abstract BlockPos getPos();

    private static int getDim() {
        return 0;
    }

    private boolean inField(int mouseX, int mouseY) {
        int h = 90;
        return mouseX > this.field_147003_i + 7 && mouseX < this.field_147003_i + this.field_146999_f - 7 && mouseY > this.field_147009_r + 7 && mouseY < this.field_147009_r + h;
    }

    private boolean inSearchbar(double mouseX, double mouseY) {
        int n = this.searchBar.x - this.field_147003_i + 14;
        int n2 = this.searchBar.y - this.field_147009_r;
        int n3 = this.searchBar.getWidth();
        this.font.getClass();
        return this.func_195359_a(n, n2, n3, 9 + 6, mouseX, mouseY);
    }

    private boolean doesStackMatchSearch(ItemStack stack) {
        String searchText = this.searchBar.func_146179_b();
        if (searchText.startsWith("@")) {
            String name = UtilTileEntity.getModNameForItem(stack.func_77973_b());
            return name.toLowerCase().contains(searchText.toLowerCase().substring(1));
        }
        if (searchText.startsWith("#")) {
            Minecraft mc = Minecraft.func_71410_x();
            List tooltip = stack.func_82840_a((PlayerEntity)mc.field_71439_g, (ITooltipFlag)ITooltipFlag.TooltipFlags.NORMAL);
            String tooltipString = Joiner.on((char)' ').join((Iterable)tooltip).toLowerCase();
            return tooltipString.toLowerCase().contains(searchText.toLowerCase().substring(1));
        }
        return stack.func_200301_q().toString().toLowerCase().contains(searchText.toLowerCase());
    }

    public void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.renderTextures();
        List<ItemStack> stacksToDisplay = this.applySearchTextToSlots();
        this.sortStackWrappers(stacksToDisplay);
        this.applyScrollPaging(stacksToDisplay);
        this.rebuildItemSlots(stacksToDisplay);
        this.renderItemSlots(mouseX, mouseY);
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        super.render(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
        this.searchBar.render(mouseX, mouseY, partialTicks);
    }

    private void renderTextures() {
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.minecraft.func_110434_K().func_110577_a(this.texture);
        int xCenter = (this.width - this.field_146999_f) / 2;
        int yCenter = (this.height - this.field_147000_g) / 2;
        this.blit(xCenter, yCenter, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    private List<ItemStack> applySearchTextToSlots() {
        ArrayList stacksToDisplay;
        String searchText = this.searchBar.func_146179_b();
        ArrayList arrayList = stacksToDisplay = searchText.equals("") ? Lists.newArrayList(this.stacks) : Lists.newArrayList();
        if (!searchText.equals("")) {
            for (ItemStack stack : this.stacks) {
                if (!this.doesStackMatchSearch(stack)) continue;
                stacksToDisplay.add(stack);
            }
        }
        return stacksToDisplay;
    }

    @Override
    public boolean isInRegion(int rectX, int rectY, int rectWidth, int rectHeight, int pointX, int pointY) {
        return super.func_195359_a(rectX, rectY, rectWidth, rectHeight, (double)pointX, (double)pointY);
    }

    @Override
    public void renderStackToolTip(ItemStack stack, int x, int y) {
        super.renderTooltip(stack, x, y);
    }

    @Override
    public void drawGradientRect(int left, int top, int right, int bottom, int startColor, int endColor) {
        super.fillGradient(left, top, right, bottom, startColor, endColor);
    }

    private void renderItemSlots(int mouseX, int mouseY) {
        this.stackUnderMouse = ItemStack.field_190927_a;
        for (ItemSlotNetwork slot : this.slots) {
            slot.drawSlot(this.font, mouseX, mouseY);
            if (!slot.isMouseOverSlot(mouseX, mouseY)) continue;
            this.stackUnderMouse = slot.getStack();
        }
        if (this.slots.isEmpty()) {
            this.stackUnderMouse = ItemStack.field_190927_a;
        }
    }

    private void rebuildItemSlots(List<ItemStack> stacksToDisplay) {
        this.slots = Lists.newArrayList();
        int index = (this.page - 1) * GuiContainerStorageInventory.getColumns();
        for (int row = 0; row < this.getLines(); ++row) {
            for (int col = 0; col < GuiContainerStorageInventory.getColumns() && index < stacksToDisplay.size(); ++col) {
                int in = index++;
                this.slots.add(new ItemSlotNetwork(this, stacksToDisplay.get(in), this.field_147003_i + 8 + col * 18, this.field_147009_r + 10 + row * 18, stacksToDisplay.get(in).func_190916_E(), this.field_147003_i, this.field_147009_r, true));
            }
        }
    }

    private void applyScrollPaging(List<ItemStack> stacksToDisplay) {
        this.maxPage = stacksToDisplay.size() / GuiContainerStorageInventory.getColumns();
        if (stacksToDisplay.size() % GuiContainerStorageInventory.getColumns() != 0) {
            ++this.maxPage;
        }
        this.maxPage -= this.getLines() - 1;
        if (this.maxPage < 1) {
            this.maxPage = 1;
        }
        if (this.page < 1) {
            this.page = 1;
        }
        if (this.page > this.maxPage) {
            this.page = this.maxPage;
        }
    }

    private void sortStackWrappers(List<ItemStack> stacksToDisplay) {
        Collections.sort(stacksToDisplay, new Comparator<ItemStack>(){
            final int mul;
            {
                this.mul = GuiContainerStorageInventory.this.getDownwards() ? -1 : 1;
            }

            @Override
            public int compare(ItemStack o2, ItemStack o1) {
                switch (GuiContainerStorageInventory.this.getSort()) {
                    case AMOUNT: {
                        return Integer.compare(o1.func_190916_E(), o2.func_190916_E()) * this.mul;
                    }
                    case NAME: {
                        return o2.func_200301_q().toString().compareToIgnoreCase(o1.func_200301_q().toString()) * this.mul;
                    }
                    case MOD: {
                        return UtilTileEntity.getModNameForItem(o2.func_77973_b()).compareToIgnoreCase(UtilTileEntity.getModNameForItem(o1.func_77973_b())) * this.mul;
                    }
                }
                return 0;
            }
        });
    }

    public void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        if (this.forceFocus && this.searchBar != null) {
            this.searchBar.func_146195_b(true);
            if (this.searchBar.isFocused()) {
                this.forceFocus = false;
            }
        }
        this.directionBtn.setMessage(this.getDownwards() ? "D" : "U");
        String sort = "";
        switch (this.getSort()) {
            case NAME: {
                sort = "N";
                break;
            }
            case MOD: {
                sort = "@";
                break;
            }
            case AMOUNT: {
                sort = "#";
            }
        }
        this.sortBtn.setMessage(sort);
        this.drawTooltips(mouseX, mouseY);
    }

    private void drawTooltips(int mouseX, int mouseY) {
        if (this.clearTextBtn != null && this.clearTextBtn.isMouseOver(mouseX, mouseY)) {
            this.renderTooltip(Lists.newArrayList((Object[])new String[]{I18n.func_135052_a((String)"gui.storagenetwork.tooltip_clear", (Object[])new Object[0])}), mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        }
        if (this.sortBtn != null && this.sortBtn.isMouseOver(mouseX, mouseY)) {
            this.renderTooltip(Lists.newArrayList((Object[])new String[]{I18n.func_135052_a((String)("gui.storagenetwork.req.tooltip_" + (Object)((Object)this.getSort())), (Object[])new Object[0])}), mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        }
        if (this.directionBtn != null && this.directionBtn.isMouseOver(mouseX, mouseY)) {
            this.renderTooltip(Lists.newArrayList((Object[])new String[]{I18n.func_135052_a((String)"gui.storagenetwork.sort", (Object[])new Object[0])}), mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        }
        if (JeiSettings.isJeiLoaded() && this.jeiBtn != null && this.jeiBtn.isMouseOver(mouseX, mouseY)) {
            String s = I18n.func_135052_a((String)(JeiSettings.isJeiSearchSynced() ? "gui.storagenetwork.fil.tooltip_jei_on" : "gui.storagenetwork.fil.tooltip_jei_off"), (Object[])new Object[0]);
            this.renderTooltip(Lists.newArrayList((Object[])new String[]{s}), mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        }
        for (ItemSlotNetwork s : this.slots) {
            if (s == null || !s.isMouseOverSlot(mouseX, mouseY)) continue;
            s.drawTooltip(mouseX, mouseY);
        }
        if (this.inSearchbar(mouseX, mouseY)) {
            ArrayList lis = Lists.newArrayList();
            if (!Screen.hasShiftDown()) {
                lis.add(I18n.func_135052_a((String)"gui.storagenetwork.shift", (Object[])new Object[0]));
            } else {
                lis.add(I18n.func_135052_a((String)"gui.storagenetwork.fil.tooltip_0", (Object[])new Object[0]));
                lis.add(I18n.func_135052_a((String)"gui.storagenetwork.fil.tooltip_1", (Object[])new Object[0]));
                lis.add(I18n.func_135052_a((String)"gui.storagenetwork.fil.tooltip_3", (Object[])new Object[0]));
            }
            this.renderTooltip(lis, mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        }
    }

    public void onClose() {
        super.onClose();
    }

    private void clearSearch() {
        if (this.searchBar == null) {
            return;
        }
        this.searchBar.func_146180_a("");
        if (JeiSettings.isJeiSearchSynced()) {
            JeiHooks.setFilterText("");
        }
    }

    public boolean isScrollable(double x, double y) {
        return this.func_195359_a(0, 0, this.width - 8, 135, x, y);
    }

    public boolean mouseScrolled(double x, double y, double mouseButton) {
        super.mouseScrolled(x, y, mouseButton);
        if (this.isScrollable(x, y) && mouseButton != 0.0) {
            boolean snd = false;
            if (mouseButton > 0.0 && this.page > 1) {
                --this.page;
                snd = true;
            }
            if (mouseButton < 0.0 && this.page < this.maxPage) {
                ++this.page;
                snd = true;
            }
            if (snd) {
                // empty if block
            }
        }
        return true;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        super.mouseClicked(mouseX, mouseY, mouseButton);
        this.searchBar.func_146195_b(false);
        int rectX = 63;
        int rectY = 110;
        if (this.inSearchbar(mouseX, mouseY)) {
            this.searchBar.func_146195_b(true);
            if (mouseButton == 1) {
                this.clearSearch();
            }
        } else if (this.func_195359_a(rectX, rectY, 7, 7, mouseX, mouseY)) {
            PacketRegistry.INSTANCE.sendToServer((Object)new ClearRecipeMessage());
            PacketRegistry.INSTANCE.sendToServer((Object)new RequestMessage(0, ItemStack.field_190927_a, false, false));
        } else {
            if (this.searchBar.mouseClicked(mouseX, mouseY, mouseButton)) {
                if (mouseButton == 1) {
                    this.clearSearch();
                }
                return true;
            }
            ItemStack stackCarriedByMouse = this.minecraft.field_71439_g.field_71071_by.func_70445_o();
            if (!this.stackUnderMouse.func_190926_b() && (mouseButton == 0 || mouseButton == 1) && stackCarriedByMouse.func_190926_b() && this.canClick()) {
                ItemStack copyNotNegativeAir = new ItemStack((IItemProvider)this.stackUnderMouse.func_77973_b());
                PacketRegistry.INSTANCE.sendToServer((Object)new RequestMessage(mouseButton, copyNotNegativeAir, Screen.hasShiftDown(), Screen.hasAltDown() || Screen.hasControlDown()));
                this.lastClick = System.currentTimeMillis();
            } else if (!stackCarriedByMouse.func_190926_b() && this.inField((int)mouseX, (int)mouseY) && this.canClick()) {
                PacketRegistry.INSTANCE.sendToServer((Object)new InsertMessage(GuiContainerStorageInventory.getDim(), mouseButton, stackCarriedByMouse));
                this.lastClick = System.currentTimeMillis();
            }
        }
        return true;
    }

    public boolean keyPressed(int x, int y, int b) {
        InputMappings.Input mouseKey = InputMappings.func_197954_a((int)x, (int)y);
        if (x == 256) {
            this.minecraft.field_71439_g.func_71053_j();
            return true;
        }
        if (this.searchBar.isFocused()) {
            this.searchBar.keyPressed(x, y, b);
            return true;
        }
        if (this.minecraft.field_71474_y.field_151445_Q.isActiveAndMatches(mouseKey)) {
            this.minecraft.field_71439_g.func_71053_j();
            return true;
        }
        return super.keyPressed(x, y, b);
    }

    public boolean charTyped(char typedChar, int keyCode) {
        if (this.searchBar.isFocused() && this.searchBar.charTyped(typedChar, keyCode)) {
            PacketRegistry.INSTANCE.sendToServer((Object)new RequestMessage(0, ItemStack.field_190927_a, false, false));
            if (JeiSettings.isJeiLoaded() && JeiSettings.isJeiSearchSynced()) {
                JeiHooks.setFilterText(this.searchBar.func_146179_b());
            }
            return true;
        }
        if (!this.stackUnderMouse.func_190926_b()) {
            // empty if block
        }
        return false;
    }
}

