/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.justmobheads.util;

import com.mojang.datafixers.util.Pair;
import com.natamus.justmobheads.util.HeadData;
import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.merchant.villager.VillagerData;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.ZombieVillagerEntity;
import net.minecraft.entity.passive.CatEntity;
import net.minecraft.entity.passive.MooshroomEntity;
import net.minecraft.entity.passive.ParrotEntity;
import net.minecraft.entity.passive.RabbitEntity;
import net.minecraft.entity.passive.SheepEntity;
import net.minecraft.entity.passive.horse.HorseEntity;
import net.minecraft.entity.passive.horse.LlamaEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class MobHeads {
    static List<String> ocelottypes = Arrays.asList("", "black", "ginger", "siamese");
    static List<String> horsetypes = Arrays.asList("white", "creamy", "chestnut", "brown", "black", "gray", "dark_brown");
    static List<String> llamatypes = Arrays.asList("creamy", "white", "brown", "gray");
    static List<String> parrottypes = Arrays.asList("red", "blue", "green", "cyan", "gray");
    static List<String> rabbittypes = Arrays.asList("brown", "white", "black", "black_and_white", "gold", "salt_and_pepper");
    static List<String> cattypes = Arrays.asList("tabby", "tuxedo", "red", "siamese", "british_shorthair", "calico", "persian", "ragdoll", "white", "jellie", "black");

    public static ItemStack getMobHead(String mobname) {
        Pair<String, String> mobdata = HeadData.headdata.get(mobname);
        ItemStack mobhead = new ItemStack((IItemProvider)Items.field_196184_dx, 1);
        if (mobdata == null) {
            return mobhead;
        }
        CompoundNBT skullOwner = new CompoundNBT();
        skullOwner.func_74778_a("Id", (String)mobdata.getFirst());
        CompoundNBT properties = new CompoundNBT();
        ListNBT textures = new ListNBT();
        CompoundNBT tex = new CompoundNBT();
        tex.func_74778_a("Value", (String)mobdata.getSecond());
        textures.add((Object)tex);
        properties.func_218657_a("textures", (INBT)textures);
        skullOwner.func_218657_a("Properties", (INBT)properties);
        mobhead.func_77983_a("SkullOwner", (INBT)skullOwner);
        String name = MobHeads.capitalizeFirst(mobname.replace("_", " "));
        StringTextComponent tcname = new StringTextComponent(name + " Head");
        mobhead.func_200302_a((ITextComponent)tcname);
        return mobhead;
    }

    public static ItemStack getStandardHead(String headname) {
        ItemStack mobhead = new ItemStack((IItemProvider)Items.field_196184_dx, 1);
        String mob = headname.toLowerCase().split(" ")[0];
        if (mob.equals("creeper")) {
            mobhead = new ItemStack((IItemProvider)Items.field_196185_dy, 1);
        } else if (mob.equals("zombie")) {
            mobhead = new ItemStack((IItemProvider)Items.field_196186_dz, 1);
        } else if (mob.equals("skeleton")) {
            mobhead = new ItemStack((IItemProvider)Items.field_196182_dv, 1);
        }
        mobhead.func_200302_a((ITextComponent)new StringTextComponent(headname));
        return mobhead;
    }

    public static String getName(Entity entity, Boolean dropchance) {
        String mobname = entity.toString().split("\\[")[0].replace("Entity", "");
        mobname = String.join((CharSequence)"_", mobname.split("(?<=.)(?=\\p{Lu})")).toLowerCase();
        if (entity instanceof CreeperEntity) {
            CreeperEntity creeper = (CreeperEntity)entity;
            if (creeper.func_70830_n()) {
                mobname = "charged_creeper";
            }
        } else {
            ZombieVillagerEntity zombievillager;
            VillagerData d;
            VillagerProfession prof;
            if (dropchance.booleanValue()) {
                return mobname;
            }
            if (entity instanceof CatEntity) {
                CatEntity cat = (CatEntity)entity;
                Integer type = cat.func_213413_ef();
                if (type <= cattypes.size()) {
                    mobname = cattypes.get(type) + "_cat";
                }
            } else if (entity instanceof HorseEntity) {
                HorseEntity horse = (HorseEntity)entity;
                Integer type = horse.func_110202_bQ();
                if (type >= 1024) {
                    type = type - 1024;
                } else if (type >= 768) {
                    type = type - 768;
                } else if (type >= 512) {
                    type = type - 512;
                } else if (type >= 256) {
                    type = type - 256;
                }
                mobname = horsetypes.get(type) + "_horse";
            } else if (entity instanceof LlamaEntity) {
                LlamaEntity llama = (LlamaEntity)entity;
                Integer type = llama.func_190719_dM();
                mobname = llamatypes.get(type) + "_" + mobname;
            } else if (entity instanceof ParrotEntity) {
                ParrotEntity parrot = (ParrotEntity)entity;
                Integer type = parrot.func_191998_ds();
                mobname = parrottypes.get(type) + "_parrot";
            } else if (entity instanceof RabbitEntity) {
                RabbitEntity rabbit = (RabbitEntity)entity;
                Integer type = rabbit.func_175531_cl();
                if (type < rabbittypes.size()) {
                    mobname = rabbittypes.get(type) + "_rabbit";
                } else if (type == 99) {
                    mobname = "killer_rabbit";
                }
            } else if (entity instanceof SheepEntity) {
                SheepEntity sheep = (SheepEntity)entity;
                DyeColor type = sheep.func_175509_cj();
                mobname = type.toString().toLowerCase() + "_sheep";
            } else if (entity instanceof MooshroomEntity) {
                MooshroomEntity mooshroom = (MooshroomEntity)entity;
                if (mooshroom.func_213444_dV() == MooshroomEntity.Type.BROWN) {
                    mobname = "brown_mooshroom";
                }
            } else if (entity instanceof VillagerEntity) {
                VillagerEntity villager = (VillagerEntity)entity;
                VillagerData d2 = villager.func_213700_eh();
                VillagerProfession prof2 = d2.func_221130_b();
                if (prof2.toString() != "none") {
                    mobname = prof2.toString();
                }
            } else if (entity instanceof ZombieVillagerEntity && (prof = (d = (zombievillager = (ZombieVillagerEntity)entity).func_213700_eh()).func_221130_b()).toString() != "none") {
                mobname = "zombie_" + prof.toString();
            }
        }
        return mobname;
    }

    public static String capitalizeFirst(String string) {
        StringBuffer sb = new StringBuffer(string);
        for (int i = 0; i < sb.length(); ++i) {
            if (i != 0 && sb.charAt(i - 1) != ' ') continue;
            sb.setCharAt(i, Character.toUpperCase(sb.charAt(i)));
        }
        return sb.toString();
    }
}

